/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.camposdinamicos.Alternativa;
import br.com.elotech.tributos.domain.camposdinamicos.Campo;
import br.com.elotech.tributos.domain.rural.CadastroRural;
import br.com.elotech.tributos.dto.integracaoelogeo.BoletimElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.CadastroRuralElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.CadastroRuralPostElogeoDTO;
import br.com.elotech.tributos.repository.camposdinamicos.CampoAlternativaRepository;
import br.com.elotech.tributos.repository.camposdinamicos.CampoRepository;
import br.com.elotech.tributos.repository.camposdinamicos.RespostaRepository;
import br.com.elotech.tributos.service.BairroService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CadastroRuralService;
import br.com.elotech.tributos.service.CondominioService;
import br.com.elotech.tributos.service.DistritoService;
import br.com.elotech.tributos.service.LogradouroService;
import br.com.elotech.tributos.service.LoteamentoService;
import br.com.elotech.tributos.service.SetorQuadraService;
import br.com.elotech.tributos.service.SetorService;
import br.com.elotech.tributos.service.integracaoelogeo.CadastroRuralElogeoServiceAbstract;
import java.util.List;
import java.util.Objects;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!onpremise"})
public class OxyCadastroRuralElogeoService
extends CadastroRuralElogeoServiceAbstract {
    private final RespostaRepository respostaRepository;
    private final CampoAlternativaRepository campoAlternativaRepository;
    private final CampoRepository campoRepository;

    public OxyCadastroRuralElogeoService(CadastroGeralService cadastroGeralService, CadastroRuralService cadastroRuralService, DistritoService distritoService, SetorService setorService, BairroService bairroService, SetorQuadraService setorQuadraService, LogradouroService logradouroService, LoteamentoService loteamentoService, CondominioService condominioService, RespostaRepository respostaRepository, CampoAlternativaRepository campoAlternativaRepository, CampoRepository campoRepository) {
        super(cadastroGeralService, cadastroRuralService, distritoService, setorService, bairroService, setorQuadraService, logradouroService, loteamentoService, condominioService);
        this.respostaRepository = respostaRepository;
        this.campoAlternativaRepository = campoAlternativaRepository;
        this.campoRepository = campoRepository;
    }

    protected CadastroRuralElogeoDTO entityToElogeoDTO(CadastroRural cadastroRural) {
        List boletim = this.respostaRepository.getRespostasFromRural(cadastroRural.getId());
        CadastroRuralElogeoDTO cadastroRuralElogeoDTO = CadastroRuralElogeoDTO.oxyFrom((CadastroRural)cadastroRural, (List)boletim);
        return cadastroRuralElogeoDTO;
    }

    protected CadastroRural prepareElogeoToSave(CadastroRural cadastroRuralToSave, Boolean novoCadastro, CadastroRuralPostElogeoDTO cadastroRuralPostElogeoDTO) {
        cadastroRuralPostElogeoDTO.getBoletim().stream().map(respostaBoletim -> {
            Alternativa alternativa = null;
            Campo campo = null;
            if (Objects.nonNull(respostaBoletim.getResposta().getCodigo())) {
                alternativa = this.findAlternativa(respostaBoletim);
            }
            if (Objects.nonNull(respostaBoletim.getResposta().getCampo())) {
                campo = this.findCampo(respostaBoletim);
            }
            return respostaBoletim.toEntityRespostaRural(cadastroRuralToSave, alternativa, campo, respostaBoletim.getResposta().getId());
        }).forEach(cadastroRuralToSave.getRespostasRurais()::add);
        if (!novoCadastro.booleanValue() && cadastroRuralToSave.getCadastroGeral() != null) {
            CadastroRural cadastroRuralFound = (CadastroRural)this.cadastroRuralService.findByCadastroGeral(cadastroRuralToSave.getCadastroGeral()).orElseThrow(() -> new EloValidationException("Cadastro Rural n\u00e3o encontrado"));
            return cadastroRuralFound.mergeElogeo(cadastroRuralToSave);
        }
        return cadastroRuralToSave;
    }

    protected void mergeBoletins(CadastroRuralPostElogeoDTO cadastroRuralPostElogeoDTO, CadastroRural cadastroRural) {
        this.respostaRepository.saveAll((Iterable)cadastroRural.getRespostasRurais());
    }

    protected Campo findCampo(BoletimElogeoDTO respostaBoletim) {
        return (Campo)this.campoRepository.findById((Object)respostaBoletim.getResposta().getCampo().getId()).orElseThrow(() -> new EloValidationException(String.format("Campo %s do Boletim n\u00e3o encontrado.", respostaBoletim.getResposta().getCampo().getCodigo())));
    }

    protected Alternativa findAlternativa(BoletimElogeoDTO respostaBoletim) {
        return (Alternativa)this.campoAlternativaRepository.findById((Object)respostaBoletim.getResposta().getCodigo()).orElseThrow(() -> new EloValidationException(String.format("Alternativa %s do Boletim n\u00e3o encontrado.", respostaBoletim.getResposta().getCodigo())));
    }
}

