/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.integracaoelogeo.CadastroMobiliarioElogeoDTO;
import br.com.elotech.tributos.service.CadastroMobiliarioService;
import br.com.elotech.tributos.service.integracaoelogeo.CadastroMobiliarioElogeo;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CadastroMobiliarioElogeoService
implements CadastroMobiliarioElogeo {
    private static final Logger LOGGER = LoggerFactory.getLogger(CadastroMobiliarioElogeoService.class);
    private final CadastroMobiliarioService cadastroMobiliarioService;

    public CadastroMobiliarioElogeoService(CadastroMobiliarioService cadastroMobiliarioService) {
        this.cadastroMobiliarioService = cadastroMobiliarioService;
    }

    public CadastroMobiliarioElogeoDTO findByCadastroGeralElogeoDTO(Long cadastroGeral) {
        CadastroMobiliario cadastroMobiliario = this.cadastroMobiliarioService.findByTipoCadastroAndCadastroGeral(TipoCadastro.MOBILIARIO, cadastroGeral);
        if (Objects.isNull(cadastroMobiliario)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel localizar o Cadastro Mobili\u00e1rio com o C\u00f3digo '%d'.", cadastroGeral));
        }
        return this.entityToElogeoDTO(cadastroMobiliario);
    }

    public List<CadastroMobiliarioElogeoDTO> findCadastroGeralAlteradosElogeoDTO(LocalDate dataInicial, LocalDate dataFinal) {
        List cadastroMobiliario = this.cadastroMobiliarioService.findByDataAlteracaoBetween(dataInicial, dataFinal);
        if (cadastroMobiliario.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel localizar o Cadastro Mobili\u00e1rio nesse p\u00e9riodo informado");
        }
        return this.entityToElogeoDTOList(cadastroMobiliario);
    }

    public List<CadastroMobiliarioElogeoDTO> findCadastroGeralNovosElogeoDTO(LocalDate dataInicial, LocalDate dataFinal) {
        List cadastroMobiliario = this.cadastroMobiliarioService.findByDataInclusaoBetween(dataInicial, dataFinal);
        if (cadastroMobiliario.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel localizar o Cadastro Mobili\u00e1rio nesse p\u00e9riodo informado");
        }
        return this.entityToElogeoDTOList(cadastroMobiliario);
    }

    protected CadastroMobiliarioElogeoDTO entityToElogeoDTO(CadastroMobiliario cadastroMobiliario) {
        CadastroMobiliarioElogeoDTO cadastroMobiliarioElogeoDTO = CadastroMobiliarioElogeoDTO.from((CadastroMobiliario)cadastroMobiliario);
        return cadastroMobiliarioElogeoDTO;
    }

    protected List<CadastroMobiliarioElogeoDTO> entityToElogeoDTOList(List<CadastroMobiliario> cadastroMobiliario) {
        ArrayList<CadastroMobiliarioElogeoDTO> cadastroMobiliarioElogeoDTOList = new ArrayList<CadastroMobiliarioElogeoDTO>();
        for (CadastroMobiliario cadastro : cadastroMobiliario) {
            CadastroMobiliarioElogeoDTO cadastroMobiliarioElogeoDTO = CadastroMobiliarioElogeoDTO.from((CadastroMobiliario)cadastro);
            cadastroMobiliarioElogeoDTOList.add(cadastroMobiliarioElogeoDTO);
        }
        return cadastroMobiliarioElogeoDTOList;
    }
}

