/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaocontabil;

import br.com.elotech.tributos.dto.FiltroArrecadacaoPorTributoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorTributoResumoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorTributoValoresDTO;
import br.com.elotech.tributos.repository.integracaocontabil.ArrecadacaoPorTributoRepository;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ArrecadacaoPorTributoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArrecadacaoPorTributoService.class);
    private final ArrecadacaoPorTributoRepository arrecadacaoPorTributoRepository;

    public ArrecadacaoPorTributoService(ArrecadacaoPorTributoRepository arrecadacaoPorTributoRepository) {
        this.arrecadacaoPorTributoRepository = arrecadacaoPorTributoRepository;
    }

    public Page<ArrecadacaoPorTributoValoresDTO> imprimir(FiltroArrecadacaoPorTributoDTO filtro, Pageable pageable) {
        filtro.validaDatas();
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.debug("Imprimir - resumo arrecada\u00e7\u00e3o por tributo...");
        List listTributoValores = this.arrecadacaoPorTributoRepository.queryArrecadacaoPorTributo(filtro);
        log.debug("Imprimir - resumo arrecada\u00e7\u00e3o por tributo levou {}", (Object)stopwatch.stop());
        return this.getValoresArrecadacaoPorTributo(listTributoValores, pageable, true);
    }

    public ArrecadacaoPorTributoResumoDTO getArrecadacaoPorTributo(FiltroArrecadacaoPorTributoDTO filtro, Pageable pageable) {
        ArrecadacaoPorTributoResumoDTO resumo = new ArrecadacaoPorTributoResumoDTO();
        filtro.validaDatas();
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.debug("Consultando resumo arrecada\u00e7\u00e3o por tributo...");
        List listTributoValores = this.arrecadacaoPorTributoRepository.queryArrecadacaoPorTributo(filtro);
        log.debug("Consultando resumo arrecada\u00e7\u00e3o por tributo levou {}", (Object)stopwatch.stop());
        ArrecadacaoPorTributoValoresDTO valoresAcumulados = this.reduceValorArrecadacao(Optional.empty(), listTributoValores);
        resumo.setTotalPrincipal(valoresAcumulados.getValorPrincipal());
        resumo.setTotalJuros(valoresAcumulados.getValorJuros());
        resumo.setTotalMulta(valoresAcumulados.getValorMulta());
        resumo.setTotalCorrecao(valoresAcumulados.getValorCorrecao());
        resumo.setTotalDesconto(valoresAcumulados.getValorDesconto());
        resumo.setTotalLiquido(valoresAcumulados.getValorLiquido());
        resumo.setValoresPaginados(this.getValoresArrecadacaoPorTributo(listTributoValores, pageable, false));
        return resumo;
    }

    public Map<String, String> getAllTiposReceita(String search) {
        return this.arrecadacaoPorTributoRepository.getAllTiposReceita(search);
    }

    private Page<ArrecadacaoPorTributoValoresDTO> getValoresArrecadacaoPorTributo(List<ArrecadacaoPorTributoValoresDTO> list, Pageable pageable, boolean isPrint) {
        ArrayList valoresAgrupados = new ArrayList();
        list.stream().collect(Collectors.groupingBy(ArrecadacaoPorTributoValoresDTO::getTributo)).forEach((tributo, valores) -> valoresAgrupados.add(this.reduceValorArrecadacao(Optional.of(tributo), valores)));
        String pageableSort = pageable.getSort().toString().replace(":", "").replaceAll("(?i)unsorted", "");
        this.sortGroupedValues(valoresAgrupados, pageableSort);
        if (isPrint) {
            return new PageImpl(valoresAgrupados, pageable, (long)valoresAgrupados.size());
        }
        List valores2 = valoresAgrupados.stream().skip(pageable.getOffset()).limit(pageable.getPageSize()).collect(Collectors.toList());
        return new PageImpl(valores2, pageable, (long)valoresAgrupados.size());
    }

    private void sortGroupedValues(List<ArrecadacaoPorTributoValoresDTO> valoresAgrupados, String pageableSort) {
        HashMap<String, Comparator<ArrecadacaoPorTributoValoresDTO>> comparatorMap = new HashMap<String, Comparator<ArrecadacaoPorTributoValoresDTO>>();
        comparatorMap.put("tributo", Comparator.comparing(ArrecadacaoPorTributoValoresDTO::getTributo));
        comparatorMap.put("valorprincipal", Comparator.comparing(ArrecadacaoPorTributoValoresDTO::getValorPrincipal));
        comparatorMap.put("valorjuros", Comparator.comparing(ArrecadacaoPorTributoValoresDTO::getValorJuros));
        comparatorMap.put("valormulta", Comparator.comparing(ArrecadacaoPorTributoValoresDTO::getValorMulta));
        comparatorMap.put("valorcorrecao", Comparator.comparing(ArrecadacaoPorTributoValoresDTO::getValorCorrecao));
        comparatorMap.put("valordesconto", Comparator.comparing(ArrecadacaoPorTributoValoresDTO::getValorDesconto));
        comparatorMap.put("valorliquido", Comparator.comparing(ArrecadacaoPorTributoValoresDTO::getValorLiquido));
        if (!pageableSort.isEmpty()) {
            String[] split = pageableSort.split(" ");
            String field = split[0];
            String direction = split[1];
            Comparator comparator = (Comparator)comparatorMap.get(field);
            Stopwatch stopwatch = Stopwatch.createStarted();
            log.debug("Ordenando resumo arrecada\u00e7\u00e3o por tributo...");
            if (comparator != null) {
                if ("DESC".equals(direction)) {
                    comparator = comparator.reversed();
                }
                valoresAgrupados.sort(comparator);
            }
            log.debug("Ordenando resumo arrecada\u00e7\u00e3o por tributo levou {}", (Object)stopwatch.stop());
        }
    }

    private ArrecadacaoPorTributoValoresDTO reduceValorArrecadacao(Optional<String> tributo, List<ArrecadacaoPorTributoValoresDTO> valores) {
        return valores.stream().reduce(new ArrecadacaoPorTributoValoresDTO(), (acc, item) -> {
            tributo.ifPresent(arg_0 -> ((ArrecadacaoPorTributoValoresDTO)acc).setTributo(arg_0));
            acc.setValorPrincipal(acc.getValorPrincipal().add(item.getValorPrincipal()));
            acc.setValorJuros(acc.getValorJuros().add(item.getValorJuros()));
            acc.setValorMulta(acc.getValorMulta().add(item.getValorMulta()));
            acc.setValorCorrecao(acc.getValorCorrecao().add(item.getValorCorrecao()));
            acc.setValorDesconto(acc.getValorDesconto().add(item.getValorDesconto()));
            acc.setValorLiquido(acc.getValorPrincipal().add(acc.getValorJuros()).add(acc.getValorMulta()).add(acc.getValorCorrecao()).subtract(acc.getValorDesconto()));
            return acc;
        });
    }
}

