/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.comunicado;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.ParametroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.dto.BooleanSimNao;
import br.com.elotech.tributos.dto.ComunicadoServiceDTO;
import br.com.elotech.tributos.repository.ValidacaoComunicadoRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.comunicado.ValidacaoComunicadoService;
import java.util.Objects;
import lombok.Generated;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class ValidacaoComunicadoService {
    private final ParametroGeralService parametroGeralService;
    private final ValidacaoComunicadoRepository validacaoComunicadoRepository;

    public void validaParametroComunicadoDuplicado(JobParametersBuilder jobParametersBuilder, ComunicadoServiceDTO comunicadoServiceDTO) {
        if (Objects.isNull(this.getParametroValidaComunicadoValidade())) {
            return;
        }
        if (Boolean.FALSE.equals(this.existsComDataValidadeVencida(comunicadoServiceDTO))) {
            throw new RestException(HttpStatus.PRECONDITION_FAILED, "Para o filtro informado n\u00e3o foram encontrados comunicados a serem gerados.");
        }
        jobParametersBuilder.addString("VALIDACOMUNICADODUPLICADO", "S");
    }

    public void validaParametroComunicadoManualDuplicado(String filters) {
        if (Objects.isNull(this.getParametroValidaComunicadoValidade())) {
            return;
        }
        if (Boolean.FALSE.equals(this.validacaoComunicadoRepository.existsComDataValidadeVencidasPorCadastro(filters))) {
            throw new RestException(HttpStatus.PRECONDITION_FAILED, "Para o filtro informado n\u00e3o foram encontrados comunicados a serem gerados.");
        }
    }

    public void addJobParameterValidaComunicadoManualDuplicado(JobParametersBuilder jobParametersBuilder) {
        if (Objects.isNull(this.getParametroValidaComunicadoValidade())) {
            return;
        }
        jobParametersBuilder.addString("VALIDACOMUNICADODUPLICADO", "S");
    }

    private ParametroGeral getParametroValidaComunicadoValidade() {
        ParametroGeral parametro = this.parametroGeralService.findByParametroAndModulo(ParametroGeralEnum.VALIDACOMUNICADOVALIDADE, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (Objects.isNull(parametro) || Objects.isNull(parametro.getValor()) || BooleanSimNao.NAO.getValue().equals(parametro.getValor())) {
            return null;
        }
        return parametro;
    }

    private Boolean existsComDataValidadeVencida(ComunicadoServiceDTO comunicadoServiceDTO) {
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$JobType[comunicadoServiceDTO.getJobType().ordinal()]) {
            case 1: {
                return this.validacaoComunicadoRepository.existsComDataValidadeVencidaDebito(Long.valueOf(Long.parseLong((String)comunicadoServiceDTO.getIdentificador().get("id"))));
            }
            case 2: {
                return this.validacaoComunicadoRepository.existsComDataValidadeVencidaLivroDA(Long.valueOf(Long.parseLong((String)comunicadoServiceDTO.getIdentificador().get("entidade"))), Long.valueOf(Long.parseLong((String)comunicadoServiceDTO.getIdentificador().get("exercicio"))), Long.valueOf(Long.parseLong((String)comunicadoServiceDTO.getIdentificador().get("livro"))));
            }
            case 3: {
                return this.validacaoComunicadoRepository.existsComDataValidadeVencidaGeracaoCda(Long.valueOf(Long.parseLong((String)comunicadoServiceDTO.getIdentificador().get("idLoteSimulacao"))));
            }
            case 4: {
                return this.validacaoComunicadoRepository.existsComDataValidadeVencidaSimulacaoCalculo(Long.valueOf(Long.parseLong((String)comunicadoServiceDTO.getIdentificador().get("idCalculo"))));
            }
        }
        return Boolean.FALSE;
    }

    @Generated
    public ValidacaoComunicadoService(ParametroGeralService parametroGeralService, ValidacaoComunicadoRepository validacaoComunicadoRepository) {
        this.parametroGeralService = parametroGeralService;
        this.validacaoComunicadoRepository = validacaoComunicadoRepository;
    }
}

