/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.atualizacaomonetariaparcelamento;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.parcelamento.AtualizacaoMonetaria;
import br.com.elotech.tributos.domain.parcelamento.EstornoAtualizacaoMonetaria;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.EstornoAtualizacaoMonetariaParcelamentoParams;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.AtualizacaoMonetariaService;
import br.com.elotech.tributos.service.EstornoAtualizacaoMonetariaService;
import java.io.Serializable;
import java.time.LocalDate;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class EstornoAtualizacaoMonetariaParcelamentoJobStarter {
    private final JobLauncher jobLauncher;
    private final Job job;
    private final JobExplorer jobExplorer;
    private final AtualizacaoMonetariaService atualizacaoMonetariaService;
    private final EstornoAtualizacaoMonetariaService estornoAtualizacaoMonetariaService;

    public EstornoAtualizacaoMonetariaParcelamentoJobStarter(JobLauncher jobLauncher, @Qualifier(value="EstornoAtualizacaoMonetariaParcelamentoBatchJob") Job job, JobExplorer jobExplorer, AtualizacaoMonetariaService atualizacaoMonetariaService, EstornoAtualizacaoMonetariaService estornoAtualizacaoMonetariaService) {
        this.jobLauncher = jobLauncher;
        this.job = job;
        this.jobExplorer = jobExplorer;
        this.atualizacaoMonetariaService = atualizacaoMonetariaService;
        this.estornoAtualizacaoMonetariaService = estornoAtualizacaoMonetariaService;
    }

    public JobExecution startJob(EstornoAtualizacaoMonetariaParcelamentoParams params) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        if (this.isJobRunning(params.getIdAtualizacao())) {
            throw new EloValidationException(String.format("Um job de estorno atualiza\u00e7\u00e3o monet\u00e1ria j\u00e1 est\u00e1 em execu\u00e7\u00e3o para a atualiza\u00e7\u00e3o %s", params.getIdAtualizacao()));
        }
        AtualizacaoMonetaria atualizacaoMonetaria = (AtualizacaoMonetaria)this.atualizacaoMonetariaService.findById((Serializable)params.getIdAtualizacao()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar atualiza\u00e7\u00e3o com o id %d", params.getIdAtualizacao())));
        if (atualizacaoMonetaria.getEstornado().booleanValue() || this.atualizacaoMonetariaService.possuiItensEstornados(atualizacaoMonetaria.getId())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 possivel estornar a atualiza\u00e7\u00e3o %d pois ela j\u00e1 possui registros estornados.", atualizacaoMonetaria.getId()));
        }
        EstornoAtualizacaoMonetaria estorno = new EstornoAtualizacaoMonetaria();
        estorno.setAtualizacaoMonetaria(atualizacaoMonetaria);
        estorno.setEntidade(atualizacaoMonetaria.getEntidade());
        estorno.setAno(Long.valueOf(atualizacaoMonetaria.getAno().longValue()));
        estorno.setMes(Long.valueOf(atualizacaoMonetaria.getMes().longValue()));
        estorno.setData(LocalDate.now());
        estorno.setObservacao(params.getMotivo());
        estorno.setUsuario(SecurityUtils.getUserAise());
        this.estornoAtualizacaoMonetariaService.save((EloEntity)estorno, null);
        JobParameters jobParameters = this.createJobParameters(estorno);
        return this.jobLauncher.run(this.job, jobParameters);
    }

    private JobParameters createJobParameters(EstornoAtualizacaoMonetaria estorno) {
        return new JobParametersBuilder().addLong("timestamp", Long.valueOf(System.currentTimeMillis())).addLong("idEstornoAtualizacaoMonetaria", estorno.getId()).addLong("idAtualizacaoMonetaria", estorno.getAtualizacaoMonetaria().getId()).toJobParameters();
    }

    private boolean isJobRunning(Long idAtualizacao) {
        return this.jobExplorer.findRunningJobExecutions(JobType.ESTORNO_ATUALIZACAO_MONETARIA_PARCELAMENTO.getTipo()).stream().anyMatch(execution -> idAtualizacao.equals(execution.getJobParameters().getLong("idEstornoAtualizacaoMonetaria")));
    }
}

