/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.autoinfracao;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.autoinfracao.Penalidade;
import br.com.elotech.tributos.domain.autoinfracao.PenalidadeId;
import br.com.elotech.tributos.repository.autoinfracao.PenalidadeRepository;
import br.com.elotech.tributos.service.ContextService;
import java.util.Objects;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class PenalidadeService
extends CrudService<Penalidade, PenalidadeId> {
    private final ContextService contextService;
    private final PenalidadeRepository penalidadeRepository;

    protected void beforeInsert(Penalidade entity) {
        super.beforeInsert((EloEntity)entity);
        if (Objects.isNull(entity.getId())) {
            PenalidadeId id = new PenalidadeId();
            id.setEntidade(this.contextService.getEntidadePrincipal());
            id.setExercicio(this.contextService.getExercicioAtual());
            entity.setId(id);
        }
    }

    protected void beforeSave(Penalidade entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        if (this.penalidadeRepository.existsComConflito(entity.getId().getPenalidade(), entity.getDivida(), entity.getTributo())) {
            throw new EloValidationException(String.format("J\u00e1 existe uma penalidade para a d\u00edvida %d - %s e o tributo %s - %s.", entity.getDivida().getDivida(), entity.getDivida().getDescricao(), entity.getTributo().getTributo(), entity.getTributo().getDescricao()));
        }
    }

    @Generated
    public PenalidadeService(ContextService contextService, PenalidadeRepository penalidadeRepository) {
        this.contextService = contextService;
        this.penalidadeRepository = penalidadeRepository;
    }
}

