/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.autoinfracao;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.autoinfracao.Fiscal;
import br.com.elotech.tributos.repository.autoinfracao.FiscalRepository;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class FiscalService
extends CrudService<Fiscal, Long> {
    private final FiscalRepository fiscalRepository;

    public Long getNextCodigoFiscal(Long idTipoFiscal) {
        return this.fiscalRepository.getNextCodigoFiscal(idTipoFiscal);
    }

    protected void beforeSave(Fiscal entity, Authentication authentication) {
        if (this.fiscalRepository.existsComConflito(entity.getId(), entity.getFiscal(), entity.getTipoFiscal())) {
            throw new EloValidationException(String.format("J\u00e1 existe um fiscal com o c\u00f3digo %d e o tipo %d - %s", entity.getFiscal(), entity.getTipoFiscal().getId(), entity.getTipoFiscal().getDescricao()));
        }
        if (this.fiscalRepository.existsComConflitoPessoa(entity.getId(), entity.getTipoFiscal(), entity.getPessoa())) {
            throw new EloValidationException(String.format("J\u00e1 existe um fiscal com tipo %d - %s e pessoa %d - %s", entity.getTipoFiscal().getId(), entity.getTipoFiscal().getDescricao(), entity.getPessoa().getId(), entity.getPessoa().getNome()));
        }
    }

    @Generated
    public FiscalService(FiscalRepository fiscalRepository) {
        this.fiscalRepository = fiscalRepository;
    }
}

