/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ParametroPixService
extends CrudService<ParametroPix, Long> {
    private final ParametroPixRepository parametroPixRepository;

    @Transactional
    public ParametroPix save(ParametroPix parametroPix) {
        if (Objects.isNull(parametroPix.getEntidade())) {
            throw new EloValidationException("A entidade \u00e9 obrigat\u00f3ria.");
        }
        if (Objects.nonNull(parametroPix.getCertificadoItau()) && StringUtils.isEmpty((String)parametroPix.getSenhaCertificadoItau())) {
            throw new EloValidationException("A senha do certificado do Ita\u00fa \u00e9 obrigat\u00f3ria.");
        }
        if (Objects.nonNull(parametroPix.getCertificadoBradesco()) && StringUtils.isEmpty((String)parametroPix.getSenhaCertificadoBradesco())) {
            throw new EloValidationException("A senha do certificado do Bradesco \u00e9 obrigat\u00f3ria.");
        }
        if (Objects.nonNull(parametroPix.getCertificadoBancoBrasil()) && StringUtils.isEmpty((String)parametroPix.getSenhaCertificadoBancoBrasil())) {
            throw new EloValidationException("A senha do certificado do Banco do Brasil \u00e9 obrigat\u00f3ria.");
        }
        if (Objects.nonNull(parametroPix.getCertificadoDelBank()) && StringUtils.isEmpty((String)parametroPix.getSenhaCertificadoDelBank())) {
            throw new EloValidationException("A senha do certificado Del Bank \u00e9 obrigat\u00f3ria.");
        }
        return (ParametroPix)this.parametroPixRepository.save((Object)parametroPix);
    }

    public String sanitizeString(String valor) {
        if (Objects.isNull(valor)) {
            return null;
        }
        return valor.equals("undefined") ? null : valor;
    }

    public byte[] getSavedSantanderCertificado(ParametroPix parametro) {
        return Objects.nonNull(parametro.getCertificadoSantander()) ? parametro.getCertificadoSantander().getCertificado() : null;
    }

    @Generated
    public ParametroPixService(ParametroPixRepository parametroPixRepository) {
        this.parametroPixRepository = parametroPixRepository;
    }
}

