/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.parcelamento.LoteParcelamentoReajuste;
import br.com.elotech.tributos.domain.parcelamento.LoteParcelamentoReajusteItem;
import br.com.elotech.tributos.domain.parcelamento.SituacaoParcelamentoEnum;
import br.com.elotech.tributos.dto.LoteParcelamentoReajusteListItem;
import br.com.elotech.tributos.dto.parcelamento.AtualizacaoMonetariaDTO;
import br.com.elotech.tributos.dto.parcelamento.SituacaoReajusteParcelamentoLoteItem;
import br.com.elotech.tributos.repository.parcelamento.LoteParcelamentoReajusteItemRepository;
import br.com.elotech.tributos.repository.parcelamento.LoteParcelamentoReajusteRepository;
import br.com.elotech.tributos.service.ParcelamentoService;
import br.com.elotech.tributos.util.RsqlOperatorUtils;
import br.com.elotech.tributos.util.paginatedquery.PaginatedQuery;
import br.com.elotech.tributos.util.paginatedquery.PaginatedQueryResultMapper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.Query;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LoteParcelamentoReajusteService
extends CrudService<LoteParcelamentoReajuste, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoteParcelamentoReajusteService.class);
    private LoteParcelamentoReajusteRepository loteParcelamentoReajusteRepository;
    private LoteParcelamentoReajusteItemRepository loteParcelamentoReajusteItemRepository;
    private ParcelamentoService parcelamentoService;

    @Transactional
    public LoteParcelamentoReajuste createLoteParcelamentoReajuste(AtualizacaoMonetariaDTO atualizacaoMonetariaDTO, String usuario) {
        LoteParcelamentoReajuste lote = this.createPersistentLote(atualizacaoMonetariaDTO.getObservacao(), usuario);
        atualizacaoMonetariaDTO.setLote(lote);
        this.createItensForLote(atualizacaoMonetariaDTO);
        return lote;
    }

    private LoteParcelamentoReajuste createPersistentLote(String observacao, String usuario) {
        LoteParcelamentoReajuste lote = LoteParcelamentoReajuste.novoLote();
        lote.setObservacao(observacao);
        lote.setUsuario(usuario);
        return (LoteParcelamentoReajuste)this.loteParcelamentoReajusteRepository.save((Object)lote);
    }

    private void createItensForLote(AtualizacaoMonetariaDTO dto) {
        Query query = this.getCreateItensQuery(dto.getSituacaoParcelamento(), dto.buildFiltrosForNativeSQL());
        query = this.setCreateItensQueryParams(query, dto);
        StopWatch stopWatch = StopWatch.createStarted();
        int rowsAffected = query.executeUpdate();
        stopWatch.stop();
        log.info("Tempo gasto na gera\u00e7\u00e3o dos itens do lote[{}]: itens: [{}] Tempo de execu\u00e7\u00e3o [{}]", new Object[]{dto.getLote().getId(), rowsAffected, stopWatch});
    }

    public Page<LoteParcelamentoReajusteListItem> searchItens(Long idLote, String search, Pageable pageable) {
        String rsqlToSql = RsqlOperatorUtils.replaceOperatorsRsqlToSql((String)search);
        Object filter = StringUtils.isNotEmpty((CharSequence)rsqlToSql) ? " AND " + rsqlToSql : "";
        return new PaginatedQuery(this.getEm()).retrieveColumns(List.of("item.idloteparcreajusteitem", "item.idloteparcreajuste", "item.idparcelamento", "item.situacao", "item.valorpercentaplicado", "item.ano", "item.mes", "item.mensagem", "parcelamento.numerocontrato", "parcelamento.anocontrato", "pessoa.nome")).fromMainQuery(" from tribloteparcreajusteitem item  join tribloteparcreajuste lote on lote.idloteparcreajuste = item.idloteparcreajuste join tribparcelamento parcelamento on parcelamento.idparcelamento = item.idparcelamento join pessoa pessoa on pessoa.pessoa = parcelamento.requerente where lote.idloteparcreajuste = :idLote " + (String)filter).withParams(Map.of("idLote", idLote)).paginated(pageable).retrieveSample((PaginatedQueryResultMapper)new LoteParcelamentoReajusteListItem()).getResult();
    }

    public Query getCreateItensQuery(SituacaoParcelamentoEnum situacao, String filtros) {
        List tipoSituacaoParcela = this.parcelamentoService.getTipoSituacaoParcelaBySituacaoParcelamentoParaSQL(situacao);
        String sql = " with parcelamentos as (   select tribparcelamento.idparcelamento  from tribdebitoparcela tdp    join tribsituacaoparcela tsp on tsp.situacaoparcela = tdp.situacaodebito    join tribtiposituacaoparcela ttsp on ttsp.tiposituacaoparcela  = tsp.tiposituacaoparcela    join tribdebito td on td.entidade = tdp.entidade and td.exercicio  = tdp.exercicio                      and td.tipocadastro  = tdp.tipocadastro and td.cadastrogeral  = tdp.cadastrogeral                      and td.guiarecolhimento  = tdp.guiarecolhimento and td.subdivida  = tdp.subdivida    join tribparcelamentodebitoorigem tpdo on tpdo.iddebitonovo = td.iddebito    join tribparcelamento tribparcelamento on tribparcelamento.idparcelamento  = tpdo.idparcelamento    join pessoa pessoa on pessoa.pessoa = tribparcelamento.requerente  where ttsp.tipo in " + String.format("(%s)", String.join((CharSequence)", ", tipoSituacaoParcela)) + (String)(StringUtils.isNotEmpty((CharSequence)filtros) ? " AND " + filtros : "") + " group by tribparcelamento.idparcelamento)  INSERT INTO tribloteparcreajusteitem  (idloteparcreajusteitem, idloteparcreajuste, ano, mes, idparcelamento, situacao, valorpercentaplicado)  SELECT NEXTVAL(:sequenceName),         :idloteparcreajuste,         :ano,         :mes,         idparcelamento,         :situacao,         :valorpercentaplicado  FROM parcelamentos";
        return this.getEm().createNativeQuery(sql);
    }

    public Query setCreateItensQueryParams(Query query, AtualizacaoMonetariaDTO dto) {
        String sequenceName = Arrays.stream(LoteParcelamentoReajusteItem.class.getDeclaredFields()).filter(a -> a.isAnnotationPresent(EloSequence.class)).findFirst().map(f -> f.getDeclaredAnnotation(EloSequence.class).sequenceName()).get();
        return query.setParameter("sequenceName", (Object)sequenceName.toLowerCase()).setParameter("idloteparcreajuste", (Object)dto.getLote().getId()).setParameter("ano", (Object)dto.getAno()).setParameter("mes", (Object)(Objects.nonNull(dto.getMes()) ? dto.getMes() : 12L)).setParameter("situacao", (Object)SituacaoReajusteParcelamentoLoteItem.CREATED.name()).setParameter("valorpercentaplicado", (Object)BigDecimal.ZERO);
    }

    @Generated
    public LoteParcelamentoReajusteService(LoteParcelamentoReajusteRepository loteParcelamentoReajusteRepository, LoteParcelamentoReajusteItemRepository loteParcelamentoReajusteItemRepository, ParcelamentoService parcelamentoService) {
        this.loteParcelamentoReajusteRepository = loteParcelamentoReajusteRepository;
        this.loteParcelamentoReajusteItemRepository = loteParcelamentoReajusteItemRepository;
        this.parcelamentoService = parcelamentoService;
    }
}

