/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.service.VinculoCadastroFormaPagamentoService;
import br.com.elotech.tributos.domain.BoletoException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Carne;
import br.com.elotech.tributos.domain.CarneId;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaFormaPagamento;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.ParcelamentoCarne;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoFormaPagamento;
import br.com.elotech.tributos.dto.AtualizaSituacaoCarneDTO;
import br.com.elotech.tributos.dto.CarneDTO;
import br.com.elotech.tributos.dto.CarneResumoDTO;
import br.com.elotech.tributos.dto.CarneRowDTO;
import br.com.elotech.tributos.dto.DadosCriaBoletoAgrupadoDTO;
import br.com.elotech.tributos.dto.DebitoAgrupadoPorFormaPagamentoDTO;
import br.com.elotech.tributos.dto.DebitoCarneDTO;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.FiltroConsultaCarneDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.dto.parcelamento.ImpressaoBoletoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoParcelasDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoPassivelQuitacaoDTO;
import br.com.elotech.tributos.enums.SituacaoGeracaoCarne;
import br.com.elotech.tributos.repository.CarneRepository;
import br.com.elotech.tributos.repository.ConsultaCarneRepository;
import br.com.elotech.tributos.repository.DebitoParcelaRepository;
import br.com.elotech.tributos.repository.ParcelamentoCarneRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CarneService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoEmAbertoService;
import br.com.elotech.tributos.service.DividaFormaPagamentoService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.ModeloBoletoService;
import br.com.elotech.tributos.service.ProtestoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.carne.AlteraSituacaoCancelado;
import br.com.elotech.tributos.service.carne.AlteraSituacaoCarne;
import br.com.elotech.tributos.service.carne.AlteraSituacaoDevolvido;
import br.com.elotech.tributos.service.carne.AlteraSituacaoEntregue;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CarneService
extends ReadOnlyService<Carne, CarneId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CarneService.class);
    private final CarneRepository carneRepository;
    private final DebitoParcelaRepository debitoParcelaRepository;
    private final GeraBoletoService geraBoletoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final VinculoCadastroFormaPagamentoService vinculoCadastroFormaPagamentoService;
    private final FormaPagamentoService formaPagamentoService;
    private final ContextService contextService;
    private final ParcelamentoCarneRepository parcelamentoCarneRepository;
    private final DebitoEmAbertoService debitoEmAbertoService;
    private final CadastroGeralService cadastroGeralService;
    private final DividaFormaPagamentoService dividaFormaPagamentoService;
    private final ProtestoService protestoService;
    private final ConsultaCarneRepository consultaCarneRepository;
    private final ModeloBoletoService modeloBoletoService;

    @Transactional
    public ParcelamentoCarne gerarBoletoCarne(ImpressaoBoletoParcelamentoDTO request, List<ParcelamentoDebitoParcelasDTO> parcelas, String chave, Long parcelaInicial, Long parcelaFinal) {
        FormaPagamento formaPagamento = (FormaPagamento)this.formaPagamentoService.findById((Serializable)request.getFormaPagamento()).orElseThrow(() -> new EloValidationException(String.format("Forma de pagamento %d n\u00e3o encontrado", request.getFormaPagamento())));
        List parcelamentos = request.getParcelamentos().stream().map(ParcelamentoPassivelQuitacaoDTO::getIdParcelamento).collect(Collectors.toList());
        Carne carne = this.geraCarneAgrupado(parcelas, formaPagamento, request.getTipoCadastro(), request.getCadastroGeral(), request.getEntidade(), this.contextService.getExercicioAtual(), parcelamentos, request.getCodigoModeloBoletoSemRegistro(), request.getPorContribuinte(), request.getContribuinte());
        ParcelamentoCarne parcelamentoCarne = new ParcelamentoCarne(chave, carne, parcelaInicial, parcelaFinal, request.getContribuinte(), request.getVencimentoInicial(), request.getVencimentoFinal(), Boolean.valueOf(Boolean.TRUE.equals(request.getPorContribuinte())), request.getFormaPagamento());
        return (ParcelamentoCarne)this.parcelamentoCarneRepository.save((Object)parcelamentoCarne);
    }

    @Transactional
    public Carne geraCarneAgrupado(List<ParcelamentoDebitoParcelasDTO> parcelas, FormaPagamento formaPagamento, Long tipoCadastro, Long cadastroGeral, Long entidade, Long exercicio, List<Long> parcelamentos, Long codigoModeloBoletoSemRegistro, Boolean isPorContribuinte, Long contribuinte) {
        Preconditions.checkArgument((!parcelas.isEmpty() ? 1 : 0) != 0, (Object)"N\u00e3o foram encontrados os d\u00e9bitos para a gera\u00e7\u00e3o do carn\u00ea");
        CarneId id = new CarneId();
        id.setEntidade(entidade);
        id.setExercicio(exercicio);
        Carne carneSavedSemNumero = new Carne();
        carneSavedSemNumero.setId(id);
        carneSavedSemNumero.setTipoCadastro(tipoCadastro);
        carneSavedSemNumero.setCadastroGeral(cadastroGeral);
        carneSavedSemNumero = this.save(carneSavedSemNumero);
        TipoFormaPagamento tipoFormaPagamento = formaPagamento.getTipoFormaPagamento();
        if (!TipoFormaPagamento.PARCELADO.equals((Object)tipoFormaPagamento)) {
            throw new EloValidationException("O tipo da forma de pagamento deve ser PARCELADO");
        }
        ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
        List numerosParcelas = parcelas.stream().map(ParcelamentoDebitoParcelasDTO::getParcela).collect(Collectors.toList());
        List debitoparcelas = this.debitoParcelaRepository.findByParcelamentoParcelaAndAberto(entidade, numerosParcelas, parcelamentos);
        List debitoParcelasDto = debitoparcelas.stream().filter(dp -> this.isFormaPagamentoParceladoAndNaoVencido(tipoFormaPagamento.getValue(), dp)).map(dp -> DebitoParcelaDTO.convertBoleto((DebitoParcela)dp, (Long)dp.getDebito().getId())).collect(Collectors.toList());
        Map<Long, List<DebitoParcelaDTO>> parcelasDTO = debitoParcelasDto.stream().collect(Collectors.groupingBy(DebitoParcelaDTO::getParcela));
        Stopwatch watch = Stopwatch.createStarted();
        log.debug("geraCarneAgrupado() - Carregando debitos em aberto.");
        List listDebitoEmAberto = this.debitoEmAbertoService.loadDebitoEmAberto(this.geraBoletoService.mountFiltro(debitoParcelasDto), Boolean.TRUE);
        log.debug("geraCarneAgrupado() - Carregar debitos em aberto levou {}.", (Object)watch);
        this.geraBoletoService.validaEmissaoBoleto(exercicio, formaPagamento.getId(), listDebitoEmAberto);
        watch.reset().start();
        CadastroGeral cadastroGeralEntity = null;
        if (Boolean.FALSE.equals(isPorContribuinte)) {
            log.debug("geraCarneAgrupado() - Carregando cadastro geral.");
            cadastroGeralEntity = this.getCadastroGeral(tipoCadastro, cadastroGeral);
            log.debug("geraCarneAgrupado() - Carregando cadastro geral levou {}.", (Object)watch);
        }
        DebitoEmAbertoDTO debitoEmAbertoDTO = (DebitoEmAbertoDTO)listDebitoEmAberto.stream().findFirst().orElseThrow(BoletoException::debitoBoletoNotFound);
        watch.reset().start();
        log.debug("geraCarneAgrupado() - Carregando DividaFormaPagamento.");
        DividaFormaPagamento dividaFormaPagamento = this.dividaFormaPagamentoService.findByEntidadeAndExercicioAndDividaAndFormaPagamentoId(debitoEmAbertoDTO.getEntidade(), exercicio, debitoEmAbertoDTO.getDivida(), formaPagamento.getId());
        log.debug("geraCarneAgrupado() - Carregando DividaFormaPagamento {} levou {}.", (Object)dividaFormaPagamento, (Object)watch);
        DadosCriaBoletoAgrupadoDTO dadosCriaBoletoAgrupadoDTO = new DadosCriaBoletoAgrupadoDTO(cadastroGeralEntity, dividaFormaPagamento, debitoEmAbertoDTO);
        List idDebitoParcelaReceitaList = listDebitoEmAberto.stream().map(DebitoEmAbertoDTO::getIdDebitoParcelaReceita).collect(Collectors.toList());
        watch.reset().start();
        log.debug("geraCarneAgrupado() - carregando debito parcelas tributo.");
        Map debitoParcelasTributos = this.geraBoletoService.loadDebitoParcelasTributos(idDebitoParcelaReceitaList);
        log.debug("geraCarneAgrupado() - carregando debito parcelas tributo levou {}.", (Object)watch);
        List allDebitoParcelaReceitaList = debitoParcelasTributos.values().stream().flatMap(Collection::stream).map(DebitoParcelaTributo::getDebitoParcela).collect(Collectors.toList());
        watch.reset().start();
        log.debug("geraCarneAgrupado() - validando se debitos foram protestados.");
        this.protestoService.validaDebitoProtestadoList(allDebitoParcelaReceitaList);
        log.debug("geraCarneAgrupado() - validando se debitos foram protestados levou {}.", (Object)watch.stop());
        Map<Long, List<DebitoEmAbertoDTO>> debitosAbertosPorParcela = listDebitoEmAberto.stream().collect(Collectors.groupingBy(CalculaAcrescimoBaseDTO::getParcela));
        Map<Long, List<DebitoParcelaTributo>> debitoParcelasTributosPorParcela = debitoParcelasTributos.values().stream().flatMap(Collection::stream).collect(Collectors.groupingBy(DebitoParcelaTributo::getParcela));
        log.debug("geraCarneAgrupado() - esta recuperando o modelo de boleto para o carn\u00ea agrupado.");
        ModeloBoleto modeloBoleto = this.modeloBoletoService.retornarConfiguracaoModeloBoletoSequencia();
        if (codigoModeloBoletoSemRegistro != null && codigoModeloBoletoSemRegistro > 0L) {
            modeloBoleto = (ModeloBoleto)this.modeloBoletoService.findOne((Serializable)codigoModeloBoletoSemRegistro);
        }
        log.debug("geraCarneAgrupado() - recuperou o modelo de boleto para o carn\u00ea agrupado {}.", (Object)(modeloBoleto != null ? modeloBoleto.getDescricao() : "Modelo de boleto nulo"));
        for (Long numeroParcela : parcelasDTO.keySet()) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            List<DebitoParcelaDTO> debitoParcelasDTO = parcelasDTO.get(numeroParcela);
            GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
            geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
            geraBoletoDTO.setTipoBoleto(TipoBloqueto.AGRUPADO);
            geraBoletoDTO.setDebitos(debitoParcelasDTO);
            geraBoletoDTO.setExercicio(exercicio);
            geraBoletoDTO.setPorContribuinte(isPorContribuinte);
            geraBoletoDTO.setImpressaoCarne(Boolean.TRUE);
            geraBoletoDTO.setDataReferencia(LocalDate.now());
            geraBoletoDTO.setModeloBoleto(modeloBoleto);
            geraBoletoDTO.setCodigoModeloBloquetoSemRegistro(codigoModeloBoletoSemRegistro);
            if (Boolean.TRUE.equals(isPorContribuinte)) {
                geraBoletoDTO.setPessoa(contribuinte);
            }
            List<DebitoEmAbertoDTO> debitosAbertosDaParcela = debitosAbertosPorParcela.get(numeroParcela);
            List<DebitoParcelaTributo> debitoParcelaTributosList = debitoParcelasTributosPorParcela.get(numeroParcela);
            List geracaoBoleto = this.geraBoletoService.agregaDebitoPorTipoBoleto(geraBoletoDTO.getTipoBoleto(), debitosAbertosDaParcela);
            dadosCriaBoletoAgrupadoDTO.setDebitoParcelaTributoList(debitoParcelaTributosList);
            String elapsedTimeCarregarParcelas = stopwatch.toString();
            this.geraBoletoEAdicionaNoCarneAgrupado(geraBoletoDTO, carneSavedSemNumero, formaPagamento.getId(), parametrosAcrescimos, geracaoBoleto, dadosCriaBoletoAgrupadoDTO, (arg_0, arg_1, arg_2, arg_3, arg_4) -> ((GeraBoletoService)this.geraBoletoService).geraBoletoAgrupado(arg_0, arg_1, arg_2, arg_3, arg_4));
            stopwatch.stop();
            log.debug(String.format("Tempo gasto para gerar boletos do carne %d/%d:\ncarregarParcelas: %s\ngerarBoletoEAdicionarNoCarne: %s", carneSavedSemNumero.getId().getCarne(), numeroParcela, elapsedTimeCarregarParcelas, stopwatch));
        }
        return carneSavedSemNumero;
    }

    @Transactional
    public CarneDTO geraCarne(DebitoCarneDTO debitoCarne) {
        List parcelas = this.debitoParcelaRepository.findByDebitoAndAberto(debitoCarne.getEntidade(), debitoCarne.getExercicio(), debitoCarne.getTipoCadastro(), debitoCarne.getCadastroGeral(), debitoCarne.getDivida(), debitoCarne.getSubDivida());
        ModeloBoleto modeloBoleto = debitoCarne.getCodigoModeloBloquetoSemRegistro() != null && debitoCarne.getCodigoModeloBloquetoSemRegistro() > 0L ? (ModeloBoleto)this.modeloBoletoService.findOne((Serializable)debitoCarne.getCodigoModeloBloquetoSemRegistro()) : this.modeloBoletoService.retornarConfiguracaoModeloBoletoSequencia();
        Preconditions.checkArgument((!parcelas.isEmpty() ? 1 : 0) != 0, (Object)"N\u00e3o foram encontrados os d\u00e9bitos para a gera\u00e7\u00e3o do carn\u00ea");
        Carne carneSavedSemNumero = this.save(debitoCarne.toEntity());
        ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
        debitoCarne.getFormasPagamento().forEach(formaPagamento -> {
            ArrayList<DebitoParcelaDTO> debitosBoletoFormaPagamento = new ArrayList<DebitoParcelaDTO>();
            for (DebitoParcela debitoParcela : parcelas) {
                if (formaPagamento.getTipoFormaPagamento().equals(TipoFormaPagamento.PARCELADO.getValue()) && !this.isFormaPagamentoParceladoAndNaoVencido(formaPagamento.getTipoFormaPagamento(), debitoParcela)) continue;
                DebitoParcelaDTO debitoParcelaDTO = DebitoParcelaDTO.convertBoleto((DebitoParcela)debitoParcela, (Long)debitoCarne.getIdDebito());
                debitosBoletoFormaPagamento.add(debitoParcelaDTO);
            }
            this.geraBoletoEAdicionaNoCarne(carneSavedSemNumero, debitosBoletoFormaPagamento, formaPagamento.getFormaPagamento(), formaPagamento.getTipoFormaPagamento(), Boolean.TRUE, parametrosAcrescimos, (arg_0, arg_1, arg_2, arg_3) -> ((GeraBoletoService)this.geraBoletoService).geraBoleto(arg_0, arg_1, arg_2, arg_3), modeloBoleto);
        });
        this.getEm().flush();
        return CarneDTO.fromWithBoletos((Carne)this.save(carneSavedSemNumero));
    }

    private boolean isFormaPagamentoParceladoAndNaoVencido(String tipoFormaPagamento, DebitoParcela debitoParcela) {
        return TipoFormaPagamento.PARCELADO.getValue().equals(tipoFormaPagamento) && LocalDate.now().compareTo(debitoParcela.getDataVencimento()) <= 0;
    }

    private void geraBoletoEAdicionaNoCarneAgrupado(GeraBoletoDTO geraBoletoDTO, Carne carne, Long formaPagamento, ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos, List<List<DebitoEmAbertoDTO>> geracaoBoleto, DadosCriaBoletoAgrupadoDTO dadosCriaBoletoAgrupadoDTO, GeraBoletoCarneAgrupadoFunction creator) {
        creator.apply(geraBoletoDTO, formaPagamento, parametrosAcrescimos, geracaoBoleto, dadosCriaBoletoAgrupadoDTO).forEach(arg_0 -> ((Carne)carne).addBoleto(arg_0));
    }

    private void geraBoletoEAdicionaNoCarne(Carne carne, List<DebitoParcelaDTO> debitosBoleto, Long formaPagamento, String tipoFormaPagamento, Boolean somenteDebitosConstituidos, ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos, GeraBoletoCarneFunction creator, ModeloBoleto modeloBoleto) {
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.fromValue((String)tipoFormaPagamento));
        geraBoletoDTO.setDebitos(debitosBoleto);
        geraBoletoDTO.setExercicio(carne.getId().getExercicio());
        geraBoletoDTO.setImpressaoCarne(Boolean.TRUE);
        geraBoletoDTO.setModeloBoleto(modeloBoleto);
        creator.apply(geraBoletoDTO, formaPagamento, somenteDebitosConstituidos, parametrosAcrescimos).forEach(arg_0 -> ((Carne)carne).addBoleto(arg_0));
    }

    public Carne save(Carne carne) {
        if (Objects.isNull(carne.getData())) {
            carne.setData(LocalDate.now());
        }
        if (Objects.isNull(carne.getUsuario())) {
            carne.setUsuario(SecurityUtils.getUserAise());
        }
        if (Objects.isNull(carne.getNumero()) && Objects.nonNull(carne.getId().getCarne())) {
            carne.setNumero(carne.getId().getCarne());
        }
        if (Objects.isNull(carne.getCodigoBarras()) && Objects.nonNull(carne.getId().getCarne())) {
            carne.setCodigoBarras(String.format("%02d%04d%08d", carne.getId().getEntidade(), carne.getId().getExercicio(), carne.getId().getCarne()));
        }
        return (Carne)this.carneRepository.save((Object)carne);
    }

    @Transactional
    public CarneDTO geraCarnePorFormaPagamento(DebitoAgrupadoPorFormaPagamentoDTO params) {
        DebitoCarneDTO debitoCarneDTO = new DebitoCarneDTO();
        debitoCarneDTO.setIdDebito(params.getIdDebito());
        debitoCarneDTO.setEntidade(params.getEntidade());
        debitoCarneDTO.setExercicio(params.getExercicio());
        debitoCarneDTO.setTipoCadastro(params.getTipoCadastro());
        debitoCarneDTO.setCadastroGeral(params.getCadastroGeral());
        debitoCarneDTO.setDivida(params.getDivida());
        debitoCarneDTO.setSubDivida(params.getSubDivida());
        debitoCarneDTO.setFormasPagamento(Collections.singletonList(params));
        return this.geraCarne(debitoCarneDTO);
    }

    @Transactional
    public CarneDTO geraCarneCalculo(CalculoCadastro calculoCadastro, Long calculoLoteImpressaoOrdem, ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos, Long codigoModeloBloquetoSemRegistro) {
        try {
            Debito debito = calculoCadastro.getDebito();
            Carne carneSavedSemNumero = this.save(this.createCarne(debito, calculoCadastro.getCalculo().getExercicio()));
            ModeloBoleto modeloBoleto = codigoModeloBloquetoSemRegistro != null && codigoModeloBloquetoSemRegistro > 0L ? (ModeloBoleto)this.modeloBoletoService.findOne((Serializable)codigoModeloBloquetoSemRegistro) : this.modeloBoletoService.retornarConfiguracaoModeloBoletoSequencia();
            calculoCadastro.getCalculo().getFormasPagamento().stream().filter(calculoFormasPagamento -> calculoFormasPagamento.getDividaFormaPagamento().getDivida().equals((Object)debito.getDivida())).sorted(Comparator.comparing(calculoFormasPagamento -> calculoFormasPagamento.getDividaFormaPagamento().getFormaPagamento().getOrdemEmissao(), Comparator.nullsLast(Comparator.naturalOrder()))).forEach(calculoFormaPagamento -> {
                FormaPagamento formaPagamento = calculoFormaPagamento.getDividaFormaPagamento().getFormaPagamento();
                ArrayList<DebitoParcelaDTO> debitosBoletoFormaPagamento = new ArrayList<DebitoParcelaDTO>();
                if (!this.formaDePagamentoPermitido(calculoCadastro.getCadastro(), calculoCadastro.getDivida(), formaPagamento)) {
                    return;
                }
                for (DebitoParcela debitoParcela : debito.getParcelas()) {
                    if (Boolean.FALSE.equals(debitoParcela.getSituacaoDebito().isAberto())) {
                        log.debug("Tentando gerar boleto para parcela n\u00e3o aberta. Parcela {}", (Object)debitoParcela.getId());
                        continue;
                    }
                    if (formaPagamento.getTipoFormaPagamento().equals((Object)TipoFormaPagamento.PARCELADO) && !this.validaFormaPagamentoAndParcela(formaPagamento, debitoParcela, calculoFormaPagamento.getQuantidadeParcelas())) continue;
                    DebitoParcelaDTO debitoParcelaDTO = DebitoParcelaDTO.convertBoleto((DebitoParcela)debitoParcela, (Long)debito.getId());
                    debitosBoletoFormaPagamento.add(debitoParcelaDTO);
                }
                if (!debitosBoletoFormaPagamento.isEmpty()) {
                    this.geraBoletoEAdicionaNoCarne(carneSavedSemNumero, debitosBoletoFormaPagamento, formaPagamento.getId(), formaPagamento.getTipoFormaPagamento().getValue(), Boolean.FALSE, parametrosAcrescimos, (arg_0, arg_1, arg_2, arg_3) -> ((GeraBoletoService)this.geraBoletoService).geraBoletoCarneCalculo(arg_0, arg_1, arg_2, arg_3), modeloBoleto);
                }
            });
            if (carneSavedSemNumero.getBoletos().isEmpty()) {
                throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel gerar o carn\u00ea do lote: %d, cadastro: %d - %d. Verifique a situa\u00e7\u00e3o das parcelas do d\u00e9bito e as formas de pagamento configuradas.", calculoLoteImpressaoOrdem, calculoCadastro.getCadastro().getTipoCadastro().getValue(), calculoCadastro.getCadastro().getCadastroGeral()));
            }
            CarneDTO dto = CarneDTO.from((Carne)this.save(carneSavedSemNumero));
            calculoCadastro.setSituacaoCarne(SituacaoGeracaoCarne.GERADO);
            calculoCadastro.setErroEmissaoBoleto(null);
            return dto;
        }
        catch (Exception ex) {
            calculoCadastro.setSituacaoCarne(SituacaoGeracaoCarne.ERRO);
            calculoCadastro.setErroEmissaoBoleto(ex.getMessage());
            log.error("Erro ao gerar o carn\u00ea: ", (Throwable)ex);
            return null;
        }
    }

    private boolean validaFormaPagamentoAndParcela(FormaPagamento formaPagamento, DebitoParcela debitoParcela, Long quantidadeParcelas) {
        log.debug("Validando parcela para emitir boleto. Parcela: {}, dataVencimento, {} formaPagamento: {}, quantidadeParcelas: {}", new Object[]{debitoParcela.getIdDebitoParcela(), debitoParcela.getDataVencimento(), formaPagamento.getId(), quantidadeParcelas});
        boolean formaPagamentoParcelada = TipoFormaPagamento.PARCELADO.equals((Object)formaPagamento.getTipoFormaPagamento());
        boolean parcelaNaoVencida = LocalDate.now().compareTo(debitoParcela.getDataVencimento()) <= 0;
        boolean parcelaMenorQueQuantidadeParcelas = Objects.isNull(quantidadeParcelas) || debitoParcela.getId().getParcela() <= quantidadeParcelas;
        log.debug("Resultado da valida\u00e7\u00e3o: Forma de Pagamento parcelada: {}, Parcela n\u00e3o vencida: {}, parcela Menor que a quantidade:{} ", new Object[]{formaPagamentoParcelada, parcelaNaoVencida, parcelaMenorQueQuantidadeParcelas});
        return formaPagamentoParcelada && parcelaNaoVencida && parcelaMenorQueQuantidadeParcelas;
    }

    private Carne createCarne(Debito debito, Long exercicioCarne) {
        CarneId id = new CarneId();
        id.setEntidade(debito.getEntidade());
        id.setExercicio(exercicioCarne);
        Carne carne = new Carne();
        carne.setId(id);
        carne.setTipoCadastro(debito.getTipoCadastro());
        carne.setCadastroGeral(debito.getCadastroGeralId());
        return carne;
    }

    public void deleteCarne(Long entidade, Long exercicio, Long numeroCarne) {
        CarneId carneId = new CarneId(entidade, exercicio, numeroCarne);
        Carne carne = (Carne)this.carneRepository.findById((Object)carneId).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o encontrado carne %d no exercicio %d para entidade %d.", numeroCarne, exercicio, entidade)));
        this.carneRepository.delete((Object)carne);
    }

    public Optional<CarneDTO> findByDebito(Long idDebito, Long formaPagamento) {
        return this.carneRepository.findByDebitoAndFormaPagamento(idDebito, formaPagamento).map(CarneDTO::from);
    }

    private boolean formaDePagamentoPermitido(CadastroGeral cadastroGeral, Divida divida, FormaPagamento formaPagamento) {
        if (divida.getVerificaFormaPagamentoDiferenciada().equals(Boolean.FALSE)) {
            return true;
        }
        return this.vinculoCadastroFormaPagamentoService.existeVinculoComCadastroGeral(cadastroGeral.getId(), divida, formaPagamento);
    }

    private CadastroGeral getCadastroGeral(Long tipoCadastro, Long cadastroGeral) {
        return (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)tipoCadastro), cadastroGeral).orElseThrow(() -> new CadastroNaoEncontradoException(TipoCadastro.fromValue((Long)tipoCadastro), cadastroGeral));
    }

    public Page<CarneRowDTO> consultaCarne(FiltroConsultaCarneDTO dto, Pageable pageable) {
        return this.consultaCarneRepository.consultaCarne(dto, pageable);
    }

    private Carne getCarne(CarneId carneId) {
        return (Carne)this.carneRepository.findById((Object)carneId).orElseThrow(() -> new EloValidationException("Carn\u00ea n\u00e3o encontrado."));
    }

    public CarneResumoDTO getResumoCarne(CarneId carneId) {
        return CarneResumoDTO.from((Carne)this.getCarne(carneId));
    }

    @Transactional
    public void atualizaSituacaoCarne(AtualizaSituacaoCarneDTO dto) {
        this.carneRepository.save((Object)this.alteraSituacaoCarne(dto).altera());
    }

    private AlteraSituacaoCarne alteraSituacaoCarne(AtualizaSituacaoCarneDTO dto) {
        Carne carne = this.getCarne(new CarneId(dto.getCarneIdDTO().getEntidade(), dto.getCarneIdDTO().getExercicio(), dto.getCarneIdDTO().getCarne()));
        if (Objects.nonNull(carne.getSituacaoCarne())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel atualizar a situa\u00e7\u00e3o do carn\u00ea pois o mesmo j\u00e1 possui a situa\u00e7\u00e3o %s", carne.getSituacaoCarne().getDescricao()));
        }
        switch (1.$SwitchMap$br$com$elotech$tributos$enums$SituacaoCarne[dto.getSituacaoCarne().ordinal()]) {
            case 1: {
                return new AlteraSituacaoEntregue(carne);
            }
            case 2: {
                return new AlteraSituacaoDevolvido(carne, dto.getMotivoDevolucao(), dto.getObservacaoDevolucao());
            }
            case 3: {
                return new AlteraSituacaoCancelado(carne);
            }
        }
        throw new EloValidationException("N\u00e3o foi poss\u00edvel atualizar o carn\u00ea com os dados informados.");
    }

    @Generated
    public CarneService(CarneRepository carneRepository, DebitoParcelaRepository debitoParcelaRepository, GeraBoletoService geraBoletoService, CalculoAcrescimoService calculoAcrescimoService, VinculoCadastroFormaPagamentoService vinculoCadastroFormaPagamentoService, FormaPagamentoService formaPagamentoService, ContextService contextService, ParcelamentoCarneRepository parcelamentoCarneRepository, DebitoEmAbertoService debitoEmAbertoService, CadastroGeralService cadastroGeralService, DividaFormaPagamentoService dividaFormaPagamentoService, ProtestoService protestoService, ConsultaCarneRepository consultaCarneRepository, ModeloBoletoService modeloBoletoService) {
        this.carneRepository = carneRepository;
        this.debitoParcelaRepository = debitoParcelaRepository;
        this.geraBoletoService = geraBoletoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.vinculoCadastroFormaPagamentoService = vinculoCadastroFormaPagamentoService;
        this.formaPagamentoService = formaPagamentoService;
        this.contextService = contextService;
        this.parcelamentoCarneRepository = parcelamentoCarneRepository;
        this.debitoEmAbertoService = debitoEmAbertoService;
        this.cadastroGeralService = cadastroGeralService;
        this.dividaFormaPagamentoService = dividaFormaPagamentoService;
        this.protestoService = protestoService;
        this.consultaCarneRepository = consultaCarneRepository;
        this.modeloBoletoService = modeloBoletoService;
    }
}

