/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoObservacao;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.DebitoTributoId;
import br.com.elotech.tributos.domain.DividaTributo;
import br.com.elotech.tributos.domain.DividaTributoPK;
import br.com.elotech.tributos.domain.acrescimo.AtualizacaoDireta;
import br.com.elotech.tributos.domain.acrescimo.AtualizacaoDiretaItem;
import br.com.elotech.tributos.domain.acrescimo.AtualizacaoDiretaItemID;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.acrescimo.AtualizacaoDiretaRequestDTO;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.dto.acrescimo.DebitoAtualizacaoDiretaDTO;
import br.com.elotech.tributos.dto.acrescimo.ParcelaAtualizacaoDiretaDTO;
import br.com.elotech.tributos.dto.acrescimo.SimulacaoAtualizacaoDiretaDTO;
import br.com.elotech.tributos.dto.acrescimo.TributoAtualizacaoDiretaDTO;
import br.com.elotech.tributos.repository.DebitoParcelaRepository;
import br.com.elotech.tributos.repository.DividaTributoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.DebitoEmAbertoService;
import br.com.elotech.tributos.service.DebitoParcelaTributoService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.DebitoTributoService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.ParcelamentoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AtualizacaoDiretaService
extends CrudService<AtualizacaoDireta, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtualizacaoDiretaService.class);
    private final DebitoEmAbertoService debitoEmAbertoService;
    private final ParcelamentoService parcelamentoService;
    private final DebitoParcelaTributoService debitoParcelaTributoService;
    private final DebitoTributoService debitoTributoService;
    private final DividaTributoRepository dividaTributoRepository;
    private final DebitoParcelaRepository debitoParcelaRepository;
    private final DebitoService debitoService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final NotificacaoService notificacaoService;
    private static final Map<NotificationStatus, String> messagesNotificacao = Map.of(NotificationStatus.STARTED, "Iniciado atualiza\u00e7\u00e3o monet\u00e1ria direta", NotificationStatus.COMPLETED, "Conclu\u00eddo atualiza\u00e7\u00e3o monet\u00e1ria direta", NotificationStatus.FAILED, "Atualiza\u00e7\u00e3o monet\u00e1ria direta falhou");

    public SimulacaoAtualizacaoDiretaDTO simularAtualizacao(AtualizacaoDiretaRequestDTO dto) {
        AtualizacaoDireta atualizacaoDireta = this.calcular(dto);
        return this.buildSimulacaoAtualizacao(atualizacaoDireta);
    }

    @Async
    @Transactional
    public void gerarAtualizacaoAsync(AtualizacaoDiretaRequestDTO dto, UserSecurityDTO user) {
        log.debug("Preparando ambiente atualiza\u00e7\u00e3o monet\u00e1ria direta com os seguintes dados {}", (Object)dto.toString());
        TarefaAssincronaExecucao tarefaEmExecucao = this.startTarefaAssincrona(dto);
        Optional idNotificacao = this.notificaInicioTarefaAssincrona(tarefaEmExecucao, user);
        try {
            log.debug("Iniciando atualiza\u00e7\u00e3o monet\u00e1ria direta");
            AtualizacaoDireta atualizacaoDireta = this.calcular(dto);
            Set debitosAlterados = this.updateValoresDebitos(atualizacaoDireta);
            this.save((EloEntity)atualizacaoDireta, null);
            this.addObservacaoDebitos(atualizacaoDireta, debitosAlterados);
            this.stopTarefaAssincrona(tarefaEmExecucao, idNotificacao, user, NotificationStatus.COMPLETED, null);
            log.debug("Finalizado rotina de atualiza\u00e7\u00e3o monet\u00e1ria direta");
        }
        catch (Exception ex) {
            log.error("Erro ao realizar rotina de atualiza\u00e7\u00e3o monet\u00e1ria direta.", (Throwable)ex);
            this.stopTarefaAssincrona(tarefaEmExecucao, idNotificacao, user, NotificationStatus.FAILED, ex);
            throw ex;
        }
    }

    private TarefaAssincronaExecucao startTarefaAssincrona(AtualizacaoDiretaRequestDTO dto) {
        return this.tarefaAssincronaService.createTarefaAssincronaAtualizacaoMonetariaDireta(String.format("%s-%s/%s", dto.getIdParcelamento(), dto.getParcelaInicial(), dto.getParcelaFinal()));
    }

    private void stopTarefaAssincrona(TarefaAssincronaExecucao execucao, Optional<UUID> idNotificacao, UserSecurityDTO user, NotificationStatus status, Exception exception) {
        if (status.equals((Object)NotificationStatus.FAILED)) {
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, exception.getMessage());
        } else {
            this.tarefaAssincronaService.finalizarExecucao(execucao);
        }
        this.notificaCliente(execucao, idNotificacao, user, status);
    }

    private Optional<UUID> notificaInicioTarefaAssincrona(TarefaAssincronaExecucao execucao, UserSecurityDTO user) {
        return this.notificaCliente(execucao, Optional.empty(), user, NotificationStatus.STARTED);
    }

    private Optional<UUID> notificaCliente(TarefaAssincronaExecucao execucao, Optional<UUID> idNotificacao, UserSecurityDTO user, NotificationStatus status) {
        String titulo = "Atualiza\u00e7\u00e3o monet\u00e1ria direta";
        String message = (String)messagesNotificacao.get(status);
        TarefaAssincrona tarefa = execucao.getTarefaAssincrona();
        return this.notificacaoService.send(titulo, message, tarefa, idNotificacao, user, status);
    }

    private AtualizacaoDireta calcular(AtualizacaoDiretaRequestDTO dto) {
        AtualizacaoDireta atualizacaoDireta = AtualizacaoDiretaRequestDTO.of((AtualizacaoDiretaRequestDTO)dto, (Parcelamento)((Parcelamento)this.parcelamentoService.findOne((Serializable)dto.getIdParcelamento())));
        List debitosParcelaTributoDTO = this.debitoEmAbertoService.loadDebitoEmAberto(this.buildFiltroDebitos(atualizacaoDireta), Boolean.FALSE);
        this.validarDebitosEncontrados(debitosParcelaTributoDTO);
        DividaTributo dividaTributo = this.getDividaTributo(atualizacaoDireta, debitosParcelaTributoDTO);
        this.validarDividaTributo(dividaTributo, atualizacaoDireta, debitosParcelaTributoDTO);
        atualizacaoDireta.setAtualizacaoDiretaItens(this.createAtualizacaoDiretaItens(atualizacaoDireta, debitosParcelaTributoDTO));
        atualizacaoDireta.setAtualizado(Boolean.valueOf(true));
        atualizacaoDireta.setDataAtualizacao(LocalDate.now());
        atualizacaoDireta.setUsuarioAtualizacao(SecurityUtils.getUserAise());
        return atualizacaoDireta;
    }

    private void validarDebitosEncontrados(List<DebitoEmAbertoDTO> debitosEmAberto) {
        if (debitosEmAberto.isEmpty()) {
            throw new EloValidationException("O filtro informado n\u00e3o encontrou nenhum registro.");
        }
    }

    private DividaTributo getDividaTributo(AtualizacaoDireta atualizacaoDireta, List<DebitoEmAbertoDTO> debitosEmAberto) {
        DividaTributoPK dividaTributoPK = this.getDividaTributoPK(atualizacaoDireta, debitosEmAberto.get(0));
        return (DividaTributo)this.dividaTributoRepository.findOne((Object)dividaTributoPK);
    }

    private DividaTributoPK getDividaTributoPK(AtualizacaoDireta atualizacaoDireta, DebitoEmAbertoDTO debito) {
        DividaTributoPK dividaTributoPK = new DividaTributoPK();
        dividaTributoPK.setEntidade(debito.getEntidade());
        dividaTributoPK.setExercicio(debito.getExercicio());
        dividaTributoPK.setDivida(debito.getDivida());
        dividaTributoPK.setTributo(atualizacaoDireta.getTributo());
        return dividaTributoPK;
    }

    private void validarDividaTributo(DividaTributo dividaTributo, AtualizacaoDireta atualizacaoDireta, List<DebitoEmAbertoDTO> debitosEmAberto) {
        if (dividaTributo == null) {
            throw new EloValidationException(String.format("N\u00e3o existe o tributo %s, na d\u00edvida %d para o exerc\u00edcio %d. Fa\u00e7a o cadastro para continuar.", atualizacaoDireta.getTributo(), debitosEmAberto.get(0).getDivida(), debitosEmAberto.get(0).getExercicio()));
        }
    }

    private String buildFiltroDebitos(AtualizacaoDireta atualizacaoDireta) {
        Object filtro = String.format(" TRIBDEBITO.IDPARCELAMENTO = %d  and TRIBDEBITOPARCELA.PARCELA between %d and %d  and TRIBPARCELAMENTO.ANOCONTRATO = %d  and TRIBPARCELAMENTO.NUMEROCONTRATO = %d ", atualizacaoDireta.getParcelamento().getId(), atualizacaoDireta.getParcelaInicial(), atualizacaoDireta.getParcelaFinal(), atualizacaoDireta.getAnoContrato(), atualizacaoDireta.getNumeroContrato());
        String filtroSituacaoLegal = this.buildFiltroSituacaoLegal(atualizacaoDireta);
        if (!filtroSituacaoLegal.isEmpty()) {
            filtro = (String)filtro + String.format(" and TRIBDEBITOPARCELA.SITUACAOLEGAL in (%s) ", filtroSituacaoLegal);
        }
        return filtro;
    }

    private String buildFiltroSituacaoLegal(AtualizacaoDireta atualizacaoDireta) {
        ArrayList<String> situacoes = new ArrayList<String>();
        if (Boolean.TRUE.equals(atualizacaoDireta.getNormal())) {
            situacoes.add("0");
        }
        if (Boolean.TRUE.equals(atualizacaoDireta.getDividaAtiva())) {
            situacoes.add("1");
        }
        if (Boolean.TRUE.equals(atualizacaoDireta.getJuizo())) {
            situacoes.add("2");
        }
        return String.join((CharSequence)",", situacoes);
    }

    private List<AtualizacaoDiretaItem> createAtualizacaoDiretaItens(AtualizacaoDireta atualizacaoDireta, List<DebitoEmAbertoDTO> debitosParcelaTributoDTO) {
        BigDecimal taxa = BigDecimal.valueOf(atualizacaoDireta.getPercentual());
        return debitosParcelaTributoDTO.stream().collect(Collectors.groupingBy(debitoParcelaTributo -> new AbstractMap.SimpleEntry<Long, Long>(debitoParcelaTributo.getParcela(), debitoParcelaTributo.getIdDebito()))).values().stream().map(debitosParcelaTributoAgrupadosPorParcela -> this.createAtualizacaoDiretaItem(atualizacaoDireta, debitosParcelaTributoAgrupadosPorParcela, taxa)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private AtualizacaoDiretaItem createAtualizacaoDiretaItem(AtualizacaoDireta atualizacaoDireta, List<DebitoEmAbertoDTO> debitosParcelaTributoAgrupadosPorParcela, BigDecimal taxa) {
        BigDecimal valorReceitaCorrecao = this.calcularValorReceitaCorrecao(debitosParcelaTributoAgrupadosPorParcela, atualizacaoDireta.getTributo());
        BigDecimal valorOutrasReceitas = this.calcularValorOutrasReceitas(debitosParcelaTributoAgrupadosPorParcela, atualizacaoDireta.getTributo());
        BigDecimal valorReceitaCorrecaoAtualizada = this.calcularValorReceitaCorrecaoAtualizada(valorOutrasReceitas, valorReceitaCorrecao, taxa);
        BigDecimal valorAcrescimoSobreReceitaCorrecao = this.calcularValorAcrescimoSobreReceitaCorrecao(valorReceitaCorrecaoAtualizada, valorReceitaCorrecao);
        if (valorAcrescimoSobreReceitaCorrecao.compareTo(BigDecimal.ZERO) <= 0) {
            return null;
        }
        DebitoParcelaTributo debitoParcelaTributoCorrecao = debitosParcelaTributoAgrupadosPorParcela.stream().filter(debitoEmAbertoDTO -> debitoEmAbertoDTO.getTributo().equals(atualizacaoDireta.getTributo())).findFirst().map(debitoEmAbertoDTO -> {
            DebitoParcelaTributo debitoParcelaTributoExistente = (DebitoParcelaTributo)this.debitoParcelaTributoService.findOne((Serializable)debitoEmAbertoDTO.getIdDebitoParcelaReceita());
            debitoParcelaTributoExistente.setValor(debitoParcelaTributoExistente.getValor().add(valorAcrescimoSobreReceitaCorrecao));
            return debitoParcelaTributoExistente;
        }).orElseGet(() -> this.createDebitoParcelaTributo(atualizacaoDireta, (DebitoEmAbertoDTO)debitosParcelaTributoAgrupadosPorParcela.get(0), valorAcrescimoSobreReceitaCorrecao));
        return this.buildAtualizacaoDiretaItem(atualizacaoDireta, debitosParcelaTributoAgrupadosPorParcela, debitoParcelaTributoCorrecao, valorAcrescimoSobreReceitaCorrecao);
    }

    private AtualizacaoDiretaItem buildAtualizacaoDiretaItem(AtualizacaoDireta atualizacaoDireta, List<DebitoEmAbertoDTO> debitosParcelaTributoAgrupadosPorParcela, DebitoParcelaTributo debitoParcelaTributoCorrecao, BigDecimal valorAcrescimoSobreReceitaCorrecao) {
        AtualizacaoDiretaItemID itemID = new AtualizacaoDiretaItemID();
        itemID.setAtualizacaoDireta(atualizacaoDireta);
        itemID.setDebitoParcelaTributo(debitoParcelaTributoCorrecao);
        AtualizacaoDiretaItem item = new AtualizacaoDiretaItem();
        item.setId(itemID);
        item.setValor(valorAcrescimoSobreReceitaCorrecao);
        item.setSituacaoLegal(SituacaoLegal.fromValue((Integer)debitosParcelaTributoAgrupadosPorParcela.get(0).getSituacaoLegal()));
        return item;
    }

    private DebitoParcelaTributo createDebitoParcelaTributo(AtualizacaoDireta atualizacaoDireta, DebitoEmAbertoDTO debitoEmAbertoDTO, BigDecimal valorReceitaCorrecao) {
        DebitoParcelaId debitoParcelaId = DebitoParcelaId.builder().entidade(debitoEmAbertoDTO.getEntidade()).exercicio(debitoEmAbertoDTO.getExercicio()).tipoCadastro(debitoEmAbertoDTO.getTipoCadastro()).cadastroGeral(debitoEmAbertoDTO.getCadastroGeral()).divida(debitoEmAbertoDTO.getDivida()).subDivida(debitoEmAbertoDTO.getSubDivida()).parcela(debitoEmAbertoDTO.getParcela()).build();
        DebitoParcela debitoParcela = (DebitoParcela)this.debitoParcelaRepository.findOne((Object)debitoParcelaId);
        DebitoParcelaTributo debitoParcelaTributo = new DebitoParcelaTributo();
        debitoParcelaTributo.setDebitoParcela(debitoParcela);
        debitoParcelaTributo.setEntidade(debitoEmAbertoDTO.getEntidade());
        debitoParcelaTributo.setExercicio(debitoEmAbertoDTO.getExercicio());
        debitoParcelaTributo.setTipoCadastro(debitoEmAbertoDTO.getTipoCadastro());
        debitoParcelaTributo.setCadastroGeral(debitoEmAbertoDTO.getCadastroGeral());
        debitoParcelaTributo.setDivida(debitoEmAbertoDTO.getDivida());
        debitoParcelaTributo.setSubDivida(debitoEmAbertoDTO.getSubDivida());
        debitoParcelaTributo.setParcela(debitoEmAbertoDTO.getParcela());
        debitoParcelaTributo.setTributo(atualizacaoDireta.getTributo());
        debitoParcelaTributo.setValor(valorReceitaCorrecao);
        debitoParcelaTributo.setValorOriginal(valorReceitaCorrecao);
        debitoParcelaTributo.setTipoCalculoDebito(Long.valueOf(0L));
        debitoParcelaTributo.setCalculo(Long.valueOf(0L));
        debitoParcelaTributo.setValorJuros(BigDecimal.ZERO);
        debitoParcelaTributo.setValorMulta(BigDecimal.ZERO);
        debitoParcelaTributo.setValorCorrecao(BigDecimal.ZERO);
        debitoParcelaTributo.setValorDesconto(BigDecimal.ZERO);
        debitoParcelaTributo.setValorAtualizacao(BigDecimal.ZERO);
        debitoParcela.getTributos().add(debitoParcelaTributo);
        return debitoParcelaTributo;
    }

    public BigDecimal calcularValorAcrescimoSobreReceitaCorrecao(BigDecimal valorReceitaCorrecaoAtualizada, BigDecimal valorReceitaCorrecao) {
        return valorReceitaCorrecaoAtualizada.subtract(valorReceitaCorrecao).setScale(2, RoundingMode.HALF_EVEN);
    }

    public BigDecimal calcularValorOutrasReceitas(List<DebitoEmAbertoDTO> debitosParcelaTributo, String receitaCorrecao) {
        return debitosParcelaTributo.stream().filter(debitoParcelaTributo -> !debitoParcelaTributo.getTributo().equals(receitaCorrecao)).map(CalculaAcrescimoBaseDTO::getValorPrincipal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal calcularValorReceitaCorrecao(List<DebitoEmAbertoDTO> debitosParcelaTributo, String receitaCorrecao) {
        return debitosParcelaTributo.stream().filter(debitoParcelaTributo -> debitoParcelaTributo.getTributo().equals(receitaCorrecao)).map(CalculaAcrescimoBaseDTO::getValorPrincipal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal calcularValorReceitaCorrecaoAtualizada(BigDecimal valorOutrasReceitas, BigDecimal valorReceitaCorrecao, BigDecimal taxa) {
        BigDecimal valorTotal = valorOutrasReceitas.add(valorReceitaCorrecao);
        return valorTotal.multiply(BigDecimal.ONE.add(taxa.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_EVEN))).subtract(valorOutrasReceitas);
    }

    private SimulacaoAtualizacaoDiretaDTO buildSimulacaoAtualizacao(AtualizacaoDireta atualizacaoDireta) {
        SimulacaoAtualizacaoDiretaDTO simulacaoAtualizacaoDiretaDTO = new SimulacaoAtualizacaoDiretaDTO();
        simulacaoAtualizacaoDiretaDTO.getDebitos().addAll(this.buildDebitosSimulacao(atualizacaoDireta.getAtualizacaoDiretaItens()));
        simulacaoAtualizacaoDiretaDTO.getParcelas().addAll(this.buildParcelasSimulacao(atualizacaoDireta.getAtualizacaoDiretaItens()));
        simulacaoAtualizacaoDiretaDTO.getTributos().addAll(this.buildTributosSimulacao(atualizacaoDireta.getAtualizacaoDiretaItens()));
        return simulacaoAtualizacaoDiretaDTO;
    }

    public List<DebitoAtualizacaoDiretaDTO> buildDebitosSimulacao(List<AtualizacaoDiretaItem> atualizacaoDiretaItems) {
        HashMap<Long, DebitoAtualizacaoDiretaDTO> debitosMap = new HashMap<Long, DebitoAtualizacaoDiretaDTO>();
        for (AtualizacaoDiretaItem item : atualizacaoDiretaItems) {
            DebitoParcelaTributo debitoParcelaTributo = item.getId().getDebitoParcelaTributo();
            Long idDebito = debitoParcelaTributo.getIdDebito();
            if (!debitosMap.containsKey(idDebito)) {
                debitosMap.put(idDebito, DebitoAtualizacaoDiretaDTO.from((DebitoParcelaTributo)debitoParcelaTributo));
                continue;
            }
            ((DebitoAtualizacaoDiretaDTO)debitosMap.get(idDebito)).incrementaNumeroParcelas();
        }
        return debitosMap.values().stream().filter(Objects::nonNull).sorted(Comparator.comparing(DebitoAtualizacaoDiretaDTO::getIdDebito)).collect(Collectors.toList());
    }

    public List<ParcelaAtualizacaoDiretaDTO> buildParcelasSimulacao(List<AtualizacaoDiretaItem> atualizacaoDiretaItems) {
        return atualizacaoDiretaItems.stream().map(item -> {
            ParcelaAtualizacaoDiretaDTO parcelaDTO = new ParcelaAtualizacaoDiretaDTO();
            DebitoParcelaTributo debitoParcelaTributo = item.getId().getDebitoParcelaTributo();
            parcelaDTO.setIdDebito(debitoParcelaTributo.getIdDebito());
            parcelaDTO.setExercicio(Integer.valueOf(debitoParcelaTributo.getExercicio().intValue()));
            parcelaDTO.setDivida(Integer.valueOf(debitoParcelaTributo.getDivida().intValue()));
            parcelaDTO.setSubDivida(Integer.valueOf(debitoParcelaTributo.getSubDivida().intValue()));
            parcelaDTO.setParcela(debitoParcelaTributo.getParcela());
            parcelaDTO.setSituacao(item.getSituacaoLegal().getDescricao());
            parcelaDTO.setDataVencimento(debitoParcelaTributo.getDebitoParcela().getDataVencimento());
            parcelaDTO.setValor(debitoParcelaTributo.getDebitoParcela().getValorTotal().subtract(item.getValor()));
            parcelaDTO.setValorAtualizado(debitoParcelaTributo.getDebitoParcela().getValorTotal());
            return parcelaDTO;
        }).sorted(Comparator.comparing(ParcelaAtualizacaoDiretaDTO::getIdDebito).thenComparing(ParcelaAtualizacaoDiretaDTO::getParcela)).collect(Collectors.toList());
    }

    public List<TributoAtualizacaoDiretaDTO> buildTributosSimulacao(List<AtualizacaoDiretaItem> atualizacaoDiretaItems) {
        HashMap<String, TributoAtualizacaoDiretaDTO> tributosMap = new HashMap<String, TributoAtualizacaoDiretaDTO>();
        for (AtualizacaoDiretaItem item : atualizacaoDiretaItems) {
            DebitoParcelaTributo debitoParcelaTributo = item.getId().getDebitoParcelaTributo();
            String chave = String.format("%d-%s", debitoParcelaTributo.getIdDebito(), debitoParcelaTributo.getTributo());
            if (!tributosMap.containsKey(chave)) {
                tributosMap.put(chave, TributoAtualizacaoDiretaDTO.from((DebitoParcelaTributo)debitoParcelaTributo, (BigDecimal)item.getValor()));
                continue;
            }
            TributoAtualizacaoDiretaDTO tributoAtualizacaoDiretaDTO = (TributoAtualizacaoDiretaDTO)tributosMap.get(chave);
            tributoAtualizacaoDiretaDTO.setValor(tributoAtualizacaoDiretaDTO.getValor().add(debitoParcelaTributo.getValor()).subtract(item.getValor()));
            tributoAtualizacaoDiretaDTO.setValorAtualizado(tributoAtualizacaoDiretaDTO.getValorAtualizado().add(debitoParcelaTributo.getValor()));
        }
        return tributosMap.values().stream().sorted(Comparator.comparing(TributoAtualizacaoDiretaDTO::getIdDebito)).collect(Collectors.toList());
    }

    private Set<Debito> updateValoresDebitos(AtualizacaoDireta atualizacaoDireta) {
        HashSet<Debito> debitosAlterados = new HashSet<Debito>();
        for (AtualizacaoDiretaItem item : atualizacaoDireta.getAtualizacaoDiretaItens()) {
            DebitoParcelaTributo debitoParcelaTributo = item.getId().getDebitoParcelaTributo();
            Debito debito2 = debitoParcelaTributo.getDebitoParcela().getDebito();
            debito2.getDebitoTributoByTributo(debitoParcelaTributo.getTributo()).ifPresentOrElse(tributo -> tributo.setValorTributo(tributo.getValorTributo().add(item.getValor())), () -> {
                DividaTributo dividaTributoCorrecao = this.getDividaTributo(debito2, atualizacaoDireta.getTributo());
                DebitoTributo tributo = new DebitoTributo();
                tributo.setId(DebitoTributoId.of((DebitoParcelaTributo)debitoParcelaTributo));
                tributo.setValorTributo(item.getValor());
                tributo.setDebito(debito2);
                tributo.setOrdem(dividaTributoCorrecao.getOrdem());
                debito2.getTributos().add((DebitoTributo)this.debitoTributoService.save((EloEntity)tributo, null));
            });
            debitosAlterados.add(debito2);
            this.debitoParcelaTributoService.save((EloEntity)debitoParcelaTributo, null);
        }
        debitosAlterados.forEach(debito -> debito.validaGeracaoDebitoManual(debito.getDivida()));
        return debitosAlterados;
    }

    private DividaTributo getDividaTributo(Debito debito, String tributo) {
        return debito.getDivida().getTributos().stream().filter(dividaTributo -> dividaTributo.getTributo().getTributo().equals(tributo)).findFirst().orElseThrow(() -> new EloValidationException(String.format("O tributo %s na d\u00edvida %d para o exerc\u00edcio %d n\u00e3o foi encontrado.", tributo, debito.getDivida().getDivida(), debito.getExercicio())));
    }

    private void addObservacaoDebitos(AtualizacaoDireta atualizacaoDireta, Set<Debito> debitosAlterados) {
        debitosAlterados.forEach(debito -> {
            DebitoObservacao observacao = new DebitoObservacao();
            observacao.setDataInclusao(LocalDate.now());
            observacao.setUsuario(SecurityUtils.getUserAise());
            String textoObservacao = String.format("D\u00e9bito atualizado na atualiza\u00e7\u00e3o direta %d do parcelamento %d/%d.", atualizacaoDireta.getId(), atualizacaoDireta.getParcelamento().getNumeroContrato(), atualizacaoDireta.getParcelamento().getAnoContrato());
            observacao.setObservacao(textoObservacao);
            observacao.setDebito(debito);
            debito.getObservacoes().add(observacao);
            debito.setObservacoesId();
            this.debitoService.save(debito);
        });
    }

    @Generated
    public AtualizacaoDiretaService(DebitoEmAbertoService debitoEmAbertoService, ParcelamentoService parcelamentoService, DebitoParcelaTributoService debitoParcelaTributoService, DebitoTributoService debitoTributoService, DividaTributoRepository dividaTributoRepository, DebitoParcelaRepository debitoParcelaRepository, DebitoService debitoService, TarefaAssincronaService tarefaAssincronaService, NotificacaoService notificacaoService) {
        this.debitoEmAbertoService = debitoEmAbertoService;
        this.parcelamentoService = parcelamentoService;
        this.debitoParcelaTributoService = debitoParcelaTributoService;
        this.debitoTributoService = debitoTributoService;
        this.dividaTributoRepository = dividaTributoRepository;
        this.debitoParcelaRepository = debitoParcelaRepository;
        this.debitoService = debitoService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.notificacaoService = notificacaoService;
    }
}

