/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.security;

import br.com.elotech.keycloakmultirealm.resolver.KeycloakResolver;
import br.com.elotech.keycloakmultirealm.resolver.TenantKeycloak;
import br.com.elotech.keycloakmultirealm.resolver.TenantKeycloakConfigResolver;
import java.io.IOException;
import javax.servlet.Filter;
import org.keycloak.adapters.springsecurity.filter.KeycloakAuthenticationProcessingFilter;
import org.keycloak.adapters.springsecurity.filter.KeycloakPreAuthActionsFilter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;

@Configuration
public class KeycloakConfiguration {
    @Bean
    public KeycloakResolver keycloakResolver(@Value(value="${keycloak.configurationFile}") Resource keycloakConfigurationFile) throws IOException {
        return new TenantKeycloak(keycloakConfigurationFile.getInputStream().readAllBytes());
    }

    @Bean
    public TenantKeycloakConfigResolver keycloakConfigResolver(@Lazy KeycloakResolver keycloakResolver) {
        return new TenantKeycloakConfigResolver(keycloakResolver);
    }

    @Bean
    public FilterRegistrationBean<KeycloakAuthenticationProcessingFilter> keycloakAuthenticationProcessingFilterRegistrationBean(KeycloakAuthenticationProcessingFilter filter) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registrationBean.setEnabled(false);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<KeycloakPreAuthActionsFilter> disableKeycloakPreAuthActionsFilter(KeycloakPreAuthActionsFilter filter) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registrationBean.setEnabled(false);
        return registrationBean;
    }
}

