/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoimply;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.mobile.DocumentoMobileDTO;
import br.com.elotech.tributos.params.CertidaoParams;
import br.com.elotech.tributos.repository.projections.DocumentoFinalidadeProjection;
import br.com.elotech.tributos.service.CertidaoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DocumentoFinalidadeService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.ws.domain.GeraCertidaoResposta;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/integracao-imply/certidao"})
public class CertidaoImplyResource {
    private final DocumentoFinalidadeService documentoFinalidadeService;
    private final ContextService contextService;
    private final CertidaoService certidaoService;
    private final DocumentoService documentoService;

    public CertidaoImplyResource(DocumentoFinalidadeService documentoFinalidadeService, ContextService contextService, CertidaoService certidaoService, DocumentoService documentoService) {
        this.documentoFinalidadeService = documentoFinalidadeService;
        this.contextService = contextService;
        this.certidaoService = certidaoService;
        this.documentoService = documentoService;
    }

    @GetMapping(value={"/finalidades"}, params={"tipoCertidao"})
    public ResponseEntity<List<DocumentoFinalidadeProjection>> getFinalidade(String tipoCertidao) {
        return ResponseEntity.ok((Object)this.documentoFinalidadeService.getListDTO(this.contextService.getEntidadePrincipal(), this.contextService.getExercicioAtual(), TipoDocumentoEnum.fromString((String)tipoCertidao).getCodigo()));
    }

    @PostMapping
    public ResponseEntity<DocumentoMobileDTO> gerarCertidao(@RequestBody CertidaoParams params) {
        try {
            GeraCertidaoResposta resposta = this.certidaoService.geraCertidao(params);
            return ResponseEntity.ok((Object)this.documentoService.getDocumentoMobileDTO(this.contextService.getEntidadePrincipal(), resposta.getExercicio(), resposta.getTipoDocumento(), resposta.getDocumento()));
        }
        catch (CadastroNaoEncontradoException e) {
            throw RestException.notFound((String)e.getMessage(), (Throwable)e);
        }
    }
}

