/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaoelogeo.VinculoElogeoDTO;
import br.com.elotech.tributos.service.VinculoService;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/vinculo"})
public class VinculoElogeoResource {
    private final VinculoService vinculoService;

    public VinculoElogeoResource(VinculoService vinculoService) {
        this.vinculoService = vinculoService;
    }

    @Operation(summary="Retorna um lista de v\u00ednculos dos propriet\u00e1rios")
    @GetMapping
    public ResponseEntity<Page<VinculoElogeoDTO>> findAll(@ParameterObject Pageable page) {
        Page vinculos = this.vinculoService.findAll(page).map(VinculoElogeoDTO::from);
        return ResponseEntity.ok((Object)vinculos);
    }

    @Operation(summary="Retorna um v\u00ednculo dos propriet\u00e1rios em espec\u00edfico")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<VinculoElogeoDTO> findById(@PathVariable Long id) {
        VinculoElogeoDTO vinculoElogeoDTO = this.vinculoService.findById((Serializable)id).map(VinculoElogeoDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o V\u00ednculo com o id '%d'.", id)));
        return ResponseEntity.ok((Object)vinculoElogeoDTO);
    }
}

