/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.CancelarMultiPeticoesDTO;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoItemPeticaoDTO;
import br.com.elotech.tributos.dto.ErroCancelarPeticaoDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoDocumentoDTO;
import br.com.elotech.tributos.dto.documento.peticao.ExecucaoPeticaoResponseDTO;
import br.com.elotech.tributos.resource.RelatorioResource;
import br.com.elotech.tributos.service.DocumentoPeticaoService;
import br.com.elotech.tributos.service.DocumentoService;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/peticoes"})
@Transactional
public class DocumentoPeticaoResource {
    private final DocumentoPeticaoService documentoPeticaoService;
    private final RelatorioResource relatorioResource;
    private final DocumentoService documentoService;

    public DocumentoPeticaoResource(DocumentoPeticaoService documentoPeticaoService, RelatorioResource relatorioResource, DocumentoService documentoService) {
        this.documentoPeticaoService = documentoPeticaoService;
        this.relatorioResource = relatorioResource;
        this.documentoService = documentoService;
    }

    @GetMapping
    public ResponseEntity<Page<DocumentoDTO>> findAll(@RequestParam Optional<String> search, Pageable page) {
        String searchFilter = String.format("tipoDocumento == %d", TipoDocumentoEnum.PETICAO_DIVIDA_ATIVA.getCodigo());
        if (search.isPresent()) {
            searchFilter = searchFilter.concat(" and ").concat(search.get());
        }
        return ResponseEntity.ok((Object)this.documentoService.getDocumentosPeticoesComCDA(Optional.of(searchFilter), page));
    }

    @GetMapping(value={"/ids-check-all"})
    public ResponseEntity<List<Long>> findAllIdsPeticoesAtivasParaCheckAll(@RequestParam Optional<String> search) {
        String searchFilter = String.format("tipoDocumento == %d  and  cancelado == false", TipoDocumentoEnum.PETICAO_DIVIDA_ATIVA.getCodigo());
        if (search.isPresent()) {
            searchFilter = searchFilter.concat(" and ").concat(search.get());
        }
        return ResponseEntity.ok((Object)this.documentoService.getIdsPeticoesAtivasParaCheckall(Optional.of(searchFilter)));
    }

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<DocumentoDTO> findDocumentosDividaAtiva(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.documentoPeticaoService.findPeticaoDividaAtiva(id));
    }

    @Transactional
    @PutMapping(value={"/{id}/cancelar"})
    public ResponseEntity<DocumentoDTO> cancelarPeticao(@PathVariable Long id, @RequestBody CancelamentoDocumentoDTO cancelamentoDocumentoDTO) {
        return ResponseEntity.ok((Object)this.documentoPeticaoService.cancelarPeticao(id, cancelamentoDocumentoDTO));
    }

    @GetMapping(value={"/{id}/imprimir-peticao-divida-ativa"})
    public void getImprimirPeticoesDividaAtiva(@PathVariable Long id, HttpServletResponse response) throws IOException {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.documentoPeticaoService.buildImpressaoPeticaoDTO(id);
        this.relatorioResource.imprimirRelatorioGenerico(imprimirRelatorioDTO, response);
    }

    @GetMapping(value={"/execucoes"})
    public ResponseEntity<Page<ExecucaoPeticaoResponseDTO>> findAllAtivas(@RequestParam(value="search") String search, Pageable page) {
        return ResponseEntity.ok((Object)this.documentoService.getDocumentosExecucoesAtivas(search, page));
    }

    @GetMapping(value={"/execucoes/{id}/certidoes-divida-ativa"})
    public ResponseEntity<List<DocumentoItemPeticaoDTO>> findDocumentosDividaAtivaExecucoes(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.documentoPeticaoService.findDividaAtivaPorPeticao(id));
    }

    @PutMapping(value={"/cancelar"})
    public ResponseEntity<List<ErroCancelarPeticaoDTO>> cancelarPeticaoEmLote(@RequestBody CancelarMultiPeticoesDTO cancelarPeticaoEmLote) {
        return ResponseEntity.ok((Object)this.documentoPeticaoService.cancelarPeticaoEmLote(cancelarPeticaoEmLote));
    }
}

