/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CancelamentoBoleto;
import br.com.elotech.tributos.dto.FiltroBoletoDTO;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.cancelamentoboleto.CancelamentoBoletoResponseDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CancelamentoBoletoService;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cancelamento-boleto"})
public class CancelamentoBoletoResource {
    private final CancelamentoBoletoService cancelamentoBloquetoService;

    @PostMapping
    public ResponseEntity<Void> cancelamentoBoleto(@RequestBody List<Long> idBoletos) {
        UserSecurityDTO user = SecurityUtils.getUserSecurityDTO();
        this.cancelamentoBloquetoService.cancelarBoletoId(idBoletos, user);
        return ResponseEntity.accepted().build();
    }

    @PostMapping(value={"/filtro"})
    public ResponseEntity<Void> cancelamentoBoletoPorFiltro(@RequestBody FiltroBoletoDTO filtro) {
        UserSecurityDTO user = SecurityUtils.getUserSecurityDTO();
        this.cancelamentoBloquetoService.cancelarBoletoPorFiltro(filtro, user);
        return ResponseEntity.accepted().build();
    }

    @GetMapping
    public ResponseEntity<Page<CancelamentoBoletoResponseDTO>> findAll(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page cancelamentoBoleto = this.cancelamentoBloquetoService.findByRsql(search, pageable);
        return ResponseEntity.ok((Object)cancelamentoBoleto.map(CancelamentoBoletoResponseDTO::fromEntity));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<CancelamentoBoletoResponseDTO> findById(@PathVariable(value="id") Long id) {
        CancelamentoBoleto cancelamentoBoleto = (CancelamentoBoleto)this.cancelamentoBloquetoService.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("Cancelamento de boleto com id %s n\u00e3o encontrado", id)));
        return ResponseEntity.ok((Object)CancelamentoBoletoResponseDTO.fromEntityWithBoletos((CancelamentoBoleto)cancelamentoBoleto));
    }

    @PutMapping(value={"/reprocessar/{id}"})
    public ResponseEntity<Void> reprocessarBoletosComErro(@PathVariable(value="id") Long id) {
        UserSecurityDTO user = SecurityUtils.getUserSecurityDTO();
        this.cancelamentoBloquetoService.reprocessarBoletos(id, user);
        return ResponseEntity.accepted().build();
    }

    @Generated
    public CancelamentoBoletoResource(CancelamentoBoletoService cancelamentoBloquetoService) {
        this.cancelamentoBloquetoService = cancelamentoBloquetoService;
    }
}

