/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.debitoautomatico.RemessaDebitoAutomaticoArquivoItemDTO;
import br.com.elotech.tributos.dto.debitoautomatico.RemessaDebitoAutomaticoFilterDTO;
import br.com.elotech.tributos.repository.DebitoAutomaticoRemessaCustom;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DebitoAutomaticoRemessaRepositoryImpl
implements DebitoAutomaticoRemessaCustom {
    private static final String GERAR_DEBITOS_AUTOMATICOS_REMESSA = "br/com/elotech/tributos/repository/gerar-debito-automatico-remessa.sql";
    private static final String ITENS_DEBITOS_AUTOMATICOS_REMESSA = "br/com/elotech/tributos/repository/itens-debito-automatico-remessa.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public DebitoAutomaticoRemessaRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Long totalItensParaGerar(RemessaDebitoAutomaticoFilterDTO filtro) {
        String sql = FileUtils.readResourceAsString((String)GERAR_DEBITOS_AUTOMATICOS_REMESSA);
        String finalSql = sql.replace("$[FILTROS]", filtro.buildFiltro());
        String sqlContagem = String.format("select count(*) as total from (%s) count_query", finalSql);
        return (Long)this.jdbcTemplate.queryForObject(sqlContagem, (SqlParameterSource)filtro.buildParameters(), (rs, rowNum) -> rs.getLong("total"));
    }

    public List<RemessaDebitoAutomaticoArquivoItemDTO> findItensArquivoRemessa(Long idRemessa) {
        String sql = FileUtils.readResourceAsString((String)ITENS_DEBITOS_AUTOMATICOS_REMESSA);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idRemessa", (Object)idRemessa);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(RemessaDebitoAutomaticoArquivoItemDTO.class));
    }
}

