/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.calculo.dto.CalculoGeracaoLoteFiltroDTO;
import br.com.elotech.tributos.dto.CadastroGeralEdicaoEmMassaDTO;
import br.com.elotech.tributos.dto.CadastroGeralMobiliarioEdicaoEmMassaDTO;
import br.com.elotech.tributos.dto.EdicaoEmMassaFiltroDTO;
import br.com.elotech.tributos.enums.TipoEdicaoEmMassa;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import lombok.Generated;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class EdicaoEmMassaRepository {
    private final EntityManager entityManager;
    private static final String SQL_FIND_CADASTROS_IMOBILIARIOS = "sql/findCadastroGeralEdicaoEmMassa.sql";
    private static final String SQL_FIND_CADASTROS_MOBILIARIOS = "sql/findCadastroGeralMobiliarioEdicaoEmMassa.sql";
    private static final String AND = " AND ";

    public List<CadastroGeralEdicaoEmMassaDTO> findCadastrosImobiliariosWithFilter(EdicaoEmMassaFiltroDTO filtro) {
        String sql = this.generateSql(filtro, TipoEdicaoEmMassa.IMOBILIARIO);
        Query query = this.entityManager.createNativeQuery(sql);
        return query.getResultList().stream().map(CadastroGeralEdicaoEmMassaDTO::new).collect(Collectors.toList());
    }

    public List<CadastroGeralEdicaoEmMassaDTO> findCadastrosImobiliariosWithFilter(EdicaoEmMassaFiltroDTO filtro, Pageable pageable) {
        String sql = this.generateSql(filtro, TipoEdicaoEmMassa.IMOBILIARIO);
        Query query = this.entityManager.createNativeQuery(sql);
        this.applyPagination(query, pageable);
        return query.getResultList().stream().map(CadastroGeralEdicaoEmMassaDTO::new).collect(Collectors.toList());
    }

    public List<CadastroGeralMobiliarioEdicaoEmMassaDTO> findCadastrosMobiliariosWithFilter(EdicaoEmMassaFiltroDTO filtro, Pageable pageable) {
        String sql = this.generateSql(filtro, TipoEdicaoEmMassa.MOBILIARIO);
        Query query = this.entityManager.createNativeQuery(sql);
        this.applyPagination(query, pageable);
        return query.getResultList().stream().map(CadastroGeralMobiliarioEdicaoEmMassaDTO::new).collect(Collectors.toList());
    }

    public Long getTotalCadastrosWithFilter(String sql) {
        String sqlMax = String.format(" WITH totalcadastros AS ( %s \n)\n SELECT COUNT(*) FROM totalcadastros ", sql);
        Query query = this.entityManager.createNativeQuery(sqlMax);
        return Long.valueOf(query.getSingleResult().toString());
    }

    public String generateSql(EdicaoEmMassaFiltroDTO filtro, TipoEdicaoEmMassa tipo) {
        String where = AND + filtro.getFiltros().stream().map(CalculoGeracaoLoteFiltroDTO::generateFiltro).collect(Collectors.joining(AND));
        return String.format(FileUtils.readResourceAsString((String)(TipoEdicaoEmMassa.IMOBILIARIO.equals((Object)tipo) ? SQL_FIND_CADASTROS_IMOBILIARIOS : SQL_FIND_CADASTROS_MOBILIARIOS)), where);
    }

    private void applyPagination(Query query, Pageable pageable) {
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
    }

    @Generated
    public EdicaoEmMassaRepository(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

