/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtiva;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtivaId;
import br.com.elotech.tributos.repository.documento.cda.DocumentoItemDividaAtivaRepositoryCustom;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface DocumentoItemDividaAtivaRepository
extends CrudRepository<DocumentoItemDividaAtiva, DocumentoItemDividaAtivaId>,
DocumentoItemDividaAtivaRepositoryCustom {
    @Query(value="select cda from DocumentoItemDividaAtiva cda  where cda.id.entidade = :entidade  and cda.exercicioDebito = :exercicio  and cda.tipoCadastro = :tipoCadastro  and cda.cadastroGeral = :cadastroGeral  and cda.codigoDivida = :divida  and cda.subDivida = :subDivida  and cda.parcela = :parcela ")
    public List<DocumentoItemDividaAtiva> findByDebitoParcela(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2, @Param(value="tipoCadastro") Long var3, @Param(value="cadastroGeral") Long var4, @Param(value="divida") Long var5, @Param(value="subDivida") Long var6, @Param(value="parcela") Long var7);

    @Query(value="select cda.id from DocumentoItemDividaAtiva cda  where cda.id.entidade = :entidade  and cda.exercicioDebito = :exercicio  and cda.tipoCadastro = :tipoCadastro  and cda.cadastroGeral = :cadastroGeral  and cda.codigoDivida = :divida  and cda.subDivida = :subDivida  and cda.parcela = :parcela ")
    public List<DocumentoItemDividaAtivaId> findCDAIdByCdaDebitoParcela(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2, @Param(value="tipoCadastro") Long var3, @Param(value="cadastroGeral") Long var4, @Param(value="divida") Long var5, @Param(value="subDivida") Long var6, @Param(value="parcela") Long var7);

    @Modifying
    @Query(value="delete from tribdocumentoitempeticao  where entidade = :entidade    and exerciciocertidao = :exercicio    and tipodocumentocertidao = :tipoDocumento    and documentocertidao = :documento    and sequenciacertidao = :sequencia", nativeQuery=true)
    public void deleteDocumentoItemPeticaoByDocumentoItemDividaAtivaId(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2, @Param(value="tipoDocumento") Long var3, @Param(value="documento") Long var4, @Param(value="sequencia") Long var5);

    @Query(value="select cda from DocumentoItemDividaAtiva cda  where cda.documento.id = :idDocumento ")
    public List<DocumentoItemDividaAtiva> findByDocumentoId(@Param(value="idDocumento") Long var1);

    @Query(value="select count(1) >= 1 from triblivroparcelareceita tlpr                join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tlpr.iddebitoparcelareceita                join tribdocumentoitemdividaativa cda on cda.exerciciolivro = tlpr.exercicio                                                     and cda.livro = tlpr.livro                                                     and cda.entidade = tlpr.entidade                                                     and cda.exerciciodebito = tdpr.exercicio                                                     and cda.tipocadastro = tdpr.tipocadastro                                                     and cda.cadastrogeral = tdpr.cadastrogeral                                                     and cda.guiarecolhimento = tdpr.guiarecolhimento                                                     and cda.subdivida = tdpr.subdivida                                                     and cda.receita = tdpr.receita                                                     and cda.parcela = tdpr.parcela                join tribdocumento td on td.entidade = cda.entidade                                     and td.tipocadastro = cda.tipocadastro                                     and td.cadastrogeral = cda.cadastrogeral                                     and td.documento = cda.documento                                     and td.tipodocumento = :tipoDocumento where tlpr.entidade = :entidade and tlpr.exercicio = :exercicio and tlpr.livro = :livro and tlpr.sequencia = :sequencia and tlpr.iddebitoparcelareceita = :idDebitoParcelaReceita and td.cancelado = 'N' ", nativeQuery=true)
    public Boolean findDocumentoByLivro(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2, @Param(value="livro") Long var3, @Param(value="sequencia") Long var4, @Param(value="idDebitoParcelaReceita") Long var5, @Param(value="tipoDocumento") Long var6);

    @Query(value="select count(1) >= 1 from  tribdebito td                         join tribdebitoparcela tdp on td.entidade = tdp.entidade and td.exercicio = tdp.exercicio and td.tipocadastro = tdp.tipocadastro and td.cadastrogeral = tdp.cadastrogeral and td.guiarecolhimento = tdp.guiarecolhimento and td.subdivida = tdp.subdivida                         join tribdebitoparcelareceita tdpr on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral = tdpr.cadastrogeral and tdp.guiarecolhimento = tdpr.guiarecolhimento and tdp.subdivida = tdpr.subdivida and tdp.parcela = tdpr.parcela                         join tribdocumentoitemdividaativa cda on  cda.exerciciodebito = tdpr.exercicio                                                              and cda.tipocadastro = tdpr.tipocadastro                                                              and cda.cadastrogeral = tdpr.cadastrogeral                                                              and cda.guiarecolhimento = tdpr.guiarecolhimento                                                              and cda.subdivida = tdpr.subdivida                                                              and cda.receita = tdpr.receita                                                              and cda.parcela = tdpr.parcela                         join tribdocumento tdc on tdc.entidade = cda.entidade                                              and tdc.tipocadastro = cda.tipocadastro                                              and tdc.cadastrogeral = cda.cadastrogeral                                              and tdc.documento = cda.documento                                              and tdc.tipodocumento = :tipoDocumento          where cda.entidade = :entidade          and cda.exercicio = :exercicio          and cda.livro = :livro          and td.iddebito = :idDebito          and td.subdivida = :subDivida          and tdc.cancelado = 'N' ", nativeQuery=true)
    public Boolean findDocumentoByLivroEnglobado(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2, @Param(value="livro") Long var3, @Param(value="idDebito") Long var4, @Param(value="tipoDocumento") Long var5, @Param(value="subDivida") Long var6);

    @Query(value="SELECT COALESCE(SUM(t.valor), 0) +        COALESCE(SUM(t.valorJuros), 0) +        COALESCE(SUM(t.valorMulta), 0) +        COALESCE(SUM(t.valorCorrecao), 0) FROM DocumentoItemDividaAtiva t WHERE t.id.documento = :documento   AND t.id.exercicio = :exercicio   AND t.id.tipoDocumento = :tipoDocumento")
    public BigDecimal findValorTotalPorCda(@Param(value="documento") Long var1, @Param(value="exercicio") Long var2, @Param(value="tipoDocumento") Long var3);
}

