/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.sicredi;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.integracaoboleto.sicredi.CalendarioPixSicrediDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicredi.DevedorPixSicrediDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicredi.InfoAdicionaisPixSicrediDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicredi.QrCodePixSicrediRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicredi.ValorPixSicrediDTO;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class QrCodePixSicrediRequestDTO {
    private CalendarioPixSicrediDTO calendario;
    private DevedorPixSicrediDTO devedor;
    private ValorPixSicrediDTO valor;
    private String chave;
    private List<InfoAdicionaisPixSicrediDTO> infoAdicionais;

    public static QrCodePixSicrediRequestDTO from(Bloqueto boleto) {
        Pessoa pessoa = boleto.getPessoa();
        EnderecoPessoa enderecoPrincipal = pessoa.getEnderecoPrincipal();
        CalendarioPixSicrediDTO calendario = CalendarioPixSicrediDTO.builder().dataDeVencimento(boleto.getDataVencimento().toString()).validadeAposVencimento(Integer.valueOf(0)).build();
        DevedorPixSicrediDTO devedor = DevedorPixSicrediDTO.builder().cpf(TipoPessoa.FISICA.equals((Object)pessoa.getTipoPessoa()) ? pessoa.getCnpjCpfSemMascara() : null).cnpj(TipoPessoa.JURIDICA.equals((Object)pessoa.getTipoPessoa()) ? pessoa.getCnpjCpfSemMascara() : null).nome(pessoa.getNome()).cep((String)Optional.ofNullable(enderecoPrincipal).map(EnderecoPessoa::getCep).map(cep -> StringUtils.leftPad((String)cep.toString(), (int)8, (String)"0")).orElse(null)).cidade((String)Optional.ofNullable(enderecoPrincipal).map(EnderecoPessoa::getCidade).map(Cidade::getDescricao).orElse(null)).uf((String)Optional.ofNullable(enderecoPrincipal).map(EnderecoPessoa::getCidade).map(Cidade::getUnidadeFederacao).orElse(null)).logradouro((String)Optional.ofNullable(enderecoPrincipal).map(EnderecoPessoa::getLogradouro).map(Logradouro::getDescricao).orElse(null)).build();
        ValorPixSicrediDTO valor = ValorPixSicrediDTO.builder().original(boleto.getValorBloqueto()).build();
        List infoAdicionais = InfoAdicionaisPixSicrediDTO.builder().nome("codbarra").valor(boleto.getCodigoBarras()).build().toList();
        return QrCodePixSicrediRequestDTO.builder().calendario(calendario).devedor(devedor).valor(valor).chave(boleto.getModeloBloqueto().getConvenio().getChavePix()).infoAdicionais(infoAdicionais).build();
    }

    @Generated
    QrCodePixSicrediRequestDTO(CalendarioPixSicrediDTO calendario, DevedorPixSicrediDTO devedor, ValorPixSicrediDTO valor, String chave, List<InfoAdicionaisPixSicrediDTO> infoAdicionais) {
        this.calendario = calendario;
        this.devedor = devedor;
        this.valor = valor;
        this.chave = chave;
        this.infoAdicionais = infoAdicionais;
    }

    @Generated
    public static QrCodePixSicrediRequestDTOBuilder builder() {
        return new QrCodePixSicrediRequestDTOBuilder();
    }

    @Generated
    public CalendarioPixSicrediDTO getCalendario() {
        return this.calendario;
    }

    @Generated
    public DevedorPixSicrediDTO getDevedor() {
        return this.devedor;
    }

    @Generated
    public ValorPixSicrediDTO getValor() {
        return this.valor;
    }

    @Generated
    public String getChave() {
        return this.chave;
    }

    @Generated
    public List<InfoAdicionaisPixSicrediDTO> getInfoAdicionais() {
        return this.infoAdicionais;
    }

    @Generated
    public void setCalendario(CalendarioPixSicrediDTO calendario) {
        this.calendario = calendario;
    }

    @Generated
    public void setDevedor(DevedorPixSicrediDTO devedor) {
        this.devedor = devedor;
    }

    @Generated
    public void setValor(ValorPixSicrediDTO valor) {
        this.valor = valor;
    }

    @Generated
    public void setChave(String chave) {
        this.chave = chave;
    }

    @Generated
    public void setInfoAdicionais(List<InfoAdicionaisPixSicrediDTO> infoAdicionais) {
        this.infoAdicionais = infoAdicionais;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QrCodePixSicrediRequestDTO)) {
            return false;
        }
        QrCodePixSicrediRequestDTO other = (QrCodePixSicrediRequestDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CalendarioPixSicrediDTO this$calendario = this.getCalendario();
        CalendarioPixSicrediDTO other$calendario = other.getCalendario();
        if (this$calendario == null ? other$calendario != null : !this$calendario.equals(other$calendario)) {
            return false;
        }
        DevedorPixSicrediDTO this$devedor = this.getDevedor();
        DevedorPixSicrediDTO other$devedor = other.getDevedor();
        if (this$devedor == null ? other$devedor != null : !this$devedor.equals(other$devedor)) {
            return false;
        }
        ValorPixSicrediDTO this$valor = this.getValor();
        ValorPixSicrediDTO other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !this$valor.equals(other$valor)) {
            return false;
        }
        String this$chave = this.getChave();
        String other$chave = other.getChave();
        if (this$chave == null ? other$chave != null : !this$chave.equals(other$chave)) {
            return false;
        }
        List this$infoAdicionais = this.getInfoAdicionais();
        List other$infoAdicionais = other.getInfoAdicionais();
        return !(this$infoAdicionais == null ? other$infoAdicionais != null : !((Object)this$infoAdicionais).equals(other$infoAdicionais));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QrCodePixSicrediRequestDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CalendarioPixSicrediDTO $calendario = this.getCalendario();
        result = result * 59 + ($calendario == null ? 43 : $calendario.hashCode());
        DevedorPixSicrediDTO $devedor = this.getDevedor();
        result = result * 59 + ($devedor == null ? 43 : $devedor.hashCode());
        ValorPixSicrediDTO $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : $valor.hashCode());
        String $chave = this.getChave();
        result = result * 59 + ($chave == null ? 43 : $chave.hashCode());
        List $infoAdicionais = this.getInfoAdicionais();
        result = result * 59 + ($infoAdicionais == null ? 43 : ((Object)$infoAdicionais).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "QrCodePixSicrediRequestDTO(calendario=" + this.getCalendario() + ", devedor=" + this.getDevedor() + ", valor=" + this.getValor() + ", chave=" + this.getChave() + ", infoAdicionais=" + this.getInfoAdicionais() + ")";
    }
}

