/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.cadastroimobiliario;

import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoSegmento;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaSegmento;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.dto.cadastroimobiliario.SituacaoSegmentoDTO;
import br.com.elotech.tributos.dto.camposdinamicos.GrupoRespostasDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class SegmentoDTO {
    private Long id;
    private Long sequencia;
    @NotNull
    private TipoSegmento tipoSegmento;
    private BigDecimal areaConstruida = BigDecimal.ZERO;
    private SituacaoSegmentoDTO situacao;
    private List<GrupoRespostasDTO> respostasSegmento = new ArrayList();
    private Boolean delete = false;

    public static SegmentoDTO from(CadastroImobiliarioSegmento entity) {
        SegmentoDTO dto = new SegmentoDTO();
        dto.setId(entity.getId());
        dto.setSequencia(entity.getSequencia());
        dto.setTipoSegmento(entity.getTipoSegmento());
        dto.setAreaConstruida(entity.getAreaConstruida());
        Optional.ofNullable(entity.getSituacaoSegmento()).map(SituacaoSegmentoDTO::from).ifPresent(arg_0 -> dto.setSituacao(arg_0));
        return dto;
    }

    public CadastroImobiliarioSegmento toEntity(TipoCadastro tipoCadastro, Long cadastroGeral) {
        CadastroImobiliarioSegmento entity = new CadastroImobiliarioSegmento();
        entity.setId(this.getId());
        entity.setTipoCadastro(tipoCadastro);
        entity.setCadastroGeral(cadastroGeral);
        entity.setSequencia(this.getSequencia());
        entity.setAreaConstruida(this.getAreaConstruida());
        Optional.ofNullable(this.getSituacao()).map(SituacaoSegmentoDTO::toEntity).ifPresent(arg_0 -> ((CadastroImobiliarioSegmento)entity).setSituacaoSegmento(arg_0));
        entity.setTipoSegmento(this.getTipoSegmento());
        Optional.ofNullable(this.getTipoSegmento()).map(TipoSegmento::getId).ifPresent(arg_0 -> ((CadastroImobiliarioSegmento)entity).setIdTipoSegmento(arg_0));
        this.getRespostasSegmento().forEach(grupoRespostasDTO -> grupoRespostasDTO.getRespostasPreenchidas().forEach(resposta -> entity.getRespostasSegmento().add((RespostaSegmento)resposta.copyTo((Resposta)new RespostaSegmento()))));
        return entity;
    }

    @Generated
    public SegmentoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public TipoSegmento getTipoSegmento() {
        return this.tipoSegmento;
    }

    @Generated
    public BigDecimal getAreaConstruida() {
        return this.areaConstruida;
    }

    @Generated
    public SituacaoSegmentoDTO getSituacao() {
        return this.situacao;
    }

    @Generated
    public List<GrupoRespostasDTO> getRespostasSegmento() {
        return this.respostasSegmento;
    }

    @Generated
    public Boolean getDelete() {
        return this.delete;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setTipoSegmento(TipoSegmento tipoSegmento) {
        this.tipoSegmento = tipoSegmento;
    }

    @Generated
    public void setAreaConstruida(BigDecimal areaConstruida) {
        this.areaConstruida = areaConstruida;
    }

    @Generated
    public void setSituacao(SituacaoSegmentoDTO situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setRespostasSegmento(List<GrupoRespostasDTO> respostasSegmento) {
        this.respostasSegmento = respostasSegmento;
    }

    @Generated
    public void setDelete(Boolean delete) {
        this.delete = delete;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentoDTO)) {
            return false;
        }
        SegmentoDTO other = (SegmentoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        Boolean this$delete = this.getDelete();
        Boolean other$delete = other.getDelete();
        if (this$delete == null ? other$delete != null : !((Object)this$delete).equals(other$delete)) {
            return false;
        }
        TipoSegmento this$tipoSegmento = this.getTipoSegmento();
        TipoSegmento other$tipoSegmento = other.getTipoSegmento();
        if (this$tipoSegmento == null ? other$tipoSegmento != null : !this$tipoSegmento.equals(other$tipoSegmento)) {
            return false;
        }
        BigDecimal this$areaConstruida = this.getAreaConstruida();
        BigDecimal other$areaConstruida = other.getAreaConstruida();
        if (this$areaConstruida == null ? other$areaConstruida != null : !((Object)this$areaConstruida).equals(other$areaConstruida)) {
            return false;
        }
        SituacaoSegmentoDTO this$situacao = this.getSituacao();
        SituacaoSegmentoDTO other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        List this$respostasSegmento = this.getRespostasSegmento();
        List other$respostasSegmento = other.getRespostasSegmento();
        return !(this$respostasSegmento == null ? other$respostasSegmento != null : !((Object)this$respostasSegmento).equals(other$respostasSegmento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SegmentoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        Boolean $delete = this.getDelete();
        result = result * 59 + ($delete == null ? 43 : ((Object)$delete).hashCode());
        TipoSegmento $tipoSegmento = this.getTipoSegmento();
        result = result * 59 + ($tipoSegmento == null ? 43 : $tipoSegmento.hashCode());
        BigDecimal $areaConstruida = this.getAreaConstruida();
        result = result * 59 + ($areaConstruida == null ? 43 : ((Object)$areaConstruida).hashCode());
        SituacaoSegmentoDTO $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        List $respostasSegmento = this.getRespostasSegmento();
        result = result * 59 + ($respostasSegmento == null ? 43 : ((Object)$respostasSegmento).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SegmentoDTO(id=" + this.getId() + ", sequencia=" + this.getSequencia() + ", tipoSegmento=" + this.getTipoSegmento() + ", areaConstruida=" + this.getAreaConstruida() + ", situacao=" + this.getSituacao() + ", respostasSegmento=" + this.getRespostasSegmento() + ", delete=" + this.getDelete() + ")";
    }
}

