/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.acrescimo;

import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.util.SituacaoDebitoUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public abstract class CalculaAcrescimoBaseDTO {
    protected Boolean filtroTodosCadastros;
    protected Long pessoa;
    protected Long entidade;
    protected Long exercicio;
    protected Long divida;
    protected Long subDivida;
    protected Long parcela;
    protected Long tipoCadastro;
    protected Long cadastroGeral;
    protected LocalDate dataVencimento;
    protected LocalDate dataLancamento;
    protected LocalDate dataPrimeiraParcela;
    protected Integer situacaoLegal;
    protected Long formaCorrecao;
    protected Boolean parcelado = Boolean.FALSE;
    protected Boolean reparcelado = Boolean.FALSE;
    protected String tributo;
    protected Long idDebito;
    protected Long idProtesto;
    protected Long idParcelamento;
    protected Long tipoSituacaoParcela;
    protected String situacaoDebitoDescricao;
    protected BigDecimal valorPrincipal = BigDecimal.ZERO;
    protected BigDecimal valorJuros = BigDecimal.ZERO;
    protected BigDecimal valorMulta = BigDecimal.ZERO;
    protected BigDecimal valorCorrecao = BigDecimal.ZERO;
    protected BigDecimal valorDescontoPrincipal = BigDecimal.ZERO;
    protected BigDecimal valorDescontoJuros = BigDecimal.ZERO;
    protected BigDecimal valorDescontoMulta = BigDecimal.ZERO;
    protected BigDecimal valorDescontoCorrecao = BigDecimal.ZERO;
    protected BigDecimal valorOriginalDebito = BigDecimal.ZERO;
    protected Set<Long> idDebitosAgrupados = new HashSet();

    public String getSituacao() {
        return SituacaoDebitoUtils.getDescricaoSituacao((String)this.situacaoDebitoDescricao, (SituacaoLegal)SituacaoLegal.fromValue((Integer)this.situacaoLegal), (Boolean)this.parcelado, (Boolean)this.reparcelado, (Boolean)this.getProtestado());
    }

    public Boolean getProtestado() {
        return Optional.ofNullable(this.idProtesto).map(arg_0 -> this.greaterThanZero(arg_0)).orElse(false);
    }

    private Boolean greaterThanZero(Long value) {
        return value > 0L;
    }

    public BigDecimal getValorAcrescimos() {
        return this.valorJuros.add(this.valorMulta).add(this.valorCorrecao);
    }

    public BigDecimal getValorDescontos() {
        return this.valorDescontoPrincipal.add(this.valorDescontoJuros).add(this.valorDescontoMulta).add(this.valorDescontoCorrecao);
    }

    public BigDecimal getValorTotal() {
        return this.valorPrincipal.add(this.getValorAcrescimos()).subtract(this.getValorDescontos());
    }

    public abstract <T extends CalculaAcrescimoBaseDTO> T add(T var1);

    protected <T extends CalculaAcrescimoBaseDTO> T internalAdd(T dto) {
        this.setValorPrincipal(this.getValorPrincipal().add(dto.getValorPrincipal()));
        this.setValorJuros(this.getValorJuros().add(dto.getValorJuros()));
        this.setValorMulta(this.getValorMulta().add(dto.getValorMulta()));
        this.setValorCorrecao(this.getValorCorrecao().add(dto.getValorCorrecao()));
        this.setValorDescontoPrincipal(this.getValorDescontoPrincipal().add(dto.getValorDescontoPrincipal()));
        this.setValorDescontoJuros(this.getValorDescontoJuros().add(dto.getValorDescontoJuros()));
        this.setValorDescontoMulta(this.getValorDescontoMulta().add(dto.getValorDescontoMulta()));
        this.setValorDescontoCorrecao(this.getValorDescontoCorrecao().add(dto.getValorDescontoCorrecao()));
        this.idDebitosAgrupados.add(dto.getIdDebito());
        return (T)this;
    }

    public static <T extends CalculaAcrescimoBaseDTO> List<T> agruparPorParcela(List<T> debitos) {
        Comparator<CalculaAcrescimoBaseDTO> comparator = Comparator.comparing(CalculaAcrescimoBaseDTO::getTipoCadastro).thenComparing(CalculaAcrescimoBaseDTO::getCadastroGeral).thenComparing(CalculaAcrescimoBaseDTO::getExercicio).thenComparing(CalculaAcrescimoBaseDTO::getDivida).thenComparing(CalculaAcrescimoBaseDTO::getSubDivida).thenComparing(CalculaAcrescimoBaseDTO::getParcela);
        Map agrupados = debitos.stream().collect(Collectors.groupingBy(CalculaAcrescimoBaseDTO::geraChaveAgrupamento, Collectors.reducing(CalculaAcrescimoBaseDTO::add)));
        return agrupados.values().stream().map(Optional::get).sorted(comparator).collect(Collectors.toList());
    }

    public Set<Long> getIdDebitosAgrupados() {
        this.idDebitosAgrupados.add(this.idDebito);
        return this.idDebitosAgrupados;
    }

    protected String geraChaveAgrupamento() {
        if (Objects.nonNull(this.idParcelamento) && (this.getParcelado().booleanValue() || this.getReparcelado().booleanValue())) {
            return this.idParcelamento + "_" + this.parcela;
        }
        return this.getIdDebito() + "-" + this.getParcela();
    }

    @Generated
    public CalculaAcrescimoBaseDTO() {
    }

    @Generated
    public Boolean getFiltroTodosCadastros() {
        return this.filtroTodosCadastros;
    }

    @Generated
    public Long getPessoa() {
        return this.pessoa;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public LocalDate getDataPrimeiraParcela() {
        return this.dataPrimeiraParcela;
    }

    @Generated
    public Integer getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public Long getFormaCorrecao() {
        return this.formaCorrecao;
    }

    @Generated
    public Boolean getParcelado() {
        return this.parcelado;
    }

    @Generated
    public Boolean getReparcelado() {
        return this.reparcelado;
    }

    @Generated
    public String getTributo() {
        return this.tributo;
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public Long getIdProtesto() {
        return this.idProtesto;
    }

    @Generated
    public Long getIdParcelamento() {
        return this.idParcelamento;
    }

    @Generated
    public Long getTipoSituacaoParcela() {
        return this.tipoSituacaoParcela;
    }

    @Generated
    public String getSituacaoDebitoDescricao() {
        return this.situacaoDebitoDescricao;
    }

    @Generated
    public BigDecimal getValorPrincipal() {
        return this.valorPrincipal;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorDescontoPrincipal() {
        return this.valorDescontoPrincipal;
    }

    @Generated
    public BigDecimal getValorDescontoJuros() {
        return this.valorDescontoJuros;
    }

    @Generated
    public BigDecimal getValorDescontoMulta() {
        return this.valorDescontoMulta;
    }

    @Generated
    public BigDecimal getValorDescontoCorrecao() {
        return this.valorDescontoCorrecao;
    }

    @Generated
    public BigDecimal getValorOriginalDebito() {
        return this.valorOriginalDebito;
    }

    @Generated
    public void setFiltroTodosCadastros(Boolean filtroTodosCadastros) {
        this.filtroTodosCadastros = filtroTodosCadastros;
    }

    @Generated
    public void setPessoa(Long pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setDataPrimeiraParcela(LocalDate dataPrimeiraParcela) {
        this.dataPrimeiraParcela = dataPrimeiraParcela;
    }

    @Generated
    public void setSituacaoLegal(Integer situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setFormaCorrecao(Long formaCorrecao) {
        this.formaCorrecao = formaCorrecao;
    }

    @Generated
    public void setParcelado(Boolean parcelado) {
        this.parcelado = parcelado;
    }

    @Generated
    public void setReparcelado(Boolean reparcelado) {
        this.reparcelado = reparcelado;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setIdProtesto(Long idProtesto) {
        this.idProtesto = idProtesto;
    }

    @Generated
    public void setIdParcelamento(Long idParcelamento) {
        this.idParcelamento = idParcelamento;
    }

    @Generated
    public void setTipoSituacaoParcela(Long tipoSituacaoParcela) {
        this.tipoSituacaoParcela = tipoSituacaoParcela;
    }

    @Generated
    public void setSituacaoDebitoDescricao(String situacaoDebitoDescricao) {
        this.situacaoDebitoDescricao = situacaoDebitoDescricao;
    }

    @Generated
    public void setValorPrincipal(BigDecimal valorPrincipal) {
        this.valorPrincipal = valorPrincipal;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorDescontoPrincipal(BigDecimal valorDescontoPrincipal) {
        this.valorDescontoPrincipal = valorDescontoPrincipal;
    }

    @Generated
    public void setValorDescontoJuros(BigDecimal valorDescontoJuros) {
        this.valorDescontoJuros = valorDescontoJuros;
    }

    @Generated
    public void setValorDescontoMulta(BigDecimal valorDescontoMulta) {
        this.valorDescontoMulta = valorDescontoMulta;
    }

    @Generated
    public void setValorDescontoCorrecao(BigDecimal valorDescontoCorrecao) {
        this.valorDescontoCorrecao = valorDescontoCorrecao;
    }

    @Generated
    public void setValorOriginalDebito(BigDecimal valorOriginalDebito) {
        this.valorOriginalDebito = valorOriginalDebito;
    }

    @Generated
    public void setIdDebitosAgrupados(Set<Long> idDebitosAgrupados) {
        this.idDebitosAgrupados = idDebitosAgrupados;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculaAcrescimoBaseDTO)) {
            return false;
        }
        CalculaAcrescimoBaseDTO other = (CalculaAcrescimoBaseDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$filtroTodosCadastros = this.getFiltroTodosCadastros();
        Boolean other$filtroTodosCadastros = other.getFiltroTodosCadastros();
        if (this$filtroTodosCadastros == null ? other$filtroTodosCadastros != null : !((Object)this$filtroTodosCadastros).equals(other$filtroTodosCadastros)) {
            return false;
        }
        Long this$pessoa = this.getPessoa();
        Long other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !((Object)this$pessoa).equals(other$pessoa)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Integer this$situacaoLegal = this.getSituacaoLegal();
        Integer other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !((Object)this$situacaoLegal).equals(other$situacaoLegal)) {
            return false;
        }
        Long this$formaCorrecao = this.getFormaCorrecao();
        Long other$formaCorrecao = other.getFormaCorrecao();
        if (this$formaCorrecao == null ? other$formaCorrecao != null : !((Object)this$formaCorrecao).equals(other$formaCorrecao)) {
            return false;
        }
        Boolean this$parcelado = this.getParcelado();
        Boolean other$parcelado = other.getParcelado();
        if (this$parcelado == null ? other$parcelado != null : !((Object)this$parcelado).equals(other$parcelado)) {
            return false;
        }
        Boolean this$reparcelado = this.getReparcelado();
        Boolean other$reparcelado = other.getReparcelado();
        if (this$reparcelado == null ? other$reparcelado != null : !((Object)this$reparcelado).equals(other$reparcelado)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Long this$idProtesto = this.getIdProtesto();
        Long other$idProtesto = other.getIdProtesto();
        if (this$idProtesto == null ? other$idProtesto != null : !((Object)this$idProtesto).equals(other$idProtesto)) {
            return false;
        }
        Long this$idParcelamento = this.getIdParcelamento();
        Long other$idParcelamento = other.getIdParcelamento();
        if (this$idParcelamento == null ? other$idParcelamento != null : !((Object)this$idParcelamento).equals(other$idParcelamento)) {
            return false;
        }
        Long this$tipoSituacaoParcela = this.getTipoSituacaoParcela();
        Long other$tipoSituacaoParcela = other.getTipoSituacaoParcela();
        if (this$tipoSituacaoParcela == null ? other$tipoSituacaoParcela != null : !((Object)this$tipoSituacaoParcela).equals(other$tipoSituacaoParcela)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        if (this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento)) {
            return false;
        }
        LocalDate this$dataPrimeiraParcela = this.getDataPrimeiraParcela();
        LocalDate other$dataPrimeiraParcela = other.getDataPrimeiraParcela();
        if (this$dataPrimeiraParcela == null ? other$dataPrimeiraParcela != null : !((Object)this$dataPrimeiraParcela).equals(other$dataPrimeiraParcela)) {
            return false;
        }
        String this$tributo = this.getTributo();
        String other$tributo = other.getTributo();
        if (this$tributo == null ? other$tributo != null : !this$tributo.equals(other$tributo)) {
            return false;
        }
        String this$situacaoDebitoDescricao = this.getSituacaoDebitoDescricao();
        String other$situacaoDebitoDescricao = other.getSituacaoDebitoDescricao();
        if (this$situacaoDebitoDescricao == null ? other$situacaoDebitoDescricao != null : !this$situacaoDebitoDescricao.equals(other$situacaoDebitoDescricao)) {
            return false;
        }
        BigDecimal this$valorPrincipal = this.getValorPrincipal();
        BigDecimal other$valorPrincipal = other.getValorPrincipal();
        if (this$valorPrincipal == null ? other$valorPrincipal != null : !((Object)this$valorPrincipal).equals(other$valorPrincipal)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        BigDecimal this$valorDescontoPrincipal = this.getValorDescontoPrincipal();
        BigDecimal other$valorDescontoPrincipal = other.getValorDescontoPrincipal();
        if (this$valorDescontoPrincipal == null ? other$valorDescontoPrincipal != null : !((Object)this$valorDescontoPrincipal).equals(other$valorDescontoPrincipal)) {
            return false;
        }
        BigDecimal this$valorDescontoJuros = this.getValorDescontoJuros();
        BigDecimal other$valorDescontoJuros = other.getValorDescontoJuros();
        if (this$valorDescontoJuros == null ? other$valorDescontoJuros != null : !((Object)this$valorDescontoJuros).equals(other$valorDescontoJuros)) {
            return false;
        }
        BigDecimal this$valorDescontoMulta = this.getValorDescontoMulta();
        BigDecimal other$valorDescontoMulta = other.getValorDescontoMulta();
        if (this$valorDescontoMulta == null ? other$valorDescontoMulta != null : !((Object)this$valorDescontoMulta).equals(other$valorDescontoMulta)) {
            return false;
        }
        BigDecimal this$valorDescontoCorrecao = this.getValorDescontoCorrecao();
        BigDecimal other$valorDescontoCorrecao = other.getValorDescontoCorrecao();
        if (this$valorDescontoCorrecao == null ? other$valorDescontoCorrecao != null : !((Object)this$valorDescontoCorrecao).equals(other$valorDescontoCorrecao)) {
            return false;
        }
        BigDecimal this$valorOriginalDebito = this.getValorOriginalDebito();
        BigDecimal other$valorOriginalDebito = other.getValorOriginalDebito();
        if (this$valorOriginalDebito == null ? other$valorOriginalDebito != null : !((Object)this$valorOriginalDebito).equals(other$valorOriginalDebito)) {
            return false;
        }
        Set this$idDebitosAgrupados = this.getIdDebitosAgrupados();
        Set other$idDebitosAgrupados = other.getIdDebitosAgrupados();
        return !(this$idDebitosAgrupados == null ? other$idDebitosAgrupados != null : !((Object)this$idDebitosAgrupados).equals(other$idDebitosAgrupados));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculaAcrescimoBaseDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $filtroTodosCadastros = this.getFiltroTodosCadastros();
        result = result * 59 + ($filtroTodosCadastros == null ? 43 : ((Object)$filtroTodosCadastros).hashCode());
        Long $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : ((Object)$pessoa).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Integer $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : ((Object)$situacaoLegal).hashCode());
        Long $formaCorrecao = this.getFormaCorrecao();
        result = result * 59 + ($formaCorrecao == null ? 43 : ((Object)$formaCorrecao).hashCode());
        Boolean $parcelado = this.getParcelado();
        result = result * 59 + ($parcelado == null ? 43 : ((Object)$parcelado).hashCode());
        Boolean $reparcelado = this.getReparcelado();
        result = result * 59 + ($reparcelado == null ? 43 : ((Object)$reparcelado).hashCode());
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Long $idProtesto = this.getIdProtesto();
        result = result * 59 + ($idProtesto == null ? 43 : ((Object)$idProtesto).hashCode());
        Long $idParcelamento = this.getIdParcelamento();
        result = result * 59 + ($idParcelamento == null ? 43 : ((Object)$idParcelamento).hashCode());
        Long $tipoSituacaoParcela = this.getTipoSituacaoParcela();
        result = result * 59 + ($tipoSituacaoParcela == null ? 43 : ((Object)$tipoSituacaoParcela).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        LocalDate $dataPrimeiraParcela = this.getDataPrimeiraParcela();
        result = result * 59 + ($dataPrimeiraParcela == null ? 43 : ((Object)$dataPrimeiraParcela).hashCode());
        String $tributo = this.getTributo();
        result = result * 59 + ($tributo == null ? 43 : $tributo.hashCode());
        String $situacaoDebitoDescricao = this.getSituacaoDebitoDescricao();
        result = result * 59 + ($situacaoDebitoDescricao == null ? 43 : $situacaoDebitoDescricao.hashCode());
        BigDecimal $valorPrincipal = this.getValorPrincipal();
        result = result * 59 + ($valorPrincipal == null ? 43 : ((Object)$valorPrincipal).hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        BigDecimal $valorDescontoPrincipal = this.getValorDescontoPrincipal();
        result = result * 59 + ($valorDescontoPrincipal == null ? 43 : ((Object)$valorDescontoPrincipal).hashCode());
        BigDecimal $valorDescontoJuros = this.getValorDescontoJuros();
        result = result * 59 + ($valorDescontoJuros == null ? 43 : ((Object)$valorDescontoJuros).hashCode());
        BigDecimal $valorDescontoMulta = this.getValorDescontoMulta();
        result = result * 59 + ($valorDescontoMulta == null ? 43 : ((Object)$valorDescontoMulta).hashCode());
        BigDecimal $valorDescontoCorrecao = this.getValorDescontoCorrecao();
        result = result * 59 + ($valorDescontoCorrecao == null ? 43 : ((Object)$valorDescontoCorrecao).hashCode());
        BigDecimal $valorOriginalDebito = this.getValorOriginalDebito();
        result = result * 59 + ($valorOriginalDebito == null ? 43 : ((Object)$valorOriginalDebito).hashCode());
        Set $idDebitosAgrupados = this.getIdDebitosAgrupados();
        result = result * 59 + ($idDebitosAgrupados == null ? 43 : ((Object)$idDebitosAgrupados).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculaAcrescimoBaseDTO(filtroTodosCadastros=" + this.getFiltroTodosCadastros() + ", pessoa=" + this.getPessoa() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", dataVencimento=" + this.getDataVencimento() + ", dataLancamento=" + this.getDataLancamento() + ", dataPrimeiraParcela=" + this.getDataPrimeiraParcela() + ", situacaoLegal=" + this.getSituacaoLegal() + ", formaCorrecao=" + this.getFormaCorrecao() + ", parcelado=" + this.getParcelado() + ", reparcelado=" + this.getReparcelado() + ", tributo=" + this.getTributo() + ", idDebito=" + this.getIdDebito() + ", idProtesto=" + this.getIdProtesto() + ", idParcelamento=" + this.getIdParcelamento() + ", tipoSituacaoParcela=" + this.getTipoSituacaoParcela() + ", situacaoDebitoDescricao=" + this.getSituacaoDebitoDescricao() + ", valorPrincipal=" + this.getValorPrincipal() + ", valorJuros=" + this.getValorJuros() + ", valorMulta=" + this.getValorMulta() + ", valorCorrecao=" + this.getValorCorrecao() + ", valorDescontoPrincipal=" + this.getValorDescontoPrincipal() + ", valorDescontoJuros=" + this.getValorDescontoJuros() + ", valorDescontoMulta=" + this.getValorDescontoMulta() + ", valorDescontoCorrecao=" + this.getValorDescontoCorrecao() + ", valorOriginalDebito=" + this.getValorOriginalDebito() + ", idDebitosAgrupados=" + this.getIdDebitosAgrupados() + ")";
    }
}

