/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.tipomensagem;

import br.com.elotech.core.enumerable.EnumConverter;
import br.com.elotech.core.enumerable.EnumValues;
import br.com.elotech.core.utils.EnumUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum ClassificacaoTipoMensagem implements EnumConverter<ClassificacaoTipoMensagem, String>
{
    IMPORTADO("I", "Importado"),
    VERIFICADO("V", "Verificado"),
    PAGO("P", "Pago"),
    DESCONTO_CONCEDIDO("D", "Desconto Concedido"),
    CREDITO_CONTRIBUINTE("C", "Lan\u00e7ado Cr\u00e9dito ao Contribuinte"),
    CREDITO_CONCEDIDO("X", "Cr\u00e9dito Concedido"),
    PAGO_DUPLICIDADE("A", "Pago em Duplicidade"),
    ERRO("E", "Erro"),
    OCORRENCIA("O", "Ocorr\u00eancia");

    public static final EnumValues<ClassificacaoTipoMensagem, String> ENUM_VALUES;
    private final String codigo;
    private final String descricao;

    private ClassificacaoTipoMensagem(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    @JsonCreator
    public static ClassificacaoTipoMensagem fromValue(String codigo) {
        return (ClassificacaoTipoMensagem)ENUM_VALUES.getEnum((Object)codigo);
    }

    public String getValue() {
        return this.codigo;
    }

    @JsonValue
    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public Boolean permiteBaixa() {
        return Arrays.asList(VERIFICADO, DESCONTO_CONCEDIDO, PAGO_DUPLICIDADE, CREDITO_CONCEDIDO).contains(this);
    }

    public Boolean permiteVerificacao() {
        return !this.equals((Object)PAGO) && !this.equals((Object)OCORRENCIA);
    }

    static {
        ENUM_VALUES = EnumUtils.getEnumValuesMap(ClassificacaoTipoMensagem.class);
    }
}

