/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.sanepar;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.sanepar.BaixaSaneparItem;
import br.com.elotech.tributos.enums.sanepar.SituacaoBaixaSanepar;
import br.com.elotech.tributos.enums.sanepar.TipoBaixaSanepar;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="tribbaixamanualsanepar")
public class BaixaSanepar
implements EloEntity<Long> {
    @Id
    @Column(name="idbaixa")
    @EloSequence(sequenceName="s05BaixaManualSanepar")
    private Long id;
    private TipoBaixaSanepar tipo;
    @Enumerated(value=EnumType.STRING)
    private SituacaoBaixaSanepar situacao;
    private String usuario;
    private LocalDate dataInclusao;
    @OneToOne
    @JoinColumns(value={@JoinColumn(name="entidade"), @JoinColumn(name="exercicio"), @JoinColumn(name="lote")})
    private PagamentoLote lote;
    private LocalDate dataLancamento;
    @OneToMany(mappedBy="baixa", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BaixaSaneparItem> itens = new ArrayList();
    private String hash;
    private String nomeArquivo;
    private Long idArquivo;

    public void podeGerarDebitosEBoletos() {
        if (!SituacaoBaixaSanepar.IMPORTADO.equals((Object)this.getSituacao())) {
            throw new EloValidationException(String.format("Lote %s da Sanepar n\u00e3o est\u00e1 importado corretamente. Verifique!", this.getId()));
        }
    }

    @Generated
    public BaixaSanepar() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TipoBaixaSanepar getTipo() {
        return this.tipo;
    }

    @Generated
    public SituacaoBaixaSanepar getSituacao() {
        return this.situacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public PagamentoLote getLote() {
        return this.lote;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public List<BaixaSaneparItem> getItens() {
        return this.itens;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    @Generated
    public Long getIdArquivo() {
        return this.idArquivo;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipo(TipoBaixaSanepar tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setSituacao(SituacaoBaixaSanepar situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setLote(PagamentoLote lote) {
        this.lote = lote;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setItens(List<BaixaSaneparItem> itens) {
        this.itens = itens;
    }

    @Generated
    public void setHash(String hash) {
        this.hash = hash;
    }

    @Generated
    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    @Generated
    public void setIdArquivo(Long idArquivo) {
        this.idArquivo = idArquivo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaixaSanepar)) {
            return false;
        }
        BaixaSanepar other = (BaixaSanepar)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaixaSanepar;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BaixaSanepar(id=" + this.getId() + ")";
    }
}

