/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.projeto;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.converter.projeto.SituacaoAprovacaoTaxaConverter;
import br.com.elotech.tributos.converter.projeto.TipoVinculoProjetoConverter;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.Isencao;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.projeto.ProjetoDebito;
import br.com.elotech.tributos.domain.projeto.ProjetoItem;
import br.com.elotech.tributos.domain.projeto.ProjetoObservacao;
import br.com.elotech.tributos.domain.projeto.ProjetoPK;
import br.com.elotech.tributos.domain.projeto.ProjetoResponsavel;
import br.com.elotech.tributos.domain.projeto.ProjetoResponsavelPK;
import br.com.elotech.tributos.domain.projeto.SituacaoAprovacaoTaxa;
import br.com.elotech.tributos.domain.projeto.SituacaoProjeto;
import br.com.elotech.tributos.domain.projeto.TipoObra;
import br.com.elotech.tributos.domain.projeto.TipoProjeto;
import br.com.elotech.tributos.domain.projeto.TipoVinculoProjeto;
import br.com.elotech.tributos.enums.OpcaoPagamento;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tribprojeto")
public class Projeto
implements EloEntity<ProjetoPK> {
    @EmbeddedId
    private ProjetoPK id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="tipocadastro", referencedColumnName="tipocadastro"), @JoinColumn(name="cadastrogeral", referencedColumnName="cadastrogeral")})
    private CadastroGeral cadastroGeral;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="tipoprojeto")
    private TipoProjeto tipoProjeto;
    @Column(name="exercicioprotocolo")
    private Long exercicioProtocolo;
    @Column(name="idprocesso")
    private Long idProcesso;
    @Column(name="tipoprocesso")
    private Long tipoProcesso;
    @Column(name="exercicioprotocoloisencao")
    private Long exercicioProtocoloIsencao;
    @Column(name="idprocessoisencao")
    private Long idProcessoIsencao;
    @Column(name="tipoprocessoisencao")
    private Long tipoProcessoIsencao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pessoaresponsavel", referencedColumnName="pessoa")
    private Pessoa responsavel;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pessoa", referencedColumnName="pessoa")
    private Pessoa pessoa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="isencao", referencedColumnName="isencao")
    private Isencao isencao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="exercicioprojetosubstituido", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="projetosubstituido", referencedColumnName="projeto"))})
    private Projeto projetoSubstituido;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="situacao", referencedColumnName="situacaoprojeto")
    private SituacaoProjeto situacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="tipoobra", referencedColumnName="idtipoobra")
    private TipoObra tipoObra;
    @JsonIgnoreProperties(value={"projeto"})
    @OneToMany(mappedBy="projeto", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProjetoItem> itens = new ArrayList();
    @JsonIgnoreProperties(value={"projeto"})
    @OneToMany(mappedBy="projeto", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProjetoResponsavel> responsaveis = new ArrayList();
    @JsonIgnoreProperties(value={"projeto"})
    @OneToMany(mappedBy="projeto", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProjetoObservacao> observacoes = new ArrayList();
    @JsonIgnoreProperties(value={"projeto"})
    @OneToMany(mappedBy="projeto", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProjetoDebito> debitos = new ArrayList();
    @Convert(converter=TipoVinculoProjetoConverter.class)
    private TipoVinculoProjeto tipoVinculo;
    private String art;
    private String rrt;
    private BigDecimal area;
    private String nomeObra;
    private OpcaoPagamento opcaoPagamento;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean integraIss = false;
    @Convert(converter=SituacaoAprovacaoTaxaConverter.class)
    private SituacaoAprovacaoTaxa aprovacaoIsencaoRemissaoTaxa;
    @Convert(converter=SituacaoAprovacaoTaxaConverter.class)
    private SituacaoAprovacaoTaxa aprovacaoIsencaoRemissaoAlvara;
    @Convert(converter=SituacaoAprovacaoTaxaConverter.class)
    private SituacaoAprovacaoTaxa aprovacaoIsencaoRemissaoIss;
    @Convert(converter=SituacaoAprovacaoTaxaConverter.class)
    private SituacaoAprovacaoTaxa aprovacaoIsencaoRemissaoHabite;
    @Transient
    private Long numeroProjeto;
    @Transient
    private Long exercicioProjeto;
    @Length(max=100)
    private @Length(max=100) String complemento;
    @Length(max=20, message="Tamanho m\u00e1ximo do Processo SEI \u00e9 de 20")
    private @Length(max=20, message="Tamanho m\u00e1ximo do Processo SEI \u00e9 de 20") String processoSei;
    @Length(max=50)
    private @Length(max=50) String codigoPrancha;
    @Length(max=10)
    private @Length(max=10) String codigoPgd;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean contabilizacaoObra = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean imunidade = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean prodem = Boolean.FALSE;

    @JsonIgnore
    public BigDecimal getValorTotalDebitos() {
        return this.debitos.stream().map(ProjetoDebito::getDebito).map(Debito::getValorTotalDebito).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @JsonIgnore
    public Long getNextSequenciaResponsavel() {
        return this.responsaveis.stream().filter(r -> Objects.nonNull(r.getId()) && Objects.nonNull(r.getId().getSequencia())).map(ProjetoResponsavel::getId).map(ProjetoResponsavelPK::getSequencia).max(Long::compare).map(max -> max + 1L).orElse(1L);
    }

    @Generated
    public Projeto() {
    }

    @Generated
    public ProjetoPK getId() {
        return this.id;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public TipoProjeto getTipoProjeto() {
        return this.tipoProjeto;
    }

    @Generated
    public Long getExercicioProtocolo() {
        return this.exercicioProtocolo;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public Long getTipoProcesso() {
        return this.tipoProcesso;
    }

    @Generated
    public Long getExercicioProtocoloIsencao() {
        return this.exercicioProtocoloIsencao;
    }

    @Generated
    public Long getIdProcessoIsencao() {
        return this.idProcessoIsencao;
    }

    @Generated
    public Long getTipoProcessoIsencao() {
        return this.tipoProcessoIsencao;
    }

    @Generated
    public Pessoa getResponsavel() {
        return this.responsavel;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public Isencao getIsencao() {
        return this.isencao;
    }

    @Generated
    public Projeto getProjetoSubstituido() {
        return this.projetoSubstituido;
    }

    @Generated
    public SituacaoProjeto getSituacao() {
        return this.situacao;
    }

    @Generated
    public TipoObra getTipoObra() {
        return this.tipoObra;
    }

    @Generated
    public List<ProjetoItem> getItens() {
        return this.itens;
    }

    @Generated
    public List<ProjetoResponsavel> getResponsaveis() {
        return this.responsaveis;
    }

    @Generated
    public List<ProjetoObservacao> getObservacoes() {
        return this.observacoes;
    }

    @Generated
    public List<ProjetoDebito> getDebitos() {
        return this.debitos;
    }

    @Generated
    public TipoVinculoProjeto getTipoVinculo() {
        return this.tipoVinculo;
    }

    @Generated
    public String getArt() {
        return this.art;
    }

    @Generated
    public String getRrt() {
        return this.rrt;
    }

    @Generated
    public BigDecimal getArea() {
        return this.area;
    }

    @Generated
    public String getNomeObra() {
        return this.nomeObra;
    }

    @Generated
    public OpcaoPagamento getOpcaoPagamento() {
        return this.opcaoPagamento;
    }

    @Generated
    public Boolean getIntegraIss() {
        return this.integraIss;
    }

    @Generated
    public SituacaoAprovacaoTaxa getAprovacaoIsencaoRemissaoTaxa() {
        return this.aprovacaoIsencaoRemissaoTaxa;
    }

    @Generated
    public SituacaoAprovacaoTaxa getAprovacaoIsencaoRemissaoAlvara() {
        return this.aprovacaoIsencaoRemissaoAlvara;
    }

    @Generated
    public SituacaoAprovacaoTaxa getAprovacaoIsencaoRemissaoIss() {
        return this.aprovacaoIsencaoRemissaoIss;
    }

    @Generated
    public SituacaoAprovacaoTaxa getAprovacaoIsencaoRemissaoHabite() {
        return this.aprovacaoIsencaoRemissaoHabite;
    }

    @Generated
    public Long getNumeroProjeto() {
        return this.numeroProjeto;
    }

    @Generated
    public Long getExercicioProjeto() {
        return this.exercicioProjeto;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public String getProcessoSei() {
        return this.processoSei;
    }

    @Generated
    public String getCodigoPrancha() {
        return this.codigoPrancha;
    }

    @Generated
    public String getCodigoPgd() {
        return this.codigoPgd;
    }

    @Generated
    public Boolean getContabilizacaoObra() {
        return this.contabilizacaoObra;
    }

    @Generated
    public Boolean getImunidade() {
        return this.imunidade;
    }

    @Generated
    public Boolean getProdem() {
        return this.prodem;
    }

    @Generated
    public void setId(ProjetoPK id) {
        this.id = id;
    }

    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setTipoProjeto(TipoProjeto tipoProjeto) {
        this.tipoProjeto = tipoProjeto;
    }

    @Generated
    public void setExercicioProtocolo(Long exercicioProtocolo) {
        this.exercicioProtocolo = exercicioProtocolo;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setTipoProcesso(Long tipoProcesso) {
        this.tipoProcesso = tipoProcesso;
    }

    @Generated
    public void setExercicioProtocoloIsencao(Long exercicioProtocoloIsencao) {
        this.exercicioProtocoloIsencao = exercicioProtocoloIsencao;
    }

    @Generated
    public void setIdProcessoIsencao(Long idProcessoIsencao) {
        this.idProcessoIsencao = idProcessoIsencao;
    }

    @Generated
    public void setTipoProcessoIsencao(Long tipoProcessoIsencao) {
        this.tipoProcessoIsencao = tipoProcessoIsencao;
    }

    @Generated
    public void setResponsavel(Pessoa responsavel) {
        this.responsavel = responsavel;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setIsencao(Isencao isencao) {
        this.isencao = isencao;
    }

    @Generated
    public void setProjetoSubstituido(Projeto projetoSubstituido) {
        this.projetoSubstituido = projetoSubstituido;
    }

    @Generated
    public void setSituacao(SituacaoProjeto situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setTipoObra(TipoObra tipoObra) {
        this.tipoObra = tipoObra;
    }

    @JsonIgnoreProperties(value={"projeto"})
    @Generated
    public void setItens(List<ProjetoItem> itens) {
        this.itens = itens;
    }

    @JsonIgnoreProperties(value={"projeto"})
    @Generated
    public void setResponsaveis(List<ProjetoResponsavel> responsaveis) {
        this.responsaveis = responsaveis;
    }

    @JsonIgnoreProperties(value={"projeto"})
    @Generated
    public void setObservacoes(List<ProjetoObservacao> observacoes) {
        this.observacoes = observacoes;
    }

    @JsonIgnoreProperties(value={"projeto"})
    @Generated
    public void setDebitos(List<ProjetoDebito> debitos) {
        this.debitos = debitos;
    }

    @Generated
    public void setTipoVinculo(TipoVinculoProjeto tipoVinculo) {
        this.tipoVinculo = tipoVinculo;
    }

    @Generated
    public void setArt(String art) {
        this.art = art;
    }

    @Generated
    public void setRrt(String rrt) {
        this.rrt = rrt;
    }

    @Generated
    public void setArea(BigDecimal area) {
        this.area = area;
    }

    @Generated
    public void setNomeObra(String nomeObra) {
        this.nomeObra = nomeObra;
    }

    @Generated
    public void setOpcaoPagamento(OpcaoPagamento opcaoPagamento) {
        this.opcaoPagamento = opcaoPagamento;
    }

    @Generated
    public void setIntegraIss(Boolean integraIss) {
        this.integraIss = integraIss;
    }

    @Generated
    public void setAprovacaoIsencaoRemissaoTaxa(SituacaoAprovacaoTaxa aprovacaoIsencaoRemissaoTaxa) {
        this.aprovacaoIsencaoRemissaoTaxa = aprovacaoIsencaoRemissaoTaxa;
    }

    @Generated
    public void setAprovacaoIsencaoRemissaoAlvara(SituacaoAprovacaoTaxa aprovacaoIsencaoRemissaoAlvara) {
        this.aprovacaoIsencaoRemissaoAlvara = aprovacaoIsencaoRemissaoAlvara;
    }

    @Generated
    public void setAprovacaoIsencaoRemissaoIss(SituacaoAprovacaoTaxa aprovacaoIsencaoRemissaoIss) {
        this.aprovacaoIsencaoRemissaoIss = aprovacaoIsencaoRemissaoIss;
    }

    @Generated
    public void setAprovacaoIsencaoRemissaoHabite(SituacaoAprovacaoTaxa aprovacaoIsencaoRemissaoHabite) {
        this.aprovacaoIsencaoRemissaoHabite = aprovacaoIsencaoRemissaoHabite;
    }

    @Generated
    public void setNumeroProjeto(Long numeroProjeto) {
        this.numeroProjeto = numeroProjeto;
    }

    @Generated
    public void setExercicioProjeto(Long exercicioProjeto) {
        this.exercicioProjeto = exercicioProjeto;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setProcessoSei(String processoSei) {
        this.processoSei = processoSei;
    }

    @Generated
    public void setCodigoPrancha(String codigoPrancha) {
        this.codigoPrancha = codigoPrancha;
    }

    @Generated
    public void setCodigoPgd(String codigoPgd) {
        this.codigoPgd = codigoPgd;
    }

    @Generated
    public void setContabilizacaoObra(Boolean contabilizacaoObra) {
        this.contabilizacaoObra = contabilizacaoObra;
    }

    @Generated
    public void setImunidade(Boolean imunidade) {
        this.imunidade = imunidade;
    }

    @Generated
    public void setProdem(Boolean prodem) {
        this.prodem = prodem;
    }

    @Generated
    public String toString() {
        return "Projeto(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Projeto)) {
            return false;
        }
        Projeto other = (Projeto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ProjetoPK this$id = this.getId();
        ProjetoPK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Projeto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProjetoPK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

