/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.tributos.domain.Debito;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.validation.constraints.NotNull;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@Embeddable
public class DebitoObservacaoId
implements Serializable {
    @NotNull(message="Entidade \u00e9 obrigat\u00f3rio na Observa\u00e7\u00e3o")
    private @NotNull(message="Entidade \u00e9 obrigat\u00f3rio na Observa\u00e7\u00e3o") Long entidade;
    @NotNull(message="Exerc\u00edcio vigente \u00e9 obrigat\u00f3rio na Observa\u00e7\u00e3o")
    private @NotNull(message="Exerc\u00edcio vigente \u00e9 obrigat\u00f3rio na Observa\u00e7\u00e3o") Long exercicio;
    @NotNull(message="Tipo Cadastro \u00e9 obrigat\u00f3rio para a Observa\u00e7\u00e3o")
    private @NotNull(message="Tipo Cadastro \u00e9 obrigat\u00f3rio para a Observa\u00e7\u00e3o") Long tipoCadastro;
    @NotNull(message="Cadastro Geral \u00e9 obrigat\u00f3rio para a Observa\u00e7\u00e3o")
    private @NotNull(message="Cadastro Geral \u00e9 obrigat\u00f3rio para a Observa\u00e7\u00e3o") Long cadastroGeral;
    @NotNull(message="D\u00edvida \u00e9 obrigat\u00f3rio para a Observa\u00e7\u00e3o")
    @Column(name="guiarecolhimento")
    private @NotNull(message="D\u00edvida \u00e9 obrigat\u00f3rio para a Observa\u00e7\u00e3o") Long divida;
    @NotNull(message="Subdivida \u00e9 obrigat\u00f3rio para a Observa\u00e7\u00e3o")
    private @NotNull(message="Subdivida \u00e9 obrigat\u00f3rio para a Observa\u00e7\u00e3o") Long subDivida;
    @NotNull(message="Sequ\u00eancia \u00e9 obrigat\u00f3ria para a Observa\u00e7\u00e3o")
    private @NotNull(message="Sequ\u00eancia \u00e9 obrigat\u00f3ria para a Observa\u00e7\u00e3o") Long sequencia;

    public static DebitoObservacaoId of(Debito debito) {
        return DebitoObservacaoId.of((Long)debito.getEntidade(), (Long)debito.getExercicio(), (Long)debito.getTipoCadastro(), (Long)debito.getCadastroGeralId(), (Long)debito.getDivida().getDivida(), (Long)debito.getSubDivida(), (Long)debito.getNextSequenciaObservacao());
    }

    public static DebitoObservacaoId of(Long idEntidade, Long exercicio, Long tipoCadastro, Long cadastroGeral, Long divida, Long subDivida, Long sequencia) {
        DebitoObservacaoId id = new DebitoObservacaoId();
        id.setEntidade(idEntidade);
        id.setExercicio(exercicio);
        id.setTipoCadastro(tipoCadastro);
        id.setCadastroGeral(cadastroGeral);
        id.setDivida(divida);
        id.setSubDivida(subDivida);
        id.setSequencia(sequencia);
        return id;
    }

    @JsonIgnore
    public Long getNextSequencia() {
        return Optional.ofNullable(this.sequencia).stream().reduce(0L, Long::max) + 1L;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoObservacaoId)) {
            return false;
        }
        DebitoObservacaoId other = (DebitoObservacaoId)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        return !(this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoObservacaoId;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        return result;
    }
}

