/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.relatoriogerencialarrecadacao.lancamentoarrecadacaoiss;

import br.com.elotech.tributos.domain.relatoriogerencialarrecadacao.ArrecadacaoAnualMesDivida;
import br.com.elotech.tributos.repository.relatoriogerencial.LancamentoArrecadacaoIssRepository;
import java.util.List;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class LancamentoArrecadacaoIssBatchWriter
implements ItemWriter<ArrecadacaoAnualMesDivida> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LancamentoArrecadacaoIssBatchWriter.class);
    private final EntityManager entityManager;
    private final LancamentoArrecadacaoIssRepository lancamentoArrecadacaoIssRepository;
    private StepExecution stepExecution;

    public LancamentoArrecadacaoIssBatchWriter(EntityManager entityManager, LancamentoArrecadacaoIssRepository lancamentoArrecadacaoIssRepository) {
        this.entityManager = entityManager;
        this.lancamentoArrecadacaoIssRepository = lancamentoArrecadacaoIssRepository;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends ArrecadacaoAnualMesDivida> items) throws Exception {
        this.lancamentoArrecadacaoIssRepository.saveAll(items);
        this.entityManager.flush();
    }

    @AfterWrite
    public void afterWrite(List<? extends ArrecadacaoAnualMesDivida> items) {
        Long exercicio = this.stepExecution.getJobExecution().getJobParameters().getLong("exercicio");
        Long mes = this.stepExecution.getJobExecution().getJobParameters().getLong("mes");
        int quantidadeProcessada = this.stepExecution.getReadCount() + items.size();
        log.info("Finalizado chunk do Lan\u00e7amento x Arrecada\u00e7\u00e3o de ISS referente ao per\u00edodo {}/{}. Itens verificados at\u00e9 o momento {}", new Object[]{mes, exercicio, quantidadeProcessada});
    }
}

