/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.relatoriogerencialarrecadacao.acompanhamentoperiodo;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.relatoriogerencial.AnaliseArrecadacaoDTO;
import br.com.elotech.tributos.service.ContextService;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class AcompanhamentoPeriodoReader
extends JdbcCursorItemReader<AnaliseArrecadacaoDTO> {
    public AcompanhamentoPeriodoReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource, ContextService contextService) {
        int entidade = contextService.getEntidadePrincipal().intValue();
        Long exercicio = (Long)jobParameters.get("exercicio");
        Long mes = (Long)jobParameters.get("mes");
        Long dia = (Long)jobParameters.get("dia");
        LocalDate dataInicial = LocalDate.of(exercicio.intValue(), mes.intValue(), 1);
        LocalDate dataFinal = dia == 0L ? dataInicial.with(TemporalAdjusters.lastDayOfMonth()) : LocalDate.of(exercicio.intValue(), mes.intValue(), dia.intValue());
        String sql = FileUtils.readResourceAsString((String)"sql/batch/relatoriogerencial/acompanhamentoperiodo.sql").replace(":entidade", String.valueOf(entidade)).replace(":dataInicial", String.valueOf(dataInicial)).replace(":dataFinal", String.valueOf(dataFinal));
        this.setFetchSize(500);
        this.setName("acompanhamentoPeriodo");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(AnaliseArrecadacaoDTO.class));
        this.setSql(sql);
    }
}

