/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.protesto.importacaoretornoremessa;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class ImportacaoRetornoRemessaJobListener
extends JobExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoRetornoRemessaJobListener.class);
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;
    private static final Map<NotificationStatus, String> notificationMessage = Map.of(NotificationStatus.STARTED, "Iniciando processamento de importa\u00e7\u00e3o do arquivo de retorno do protesto remessa %s", NotificationStatus.COMPLETED, "Finalizado processamento de importa\u00e7\u00e3o do arquivo de retorno do protesto remessa %s", NotificationStatus.FAILED, "Erro no processamento de importa\u00e7\u00e3o do arquivo de retorno do protesto remessa %s");

    public void beforeJob(@Nullable JobExecution jobExecution) {
        if (Objects.isNull(jobExecution)) {
            return;
        }
        super.beforeJob(jobExecution);
        Long idProtestoRemessa = jobExecution.getJobParameters().getLong("idProtestoRemessa");
        Optional notificacaoId = this.notificarInicio(idProtestoRemessa, jobExecution);
        notificacaoId.ifPresent(id -> jobExecution.getExecutionContext().put(ID_NOTIFICACAO, id));
    }

    public void afterJob(@Nullable JobExecution jobExecution) {
        if (Objects.isNull(jobExecution)) {
            return;
        }
        super.afterJob(jobExecution);
        Long idProtestoRemessa = jobExecution.getJobParameters().getLong("idProtestoRemessa");
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificarFinalSucesso(idProtestoRemessa, jobExecution);
        } else {
            this.notificarFinalErro(idProtestoRemessa, jobExecution);
        }
    }

    private Optional<UUID> notificarInicio(Long idProtestoRemessa, JobExecution jobExecution) {
        return this.notificar(idProtestoRemessa, jobExecution, NotificationStatus.STARTED);
    }

    private void notificarFinalSucesso(Long idProtestoRemessa, JobExecution jobExecution) {
        this.notificar(idProtestoRemessa, jobExecution, NotificationStatus.COMPLETED);
    }

    private void notificarFinalErro(Long idProtestoRemessa, JobExecution jobExecution) {
        this.notificar(idProtestoRemessa, jobExecution, NotificationStatus.FAILED);
    }

    private Optional<UUID> notificar(Long idProtestoRemessa, JobExecution jobExecution, NotificationStatus status) {
        String message = String.format((String)notificationMessage.get(status), idProtestoRemessa);
        Optional<UUID> notificacaoId = Optional.ofNullable(jobExecution.getExecutionContext().get(ID_NOTIFICACAO)).map(id -> UUID.fromString(String.valueOf(id)));
        return this.notificacaoService.send("Importa\u00e7\u00e3o do arquivo do protesto remessa", message, jobExecution, notificacaoId, status);
    }

    @Generated
    public ImportacaoRetornoRemessaJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

