/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.contenciosorecalculo;

import br.com.elotech.tributos.domain.ContenciosoDebito;
import br.com.elotech.tributos.repository.ContenciosoDebitoRepository;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class ContenciosoRecalculoWriter
implements ItemWriter<ContenciosoDebito> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContenciosoRecalculoWriter.class);
    private final EntityManager entityManager;
    private final ContenciosoDebitoRepository contenciosoDebitoRepository;
    private StepExecution stepExecution;

    public ContenciosoRecalculoWriter(EntityManager entityManager, ContenciosoDebitoRepository contenciosoDebitoRepository) {
        this.entityManager = entityManager;
        this.contenciosoDebitoRepository = contenciosoDebitoRepository;
    }

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends ContenciosoDebito> items) {
        LOGGER.info("Salvando os rec\u00e1lculos do contencioso. Read count {}. Job Id {}.", (Object)this.stepExecution.getReadCount(), (Object)this.stepExecution.getJobExecution().getId());
        List debitos = items.stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.contenciosoDebitoRepository.saveAll(debitos);
        this.entityManager.flush();
    }
}

