/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cda.simulacao;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.documento.cda.LoteCda;
import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaRepository;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class SimulacaoLoteCdaJobListener
extends JobExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimulacaoLoteCdaJobListener.class);
    private static final String DATA = "data";
    private static final String ID_LOTE = "idLote";
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;
    private final LoteCdaRepository loteCdaRepository;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idLote = jobExecution.getJobParameters().getLong(ID_LOTE);
        LoteCda lote = (LoteCda)this.loteCdaRepository.findOne((Object)idLote);
        lote.setBatchJobExecutionSimulacao(BatchJobExecution.of((JobExecution)jobExecution));
        this.loteCdaRepository.save((Object)lote);
        LocalDate data = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA)));
        String title = "CDA - Inicianda a simula\u00e7\u00e3o do lote";
        String message = String.format("Iniciada a gera\u00e7\u00e3o de dados da simula\u00e7\u00e3o do lote de certid\u00e3o de d\u00edvida ativa - %s", data.toString());
        Optional notificacaoId = this.sendNotification(title, message, jobExecution, null, NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, (Object)notificacaoId.map(UUID::toString).orElse(""));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        String notificacaoIdString = jobExecution.getExecutionContext().getString(ID_NOTIFICACAO);
        UUID notificacaoId = StringUtils.isBlank((CharSequence)notificacaoIdString) ? null : UUID.fromString(notificacaoIdString);
        LocalDate data = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA)));
        this.onHavingFailedSteps(jobExecution);
        this.onCompleted(jobExecution, notificacaoId, data);
        this.onFailed(jobExecution, notificacaoId, data);
    }

    private void onHavingFailedSteps(JobExecution jobExecution) {
        jobExecution.getStepExecutions().stream().filter(stepExecution -> BatchStatus.FAILED.equals((Object)stepExecution.getStatus())).forEach(stepExecution -> {
            jobExecution.setStatus(stepExecution.getStatus());
            jobExecution.setExitStatus(stepExecution.getExitStatus());
            stepExecution.getFailureExceptions().forEach(arg_0 -> ((JobExecution)jobExecution).addFailureException(arg_0));
        });
    }

    private void onCompleted(JobExecution jobExecution, UUID notificacaoId, LocalDate data) {
        Long idLote = jobExecution.getJobParameters().getLong(ID_LOTE);
        LoteCda lote = (LoteCda)this.loteCdaRepository.findOne((Object)idLote);
        lote.setSituacao(SituacaoLoteCda.SIMULACAO_GERADA);
        this.loteCdaRepository.save((Object)lote);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            String title = "CDA - Simula\u00e7\u00e3o do lote conclu\u00edda";
            String message = String.format("Conclu\u00edda a gera\u00e7\u00e3o de dados da simula\u00e7\u00e3o do lote de certid\u00e3o de d\u00edvida ativa - %s", data.toString());
            this.sendNotification(title, message, jobExecution, notificacaoId, NotificationStatus.COMPLETED);
        }
    }

    private void onFailed(JobExecution jobExecution, UUID notificacaoId, LocalDate data) {
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            Long idLote = jobExecution.getJobParameters().getLong(ID_LOTE);
            LoteCda lote = (LoteCda)this.loteCdaRepository.findOne((Object)idLote);
            lote.setSituacao(SituacaoLoteCda.ERRO_SIMULACAO);
            this.loteCdaRepository.save((Object)lote);
            String title = "CDA - Erro na simula\u00e7\u00e3o do lote";
            String message = String.format("N\u00e3o foi poss\u00edvel gerar os dados da simula\u00e7\u00e3o do lote de certid\u00e3o de d\u00edvida ativa - %s", data.toString());
            this.sendNotification(title, message, jobExecution, notificacaoId, NotificationStatus.FAILED);
        }
    }

    private Optional<UUID> sendNotification(String title, String message, JobExecution jobExecution, UUID notificationId, NotificationStatus status) {
        try {
            return this.notificacaoService.send(title, message, jobExecution, Optional.ofNullable(notificationId), status);
        }
        catch (Exception e) {
            log.error("N\u00e3o foi poss\u00edvel enviar a notifica\u00e7\u00e3o da simula\u00e7\u00e3o do lote de CDA para o status de {}", (Object)status);
            return Optional.empty();
        }
    }

    @Generated
    public SimulacaoLoteCdaJobListener(NotificacaoService notificacaoService, LoteCdaRepository loteCdaRepository) {
        this.notificacaoService = notificacaoService;
        this.loteCdaRepository = loteCdaRepository;
    }
}

