/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.batch.comunicadolivroda.ComunicadoLivroDABatchProcessor;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoCadastro;
import br.com.elotech.tributos.domain.ComunicadoCadastroId;
import br.com.elotech.tributos.domain.ComunicadoDebito;
import br.com.elotech.tributos.domain.ComunicadoDebitoId;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoFiltroNotificacaoComunicado;
import br.com.elotech.tributos.dto.ComunicadoConsultaReceitas;
import br.com.elotech.tributos.dto.ComunicadoDebitoConsultaDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTOFactory;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.SituacaoComunicadoCadastro;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.comunicado.ComunicadoCadastroService;
import br.com.elotech.tributos.service.comunicado.ComunicadoService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.item.ItemProcessor;

public abstract class ComunicadoGeracaoBatchProcessor
implements ItemProcessor<ComunicadoDebitoConsultaDTO, ComunicadoCadastro> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComunicadoLivroDABatchProcessor.class);
    protected static String LOG_PARAM = "COMUNICADO - A partir de Livro DA - ";
    protected StepExecution stepExecution;
    protected final ComunicadoCadastroService comunicadoCadastroService;
    protected final ComunicadoService comunicadoService;
    protected final GeraBoletoService geraBoletoService;
    protected final EntityManager em;
    private final ObjectMapper objectMapper;
    protected AtomicLong sequencia;
    protected TipoFiltroNotificacaoComunicado tipoFiltroNotificacaoComunicado;
    protected CalculoAcrescimoService calculoAcrescimoService;
    protected ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos;
    private ComunicadoId comunicadoId;

    protected ComunicadoGeracaoBatchProcessor(ComunicadoCadastroService comunicadoCadastroService, ComunicadoService comunicadoService, GeraBoletoService geraBoletoService, CalculoAcrescimoService calculoAcrescimoService, EntityManager em, ObjectMapper objectMapper) {
        this.comunicadoCadastroService = comunicadoCadastroService;
        this.comunicadoService = comunicadoService;
        this.geraBoletoService = geraBoletoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.em = em;
        this.objectMapper = objectMapper;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.loadContext(stepExecution);
        LOGGER.info(LOG_PARAM + "Iniciando gera\u00e7\u00e3o de dados");
    }

    public ComunicadoCadastro process(ComunicadoDebitoConsultaDTO comunicadoDebitoConsultaDTO) {
        Comunicado comunicado = new Comunicado();
        comunicado.setId(this.comunicadoId);
        ComunicadoCadastroId idComunicadoCadastro = new ComunicadoCadastroId();
        idComunicadoCadastro.setComunicado(comunicado);
        idComunicadoCadastro.setSequencia(Long.valueOf(this.sequencia.getAndIncrement()));
        ComunicadoCadastro comunicadoCadastro = new ComunicadoCadastro();
        comunicadoCadastro.setId(idComunicadoCadastro);
        comunicadoCadastro.setSituacao(SituacaoComunicadoCadastro.SITUACAO_DEBITO);
        comunicadoCadastro.setDescricaoSituacao(SituacaoComunicadoCadastro.SITUACAO_DEBITO.getDescricao());
        Pessoa pessoa = new Pessoa();
        pessoa.setId(comunicadoDebitoConsultaDTO.getCodigoPessoa());
        comunicadoCadastro.setPessoa(pessoa);
        CadastroGeral cadastroGeral = new CadastroGeral();
        cadastroGeral.setId(comunicadoDebitoConsultaDTO.getIdCadastro());
        cadastroGeral.setTipoCadastro(TipoCadastro.fromValue((Long)comunicadoDebitoConsultaDTO.getTipocadastro()));
        cadastroGeral.setCadastroGeral(comunicadoDebitoConsultaDTO.getCadastrogeral());
        comunicadoCadastro.setCadastroGeral(cadastroGeral);
        this.comunicadoCadastroService.save((EloEntity)comunicadoCadastro, null);
        this.em.flush();
        List receitas = this.findReceitas(comunicadoDebitoConsultaDTO);
        receitas.forEach(receita -> {
            ComunicadoDebitoId comunicadoDebitoId = new ComunicadoDebitoId();
            comunicadoDebitoId.setComunicadoCadastro(comunicadoCadastro);
            comunicadoDebitoId.setIdDebitoParcelaReceita(receita.getIdDebitoParcelaReceita());
            ComunicadoDebito comunicadoDebito = new ComunicadoDebito();
            comunicadoDebito.setId(comunicadoDebitoId);
            comunicadoDebito.setValorCorrecao(receita.getValorCorrecao());
            comunicadoDebito.setValorMulta(receita.getValorMulta());
            comunicadoDebito.setValorJuros(receita.getValorJuros());
            comunicadoDebito.setValorPrincipal(receita.getValor());
            comunicadoCadastro.getComunicadoDebitos().add(comunicadoDebito);
        });
        if (this.shouldGenerateBoleto(comunicadoCadastro)) {
            this.gerarBoletoParaComunicadoCadastroComAsReceitas(comunicadoCadastro, receitas);
        }
        return comunicadoCadastro;
    }

    @OnProcessError
    public void onProcessError(ComunicadoDebitoConsultaDTO item, Exception e) throws Exception {
        LOGGER.error(LOG_PARAM + "Erro: {}\n{})", (Object)e.getMessage(), (Object)this.objectMapper.writeValueAsString((Object)item));
    }

    private void gerarBoletoParaComunicadoCadastroComAsReceitas(ComunicadoCadastro comunicadoCadastro, List<ComunicadoConsultaReceitas> receitas) {
        try {
            comunicadoCadastro.setBoleto(this.geraBoleto(comunicadoCadastro, receitas));
            comunicadoCadastro.setSituacao(SituacaoComunicadoCadastro.PRONTO_PARA_IMPRESSAO);
            comunicadoCadastro.setDescricaoSituacao(SituacaoComunicadoCadastro.PRONTO_PARA_IMPRESSAO.getDescricao());
        }
        catch (Exception e) {
            comunicadoCadastro.setSituacao(SituacaoComunicadoCadastro.ERRO_BOLETO);
            comunicadoCadastro.setDescricaoSituacao(SituacaoComunicadoCadastro.ERRO_BOLETO.getDescricao());
            comunicadoCadastro.setMensagemErroBoleto(e.getMessage());
        }
    }

    private Bloqueto geraBoleto(ComunicadoCadastro comunicadoCadastro, List<ComunicadoConsultaReceitas> receitas) {
        List debitos = receitas.stream().map(receita -> DebitoParcelaDTO.from((Long)receita.getIdDebito(), (Long)receita.getParcela())).distinct().collect(Collectors.toList());
        GeraBoletoDTO dto = this.buildGeraBoletoDTO(comunicadoCadastro);
        dto.setDebitos(debitos);
        assert (this.parametrosAcrescimos != null);
        return this.geraBoletoService.geraBoleto(dto, this.parametrosAcrescimos).stream().findFirst().orElse(null);
    }

    protected GeraBoletoDTO buildGeraBoletoDTO(ComunicadoCadastro comunicadoCadastro) {
        return GeraBoletoDTOFactory.makeToComunicadoCadastro((ComunicadoCadastro)comunicadoCadastro);
    }

    protected boolean shouldGenerateBoleto(ComunicadoCadastro comunicadoCadastro) {
        return false;
    }

    protected void loadContext(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        Long entidade = this.stepExecution.getJobExecution().getJobParameters().getLong("entidade");
        Long exercicioComunicado = this.stepExecution.getJobExecution().getJobParameters().getLong("exercicioComunicado");
        Long idComunicadoParam = this.stepExecution.getJobExecution().getJobParameters().getLong("idComunicado");
        this.comunicadoId = ComunicadoId.of((Long)entidade, (Long)exercicioComunicado, (Long)idComunicadoParam);
        this.sequencia = this.comunicadoCadastroService.findNextSequencia(this.comunicadoId);
        this.tipoFiltroNotificacaoComunicado = this.comunicadoService.findTipoFiltroNotificacaoByComunicadoId(this.comunicadoId);
    }

    protected abstract List<ComunicadoConsultaReceitas> findReceitas(ComunicadoDebitoConsultaDTO var1);
}

