with nrsDuplicados as (select nrestorno, nranoestorno, count(1) as quantidade
						from tcearrecadacaotipocreditoest group by 1,2),
estornosDuplicados as (select nrestorno, nrarrecadacao, nranoarrecadacao, nrmes, nrano,  count(1) as quantidades
							from tcearrecadacaotipocreditoest group by 1,2,3,4,5)
select distinct estorno.idtcearrtipocreditoest,
       estorno.nrestorno,
       estorno.nranoestorno,
       estorno.nrarrecadacao,
       estorno.nranoarrecadacao,
       estorno.vlestorno,
       arrecadacao.nrarrecadacao as arrecadacaoNrArrecadacao,
       arrecadacao.nranoarrecadacao as arrecadacaoNrAnoArrecadacao,
       nrdup.quantidade as qtRegistros,
       estornoDup.quantidades as qtEstornos,
       coalesce(lag(estorno.nrestorno, 1) over (order by idtcearrtipocreditoest), 0) as nrEstornoAnterior
from tcearrecadacaotipocreditoest estorno
		left join tcearrecadacaotipocredito arrecadacao on arrecadacao.nrarrecadacao  = estorno.nrarrecadacao and arrecadacao.nranoarrecadacao = estorno.nranoarrecadacao
        inner join nrsDuplicados nrdup on estorno.nrestorno= nrdup.nrestorno and estorno.nranoestorno= nrdup.nranoestorno
        inner join estornosDuplicados estornoDup on estorno.nrestorno = estornoDup.nrestorno
        and estorno.nrarrecadacao = estornoDup.nrarrecadacao and estorno.nranoarrecadacao = estornoDup.nranoarrecadacao
        and estorno.nrmes = estornoDup.nrmes and estorno.nrano = estornoDup.nrano
where estorno.dtestorno between :dataInicial and :dataFinal;