with contagematualizacao as (select nratualizacao, nranoatualizacao, count(1) as nrRegistrosAtualizacao
                             from tceAtualizaMoneCredDA
                             group by nratualizacao, nranoatualizacao),
     contagemdivida as (select nrdivida, nranodivida, count(1) as nrRegistrosDivida
                        from tceinsccreditoda
                        group by nrdivida, nranodivida),
     contagem as (select nranoatualizacao,
                         nrdivida,
                         nranodivida,
                         idtipoatualizacaocredito,
                         cdcontroleleiato,
                         dtatualizacao,
                         count(1) as nrRegistro
                  from tceAtualizaMoneCredDA
                  group by nranoatualizacao, nrdivida, nranodivida, idtipoatualizacaocredito, cdcontroleleiato,
                           dtatualizacao)
select tam.idtceatualizamonecredda,
       tam.nrdivida,
       tam.nranodivida,
       tam.nratualizacao,
       tam.nranoatualizacao,
       tam.idtipocredito,
       tam.dtatualizacao,
       tam.cdcontroleleiato,
       tam.vlatualizacao,
       t.codigo                                                                       as escopolei,
       coalesce(ca.nrRegistrosAtualizacao, 0)                                         as nrRegistrosAtualizacao,
       coalesce(c.nrRegistro, 0)                                                      as nrRegistro,
       coalesce(cd.nrRegistrosDivida, 0)                                              as nrRegistrosDivida,
       coalesce(lag(tam.nratualizacao, 1) over (order by idtceatualizamonecredda), 0) as nratualizacaoAnterior
from tceAtualizaMoneCredDA tam
         inner join contagematualizacao ca
                    on tam.nratualizacao = ca.nratualizacao and tam.nranoatualizacao = ca.nranoatualizacao
         left join contagem c on tam.nranoatualizacao = c.nranoatualizacao and tam.nrdivida = c.nrdivida and
                                  tam.nranodivida = c.nranodivida and
                                  tam.idtipoatualizacaocredito = c.idtipoatualizacaocredito and
                                  tam.cdcontroleleiato = c.cdcontroleleiato and tam.dtatualizacao = c.dtatualizacao
         left join contagemdivida cd on tam.nrdivida = cd.nrdivida and tam.nranodivida = cd.nranodivida
         left join cgato cg on cg.entidade = :entidade and cg.idato = tam.cdControleLeiAto
         left join tipoescopolei t on cg.idtipoescopolei = t.id
where tam.dtatualizacao between :dataInicial and :dataFinal