with contagem as (select nrestorno, nranoestorno, count(1) as nrRegistrosEstorno
                  from tceAtualizaMoneCredDAEst
                  group by nrestorno, nranoestorno),
     atualizacaoda as (select nratualizacao, nranoatualizacao, dtatualizacao, count(1) as nrRegistrosDA
                       from tceAtualizaMoneCredDA
                       group by nratualizacao, nranoatualizacao, dtatualizacao),
     contagemestorno as (select nranoestorno,
                                nratualizacao,
                                nranoatualizacao,
                                cdcontroleleiato,
                                dtestorno,
                                count(1) as nrRegistrosEstornoAgrupado
                         from tceAtualizaMoneCredDAEst
                         group by nranoestorno, nratualizacao, nranoatualizacao, cdcontroleleiato, dtestorno)
select tame.idtceatualizamonecreddaest,
       tame.nratualizacao,
       tame.nranoatualizacao,
       tame.nrestorno,
       tame.nranoestorno,
       tame.idtipocredito,
       tame.dtestorno,
       tame.cdcontroleleiato,
       tame.vlestorno,
       tame.dsmotivo,
       t.codigo                                                                       as escopolei,
       ca.nrRegistrosEstorno,
       coalesce(atualizacaoda.nrRegistrosDA, 0)                                       as nrRegistrosDA,
       atualizacaoda.dtatualizacao,
       coalesce(contagemestorno.nrRegistrosEstornoAgrupado, 0)                        as nrRegistrosEstornoAgrupado,
       coalesce(lag(tame.nrestorno, 1) over (order by idtceatualizamonecreddaest), 0) as nrestornoAnterior
from tceAtualizaMoneCredDAEst tame
         inner join contagem ca
                    on tame.nrestorno = ca.nrestorno and tame.nranoestorno = ca.nranoestorno
         left join atualizacaoda on tame.nratualizacao = atualizacaoda.nratualizacao and
                                    tame.nranoatualizacao = atualizacaoda.nranoatualizacao
         left join contagemestorno on tame.nranoestorno = contagemestorno.nranoestorno and
                                      tame.nratualizacao = contagemestorno.nratualizacao and
                                      tame.nranoatualizacao = contagemestorno.nranoatualizacao and
                                      tame.cdcontroleleiato = contagemestorno.cdcontroleleiato and
                                      tame.dtestorno = contagemestorno.dtestorno
         left join cgato cg on cg.entidade = :entidade and cg.idato = tame.cdControleLeiAto
         left join tipoescopolei t on cg.idtipoescopolei = t.id
where tame.dtestorno between :dataInicial and :dataFinal