select filtro.TipoCadastro,
       filtro.GuiaRecolhimento,
       filtro.TipoReceita,
       filtro.TipoGuiaRecolhimento,
       filtro.valor as ValorArrecadado
from
    (
-- Pagamento
Select tdpr.TipoCadastro,
       tdpr.GuiaRecolhimento,
       tr.TipoReceita,
       tgr.TipoGuiaRecolhimento,
       sum(tpd.valorpago + tpd.valorpagomaior) as valor
from tribpagamentodebito tpd
  left join tribpagamentobloqueto tpb on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto
  left join tribpagamento tp on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento
  left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tpd.iddebitoparcelareceita
  left join tribguiarecolhimento tgr on tgr.entidade = tdpr.entidade and tgr.exercicio = tdpr.exercicio and tgr.guiarecolhimento = tdpr.guiarecolhimento
  left join tribreceita tr on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita
  left join contabancaria cb  on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
where tp.entidade = :entidade
  and tp.datalancamento  between ':dataInicial' AND ':dataFinal'
  and coalesce(cb.integraarrecadacao, 'S') = 'S'
  and tr.tiporeceita = 2
group by
       tdpr.TipoCadastro,
       tdpr.GuiaRecolhimento,
       tr.TipoReceita,
       tgr.TipoGuiaRecolhimento
union all
-- Reabilitação Pagamento
Select tdpr.TipoCadastro,
       tdpr.GuiaRecolhimento,
       tr.TipoReceita,
       tgr.TipoGuiaRecolhimento,
       sum(tpd.valorpago + tpd.valorpagomaior) as valor
from tribpagamentodebito tpd
  left join tribpagamentobloqueto tpb on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto
  left join tribpagamento tp on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento AND tpb.pagamento = tp.pagamento
  left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tpd.iddebitoparcelareceita
  left join tribguiarecolhimento tgr on tgr.entidade = tdpr.entidade and tgr.exercicio = tdpr.exercicio and tgr.guiarecolhimento = tdpr.guiarecolhimento
  left join tribreceita tr on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita
  left join tribreceitatipo trt   ON trt.tiporeceita = tr.tiporeceita
  left join contabancaria cb  on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
  join tribestornopagamento tep on tep.entidade = tp.entidade and tep.exerciciopagamento = tp.exerciciopagamento and tep.pagamento = tp.pagamento
where tp.entidade = :entidade
  and tep.datareabilitacao is not null
  and tep.datareabilitacao between ':dataInicial' AND ':dataFinal'
  and tep.datareabilitacao <> tep.data
  and tr.tiporeceita = 2
group by
       tdpr.TipoCadastro,
       tdpr.GuiaRecolhimento,
       tr.TipoReceita,
       tgr.TipoGuiaRecolhimento
union ALL
-- Crédito de Contribuinte
Select tdpr.TipoCadastro,
       tdpr.GuiaRecolhimento,
       tr.TipoReceita,
       tgr.TipoGuiaRecolhimento,
       sum(tcci.valorlancado) as valor
from tribcreditocontribuinte tcc
  left outer join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade  and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte  = tcc.creditocontribuinte
  left outer join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tcci.iddebitoparcelareceita
  left join tribguiarecolhimento tgr on tgr.entidade = tdpr.entidade and tgr.exercicio = tdpr.exercicio and tgr.guiarecolhimento = tdpr.guiarecolhimento
  left join tribreceita tr on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita
       join contabancaria cb  on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
where tcc.entidade = :entidade
  and tcc.data BETWEEN ':dataInicial' AND ':dataFinal'
  and coalesce(cb.integraarrecadacao, 'S') = 'S'
  and tr.tiporeceita = 2
group by
       tdpr.TipoCadastro,
       tdpr.GuiaRecolhimento,
       tr.TipoReceita,
       tgr.TipoGuiaRecolhimento
union all
-- Devolucao de credito
Select tdpr.tipocadastro,
       tdpr.guiarecolhimento,
       tr.TipoReceita,
       tgr.tipoguiarecolhimento,
       sum(dd.valordevolvido * -1) as valor
from tribDevolucaoCredito            d
  LEFT join tribDevolucaoCreditoItem     di   on di.iddevolucaocredito = d.iddevolucaocredito
                 left join tribDevolucaoCreditoDebito   dd   on dd.iddevolucaocredito = di.iddevolucaocredito and dd.sequenciaitem = di.sequenciaitem
                 left join tribDebitoParcelaReceita     tdpr on dd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                 left join tribdebitoparcela            tdp  on tdp.entidade  = tdpr.entidade and tdp.exercicio = tdpr.exercicio
                                                           and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral  = tdpr.cadastrogeral
                                                           and tdp.guiarecolhimento  = tdpr.guiarecolhimento and tdp.subdivida  = tdpr.subdivida
                                                           and tdp.parcela = tdpr.parcela
                 left join tribguiarecolhimento tgr on tgr.entidade = tdpr.entidade and tgr.exercicio = tdpr.exercicio and tgr.guiarecolhimento = tdpr.guiarecolhimento
                 left join tribreceita                  tr   on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita
                 join contabancaria                cb   on cb.entidade = d.entidade and cb.contabancaria = d.contabancaria
where d.entidade = :entidade
          and d.data between ':dataInicial' and ':dataFinal'
          and coalesce(cb.integraarrecadacao, 'S') = 'S'
          and tr.tiporeceita = 2
group by
       tdpr.tipocadastro,
       tdpr.guiarecolhimento,
       tr.TipoReceita,
       tgr.tipoguiarecolhimento
union all
--Estorno de Pagamento
Select tdpr.TipoCadastro,
       tdpr.GuiaRecolhimento,
       tr.TipoReceita,
       tgr.TipoGuiaRecolhimento,
       sum(tpd.valorpago + tpd.valorpagomaior) as valor
from tribestornopagamento tep
  left join tribestornopagamentoitem tepi
    on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
  left join tribpagamentodebito tpd
    on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto
   AND tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
  left join tribpagamentobloqueto tpb
    on tpb.idpagamentobloqueto = tpd.idpagamentobloqueto
  left join tribpagamento tp
    on tp.entidade = tpb.entidade
    and tp.exerciciopagamento = tpb.exerciciopagamento
    and tp.pagamento = tpb.pagamento
  LEFT join contabancaria cb
    on tep.entidade = cb.entidade and tep.contabancariaestorno = cb.contabancaria
  left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
  left join tribguiarecolhimento tgr on tgr.entidade = tdpr.entidade and tgr.exercicio = tdpr.exercicio and tgr.guiarecolhimento = tdpr.guiarecolhimento
  left join tribreceita tr on tr.receita = tdpr.receita and tr.exercicio = tdpr.exercicio and tr.entidade = tdpr.entidade
where tep.entidade = :entidade
  and tep.data BETWEEN ':dataInicial' AND ':dataFinal'
  and tep.geracreditocontribuinte = 'N'
  and coalesce(cb.integraarrecadacao, 'S') = 'S'
  and tr.tiporeceita = 2
  and (tep.datareabilitacao is null or (tep.datareabilitacao is not null and tep.data <> tep.datareabilitacao))
group by
       tdpr.TipoCadastro,
       tdpr.GuiaRecolhimento,
       tr.TipoReceita,
       tgr.TipoGuiaRecolhimento
union all
--Estorno de Crédito de Contribuinte
Select tdpr.TipoCadastro,
       tdpr.GuiaRecolhimento,
       tr.TipoReceita,
       tgr.TipoGuiaRecolhimento,
       sum(tcci.valorestornado * -1) as valor
from tribcreditocontribuinte tcc
  left join tribCreditoContribuinteItem tcci
     on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio
     and tcci.creditocontribuinte = tcc.creditocontribuinte
  left join contabancaria cb on tcc.entidade = cb.entidade and tcc.contabancariaestorno = cb.contabancaria
  left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
  left join tribdebitoparcela            tdp
     on tdp.entidade  = tdpr.entidade
     and tdp.exercicio = tdpr.exercicio
    and tdp.tipocadastro = tdpr.tipocadastro
    and tdp.cadastrogeral  = tdpr.cadastrogeral
    and tdp.guiarecolhimento  = tdpr.guiarecolhimento
    and tdp.subdivida  = tdpr.subdivida
    and tdp.parcela = tdpr.parcela
  left join tribguiarecolhimento tgr on tgr.entidade = tdpr.entidade and tgr.exercicio = tdpr.exercicio and tgr.guiarecolhimento = tdpr.guiarecolhimento
  left join tribreceita tr on tr.receita = tdpr.receita and tr.exercicio = tdpr.exercicio and tr.entidade = tdpr.entidade
where tcc.entidade = :entidade
  and tcc.dataestorno BETWEEN ':dataInicial' AND ':dataFinal'
  and tcc.valorestornado > 0
  and tr.tiporeceita = 2
  and coalesce(cb.integraarrecadacao, 'S') = 'S'
group by
       tdpr.TipoCadastro,
       tdpr.GuiaRecolhimento,
       tr.TipoReceita,
       tgr.TipoGuiaRecolhimento
) as filtro