SELECT
   debitoParcela.entidade,
   case when tpp.porcontribuinte = 'S' then null
   else debitoParcela.tipocadastro end as tipocadastro,
   case when tpp.porcontribuinte = 'S' then null
   else debitoParcela.cadastrogeral  end as cadastroGeral,
   debitoparcela.parcela,
   debitoparcela.datavencimento,
   situacaoparcela.descricao AS situacao,
   tiposituacaoparcela.tiposituacaoparcela,
   CASE WHEN (tiposituacaoparcela.tipo = 'A') THEN 1 ELSE 0 END AS aberto,
   SUM(debitoParcelareceita.valor) AS valor,
   SUM(debitoParcelareceita.valorJuros) AS valorJuros,
   SUM(debitoParcelareceita.valorMulta) AS valorMulta,
   SUM(debitoParcelareceita.valorCorrecao) AS valorCorrecao,
   SUM(debitoParcelareceita.valorDesconto) AS valordesconto
FROM TribParcelamentoDebito parcelamentoDebito
LEFT OUTER JOIN TribDebito debito
   ON parcelamentoDebito.idDebito = debito.idDebito
left outer join tribdebitoparcela debitoparcela
   ON debito.entidade = debitoParcela.entidade
   AND debito.exercicio = debitoParcela.exercicio
   AND debito.tipoCadastro = debitoParcela.tipoCadastro
   AND debito.cadastroGeral = debitoParcela.cadastroGeral
   AND debito.guiaRecolhimento = debitoParcela.guiaRecolhimento
   AND debito.subDivida = debitoParcela.subDivida
left outer join tribsituacaoparcela situacaoparcela
   on debitoparcela.situacaodebito = situacaoparcela.situacaoparcela
left outer join tribtiposituacaoparcela tiposituacaoparcela
   on situacaoparcela.tiposituacaoparcela = tiposituacaoparcela.tiposituacaoparcela
LEFT OUTER JOIN TribDebitoParcelaReceita debitoParcelareceita
   ON debitoParcela.entidade = debitoParcelareceita.entidade
   AND debitoParcela.exercicio = debitoParcelareceita.exercicio
   AND debitoParcela.tipoCadastro = debitoParcelareceita.tipoCadastro
   AND debitoParcela.cadastroGeral = debitoParcelareceita.cadastroGeral
   AND debitoParcela.guiaRecolhimento = debitoParcelareceita.guiaRecolhimento
   AND debitoParcela.subDivida = debitoParcelareceita.subDivida
   AND debitoParcela.parcela = debitoParcelaReceita.parcela
left outer join tribparcelamento tp on tp.idparcelamento  = parcelamentodebito.idparcelamento
left outer join tribparamparcelamento tpp on tpp.idparametroparcelamento  = tp.idparametroparcelamento
WHERE parcelamentoDebito.idParcelamento in (:ids)
GROUP BY
   debitoParcela.entidade,
   case when tpp.porcontribuinte = 'S' then null
   else debitoParcela.tipocadastro end,
   case when tpp.porcontribuinte = 'S' then null
   else debitoParcela.cadastrogeral end,
   debitoparcela.parcela,
   debitoparcela.datavencimento,
   situacaoparcela.descricao,
   tiposituacaoparcela.tipo,
   tiposituacaoparcela.tiposituacaoparcela
ORDER BY debitoparcela.parcela