with socio as
(
SELECT
   TCG.TIPOCADASTRO,
   TCG.CADASTROGERAL
FROM
	TRIBPROPRIETARIO TCSP
LEFT OUTER JOIN TRIBCADASTROGERAL TCG
		ON TCSP.TIPOCADASTRO = TCG.TIPOCADASTRO
		AND TCSP.CADASTROGERAL = TCG.CADASTROGERAL
WHERE TCG.TIPOCADASTRO = 2
%s--AND TCG.DATAALTERACAO between '$[DataInicial]' and '$[DataFinal]'
)
select socio.tipocadastro,
       socio.cadastrogeral,
       array_agg(socios.*) as socios
from socio
left join (
	SELECT
	  TCG.TIPOCADASTRO,
	  TCG.CADASTROGERAL,
	    P.NOME,
	    tv.vinculo,
	    tcsp.principal,
	    TV.DESCRICAO AS DESCVINCULO,
	   TCSP.PERCENTUAL as PERCENTUAL,
	    TLOG.Sigla,
	    LOG.DESCRICAO AS LOGRADOURO,
	    PE.NUMERO,
	  BR.DESCRICAO AS BAIRRO,
	  CID.DESCRICAO AS CIDADE,
	  CID.UNIDADEFEDERACAO AS UF,
	  P.CNPJ_CPF,
	  P.RG,
	    P.ORGAOEMISSOR,
	  CP.TELEFONERESIDENCIAL,
	  cp.telefonecomercial,
	    CP.TELEFONECELULAR,
	    CP.EMAIL,
	    P.TIPOPESSOA,
	    PE.COMPLEMENTO AS COMPLEMENTOENDERECO,
	    PE.CEP,
	    P.PESSOA
	FROM
	  TRIBPROPRIETARIO TCSP
	LEFT OUTER JOIN PESSOA P
	    ON P.PESSOA = TCSP.PESSOA
	LEFT OUTER JOIN ENDERECOPESSOA PE
	    ON P.PESSOA = PE.PESSOA
	    AND PE.SEQUENCIA = 1
	LEFT OUTER JOIN LOGRADOURO LOG
	    ON PE.LOGRADOURO = LOG.LOGRADOURO
	    AND PE.CIDADE = LOG.CIDADE
	LEFT OUTER JOIN TIPOLOGRADOURO TLOG
	    ON LOG.TIPOLOGRADOURO = TLOG.TIPOLOGRADOURO
	LEFT OUTER JOIN CIDADE CID
	    ON pe.CIDADE = CID.CIDADE
	LEFT OUTER JOIN BAIRRO BR
	    ON PE.CIDADE = BR.CIDADE
	    AND PE.BAIRRO = BR.BAIRRO
	LEFT OUTER JOIN TRIBCADASTROGERAL TCG
	    ON TCSP.TIPOCADASTRO = TCG.TIPOCADASTRO
	    AND TCSP.CADASTROGERAL = TCG.CADASTROGERAL
	LEFT OUTER JOIN TRIBCADASTROMOBILIARIO TCM
	    ON TCM.TIPOCADASTRO = TCG.TIPOCADASTRO
	    AND TCM.CADASTROGERAL = TCG.CADASTROGERAL
	LEFT OUTER JOIN TRIBVINCULO TV
	        ON TV.VINCULO = TCSP.VINCULO
	LEFT OUTER JOIN CONTATOPESSOA CP
	        ON CP.PESSOA = PE.PESSOA
	        and pe.sequencia=cp.sequencia
	WHERE TCG.TIPOCADASTRO = 2
	ORDER BY TCG.TIPOCADASTRO, TCG.CADASTROGERAL
) socios
   on socios.tipocadastro = socio.tipocadastro
   and socios.cadastrogeral = socio.cadastrogeral
group by socio.tipocadastro,
         socio.cadastrogeral