Select
      tdao.Entidade,
      tdao.Identificacao,
      tdao.Banco,
      tdao.DataAutorizacao,
      tfp.FormaPagamento,
      tdeb.iddebito,
      tdao.TipoCadastro,
      tdao.CadastroGeral,
      tdao.Exercicio,
      tdao.GuiaRecolhimento,
      tdao.SubDivida,
      tdp.DataVencimento,
      tfp.tipoFormaPagamento,
      tcg.pessoa,
      tdeb.DataPrimeiraParcela,
      count(tdp.parcela) as totalParcelas
from TribDebitoAutomaticoOpcao tdao
left outer join TribDebito tdeb on
     tdao.Entidade = tdeb.Entidade
     and tdao.Exercicio = tdeb.Exercicio
     and tdao.TipoCadastro = tdeb.TipoCadastro
     and tdao.CadastroGeral = tdeb.CadastroGeral
     and tdao.GuiaRecolhimento = tdeb.GuiaRecolhimento
     and tdao.SubDivida = tdeb.SubDivida
left outer join TribDebitoParcela tdp on
     tdeb.Entidade = tdp.Entidade
     and tdeb.Exercicio = tdp.Exercicio
     and tdeb.TipoCadastro = tdp.TipoCadastro
     and tdeb.CadastroGeral = tdp.CadastroGeral
     and tdeb.GuiaRecolhimento = tdp.GuiaRecolhimento
     and tdeb.SubDivida = tdp.SubDivida
left outer join TribSituacaoParcela tsp on
     tdp.SituacaoDebito = tsp.SituacaoParcela
left outer join TribTipoSituacaoParcela ttsp on
     tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela
left outer join TribCadastroGeral tcg
        on tdp.TipoCadastro = tcg.TipoCadastro and
           tdp.CadastroGeral = tcg.CadastroGeral
left outer join TribFormaPagamento tfp on
        tdao.FormaPagamento = tfp.FormaPagamento
Where tdao.Entidade = 1
  and tdao.dataExclusao is null
  and ttsp.tipo = 'A'
  and not exists (select 1
                  from tribremdebitoautomaticodetalhe rem
                  where rem.entidade         = tdp.entidade
                  and   rem.exercicio        = tdp.exercicio
                  and   rem.tipocadastro     = tdp.tipocadastro
                  and   rem.cadastrogeral    = tdp.cadastrogeral
                  and   rem.guiarecolhimento = tdp.guiarecolhimento
                  and   rem.subdivida        = tdp.subdivida
                  and   rem.parcela          = tdp.parcela)
  $[FILTROS]
group by tdao.Entidade,
      tdao.Identificacao,
      tdao.Banco,
      tdao.DataAutorizacao,
      tfp.FormaPagamento,
      tdeb.iddebito,
      tdao.TipoCadastro,
      tdao.CadastroGeral,
      tdao.Exercicio,
      tdao.GuiaRecolhimento,
      tdao.SubDivida,
      tdp.DataVencimento,
      tfp.tipoFormaPagamento,
      tcg.pessoa,
      tdeb.DataPrimeiraParcela
order by tdao.TipoCadastro, tdao.CadastroGeral, tdao.Exercicio, tdao.GuiaRecolhimento, tdao.SubDivida
