/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.ws.mapper;

import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneAiseDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneResponseDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneTransportDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneTransportListDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoMapper;
import br.com.elotech.tributos.ws.rest.dto.DebitoTransportDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoTransportItbiBloquetoDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoTransportListDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class AiseWSMapper {
    private final DebitoMapper debitoMapper;
    private final ObjectMapper objectMapper;

    public AiseWSMapper(DebitoMapper debitoMapper, ObjectMapper objectMapper) {
        this.debitoMapper = debitoMapper;
        this.objectMapper = objectMapper;
    }

    public String toEnvioRest(List<DebitoDTO> debitosMarcados) throws JsonProcessingException {
        List debitosDelphiMarcados = debitosMarcados.stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDelphiDTO(arg_0)).collect(Collectors.toList());
        DebitoTransportDTO transport = new DebitoTransportDTO();
        DebitoTransportListDTO transportList = new DebitoTransportListDTO();
        transport.setList(transportList);
        transportList.setItems(debitosDelphiMarcados);
        return this.objectMapper.writeValueAsString((Object)transport);
    }

    public String toEnvioRest(List<DebitoDTO> debitosMarcados, String usuario) throws JsonProcessingException {
        List debitosDelphiMarcados = debitosMarcados.stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDelphiDTO(arg_0)).collect(Collectors.toList());
        DebitoTransportDTO transport = new DebitoTransportDTO();
        DebitoTransportListDTO transportList = new DebitoTransportListDTO();
        transport.setList(transportList);
        transportList.setItems(debitosDelphiMarcados);
        transport.setUsuario(usuario);
        return this.objectMapper.writeValueAsString((Object)transport);
    }

    public String toEnvioRest(List<DebitoDTO> debitosMarcados, String usuario, Long pessoa) throws JsonProcessingException {
        List debitosDelphiMarcados = debitosMarcados.stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDelphiDTO(arg_0)).collect(Collectors.toList());
        DebitoTransportItbiBloquetoDTO transport = new DebitoTransportItbiBloquetoDTO();
        DebitoTransportListDTO transportList = new DebitoTransportListDTO();
        transport.setList(transportList);
        transportList.setItems(debitosDelphiMarcados);
        transport.setUsuario(usuario);
        transport.setPessoa(pessoa);
        transport.setEmissaoItbi(Boolean.TRUE);
        return this.objectMapper.writeValueAsString((Object)transport);
    }

    public String toEnvioRest(List<DebitoDTO> debitosMarcados, LocalDate dataReferencia) throws JsonProcessingException {
        List debitosDelphiMarcados = debitosMarcados.stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDelphiDTO(arg_0)).collect(Collectors.toList());
        DebitoTransportDTO transport = new DebitoTransportDTO();
        DebitoTransportListDTO transportList = new DebitoTransportListDTO();
        transport.setList(transportList);
        transport.setDataReferencia(dataReferencia);
        transportList.setItems(debitosDelphiMarcados);
        return this.objectMapper.writeValueAsString((Object)transport);
    }

    public String toEnvioRest(DebitoCarneAiseDTO debitoCarneDTO) throws JsonProcessingException {
        DebitoCarneResponseDTO debitoCarneResponseDTO = this.debitoMapper.toDebitoCarneResponseDTO(debitoCarneDTO);
        DebitoCarneTransportDTO transport = new DebitoCarneTransportDTO();
        DebitoCarneTransportListDTO transportList = new DebitoCarneTransportListDTO();
        transportList.getItems().add(debitoCarneResponseDTO);
        transport.setList(transportList);
        return this.objectMapper.writeValueAsString((Object)transport);
    }
}

