/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.transferenciadebito;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.core.utils.ListUtils;
import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoObservacao;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaObservacao;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.domain.transferenciadebito.TransferenciaDebito;
import br.com.elotech.tributos.domain.transferenciadebito.TransferenciaDebitoItem;
import br.com.elotech.tributos.dto.transferenciadebito.FiltroTDDebitoParcelaDTO;
import br.com.elotech.tributos.dto.transferenciadebito.TDDebitoParcelaDTO;
import br.com.elotech.tributos.dto.transferenciadebito.TDDebitosParcelasCheckedDTO;
import br.com.elotech.tributos.dto.transferenciadebito.TranferirDebitoDTO;
import br.com.elotech.tributos.params.NextSubdividaValueParams;
import br.com.elotech.tributos.repository.DebitoParcelaRepository;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.parcelamento.ParcelamentoDebitoOrigemRepository;
import br.com.elotech.tributos.repository.parcelamento.ParcelamentoReceitaEspelhoRepository;
import br.com.elotech.tributos.repository.parcelamento.ParcelamentoRepository;
import br.com.elotech.tributos.repository.transferenciadebito.TransferenciaDebitoParcelaRepository;
import br.com.elotech.tributos.repository.transferenciadebito.TransferenciaDebitoRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.DebitoObservacaoService;
import br.com.elotech.tributos.service.DebitoParcelaObservacaoService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.MotivoDeducaoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.cancelamento.CancelamentoDebitoService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class TransferenciaDebitoService
extends CrudService<TransferenciaDebito, Long> {
    private final ParametroGeralService parametroGeralService;
    private final DebitoService debitoService;
    private final GeraDebitoService geraDebitoService;
    private final DocumentoService documentoService;
    private final MotivoDeducaoService motivoDeducaoService;
    private final CancelamentoDebitoService cancelamentoDebitoService;
    private final CadastroGeralService cadastroGeralService;
    private final DebitoObservacaoService debitoObservacaoService;
    private final DebitoParcelaObservacaoService debitoParcelaObservacaoService;
    private final DebitoParcelaRepository debitoParcelaRepository;
    private final ParcelamentoRepository parcelamentoRepository;
    private final ParcelamentoReceitaEspelhoRepository parcelamentoReceitaEspelhoRepository;
    private final ParcelamentoDebitoOrigemRepository parcelamentoDebitoOrigemRepository;
    private final TransferenciaDebitoRepository transferenciaDebitoRepository;
    private final TransferenciaDebitoParcelaRepository transferenciaDebitoParcelaRepository;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private static final Long INITIAL_VALUE_NEW_SUB_DIVIDA = 0L;
    private static final String DEBITO_VIOLATION = "D\u00e9bito com cadastro: %d/%d, exerc\u00edcio: %d, d\u00edvida: %d, sub: %d";
    private static final String DEBITO_PARCELA_VIOLATION = "Parcela com cadastro: %d/%d, exerc\u00edcio: %d, d\u00edvida: %d, sub: %d, parcela: %d";
    private static final String DEBITO_OBSERVACAO = "Transfer\u00eancia do d\u00e9bito %d/%d/%d realizada do cadastro %d/%d para o cadastro %d/%d";
    private static final String DEBITO_PARCELA_OBSERVACAO = "Transfer\u00eancia da parcela %d do d\u00e9bito %d/%d/%d realizada do cadastro %d/%d para o cadastro %d/%d";
    private static final String SEQUENCE_ID_TRANSFERENCIA = "s05idtransferencia";
    private static final String DEBITOS_PARCELAS_PARCELADOS_REPARCELADOS = "A Transfer\u00eancia de D\u00e9bito n\u00e3o pode ser executada pois existe d\u00e9bito(s) parcelado(s) ou reparcelado(s)!";
    private static final String DEBITOS_PARCELAS_DIVIDA_ATIVA_OU_JUIZO = "N\u00e3o \u00e9 permitido realizar a transfer\u00eancia de d\u00e9bitos para cadastros de contribuintes diferentes quando existir d\u00e9bitos em D\u00edvida Ativa ou Em Juizo. Verifique o(s) d\u00e9bito(s) informado(s) ou o cadastro de transfer\u00eancia!";
    private static final String DEBITOS_PARCELAS_NOT_FOUND = "N\u00e3o foi poss\u00edvel encontrar os d\u00e9bitos/parcelas com o filtro informado! Verifique se os d\u00e9bitos/parcelas que deseja buscar est\u00e3o em uma situa\u00e7\u00e3o v\u00e1lida para a transfer\u00eancia.";

    public Page<TDDebitoParcelaDTO> findDebitosParcelas(FiltroTDDebitoParcelaDTO filtro, Pageable pageable) {
        filtro.setPermiteTransferirDebitosReparcelado(Boolean.valueOf(this.permiteTransferirDebitosReparcelado()));
        Page found = this.transferenciaDebitoParcelaRepository.findDebitosParcelas(filtro, pageable);
        this.validateAfterFindDebitosParcelas(found);
        return found;
    }

    public TDDebitosParcelasCheckedDTO findDebitosParcelasToCheckAll(FiltroTDDebitoParcelaDTO filtro) {
        filtro.setPermiteTransferirDebitosReparcelado(Boolean.valueOf(this.permiteTransferirDebitosReparcelado()));
        List ids = this.transferenciaDebitoParcelaRepository.findDebitosParcelasToCheckAll(filtro);
        this.validateAfterFindDebitosParcelasToCheckAll(ids);
        TDDebitosParcelasCheckedDTO dto = new TDDebitosParcelasCheckedDTO();
        dto.setIds(ids);
        return dto;
    }

    public TransferenciaDebito transferir(TranferirDebitoDTO dto) {
        CadastroGeral newCadastro = (CadastroGeral)this.cadastroGeralService.findOne((Serializable)dto.getIdCadastroDestino());
        List allOldParcelas = this.debitoParcelaRepository.findByIdDebitoParcelaIn(dto.getIdsDebitosParcelas());
        List oldDebitos = this.getDistinctDebitosByParcelas(allOldParcelas);
        this.validateBeforeTransferir(newCadastro, oldDebitos, allOldParcelas);
        MotivoDeducao motivoDeducao = (MotivoDeducao)this.motivoDeducaoService.findOne((Serializable)dto.getIdMotivoCancelamento());
        Long idTransferencia = this.sequenceGeneratorRepository.getNextVal(SEQUENCE_ID_TRANSFERENCIA);
        AtomicLong newSubDivida = new AtomicLong(INITIAL_VALUE_NEW_SUB_DIVIDA);
        TransferenciaDebito transferencia = TransferenciaDebito.from((Long)idTransferencia, (String)dto.getObservacao());
        HashMap oldParcelasByDebito = this.groupParcelasByDebito(oldDebitos, allOldParcelas);
        oldParcelasByDebito.forEach((oldDebito, oldParcelas) -> {
            this.iterateNewSubDivida(oldDebito, newCadastro, newSubDivida);
            Debito newDebito = this.geraDebito(newCadastro, Long.valueOf(newSubDivida.get()), oldDebito, oldParcelas);
            TransferenciaDebitoItem transferenciaDebitoItem = TransferenciaDebitoItem.from((TransferenciaDebito)transferencia, (Debito)oldDebito, (Debito)newDebito);
            this.updateCda(oldDebito, newDebito);
            this.updateParcelamento(oldDebito, newDebito, transferenciaDebitoItem);
            this.updateObservacoesDebitoOrigem(newCadastro, oldDebito, oldParcelas);
            this.cancelamentoDebitoPorParcela(motivoDeducao, dto.getObservacao(), oldParcelas);
            transferencia.getDebitos().add(transferenciaDebitoItem);
        });
        return (TransferenciaDebito)this.transferenciaDebitoRepository.save((Object)transferencia);
    }

    protected void iterateNewSubDivida(Debito oldDebito, CadastroGeral newCadastro, AtomicLong newSubDivida) {
        if (INITIAL_VALUE_NEW_SUB_DIVIDA.equals(newSubDivida.get())) {
            newSubDivida.set(this.debitoService.getNextValueSubdivida(NextSubdividaValueParams.of((Long)newCadastro.getTipoCadastro().getValue(), (Long)newCadastro.getCadastroGeral(), (Long)oldDebito.getExercicio(), (Long)oldDebito.getDivida().getDivida())));
            return;
        }
        newSubDivida.set(newSubDivida.incrementAndGet());
    }

    private HashMap<Debito, List<DebitoParcela>> groupParcelasByDebito(List<Debito> debitos, List<DebitoParcela> parcelas) {
        HashMap<Debito, List<DebitoParcela>> parcelasByDebito = new HashMap<Debito, List<DebitoParcela>>();
        debitos.forEach(debito -> parcelasByDebito.put((Debito)debito, this.filterParcelasByDebito(debito, parcelas)));
        return parcelasByDebito;
    }

    private void validateAfterFindDebitosParcelas(Page<TDDebitoParcelaDTO> found) {
        if (!found.hasContent()) {
            throw new EloValidationException(DEBITOS_PARCELAS_NOT_FOUND);
        }
    }

    private void validateAfterFindDebitosParcelasToCheckAll(List<Long> ids) {
        if (Boolean.TRUE.equals(ListUtils.safeIsEmpty(ids))) {
            throw new EloValidationException(DEBITOS_PARCELAS_NOT_FOUND);
        }
    }

    private void validateBeforeTransferir(CadastroGeral newCadastro, List<Debito> debitos, List<DebitoParcela> parcelas) {
        this.validatePermiteTransferirDebitosReparcelado(debitos);
        this.validatePermiteTransferirParcelasDividaAtivaOuJuizo(newCadastro, parcelas);
    }

    private void validatePermiteTransferirDebitosReparcelado(List<Debito> debitos) {
        if (this.permiteTransferirDebitosReparcelado()) {
            return;
        }
        this.validateExisteDebitoReparcelado(debitos);
    }

    private boolean permiteTransferirDebitosReparcelado() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.PERMITE_TRANSFERIR_DEBITOS_REPARC);
    }

    private void validateExisteDebitoReparcelado(List<Debito> debitos) {
        List parceladosOuReparcelados = this.filterParceladosOuReparcelados(debitos);
        if (!parceladosOuReparcelados.isEmpty()) {
            List violations = this.getDebitoViolations(parceladosOuReparcelados);
            throw new EloValidationException(DEBITOS_PARCELAS_PARCELADOS_REPARCELADOS, violations);
        }
    }

    private List<Debito> filterParceladosOuReparcelados(List<Debito> debitos) {
        return debitos.stream().filter(Debito::isParceladoOrReparcelado).collect(Collectors.toList());
    }

    private void validatePermiteTransferirParcelasDividaAtivaOuJuizo(CadastroGeral newCadastro, List<DebitoParcela> parcelas) {
        if (this.isTransferenciaParaOMesmoContribuinte(newCadastro, parcelas)) {
            return;
        }
        this.validateExisteParcelasDividaAtivaOuJuizo(parcelas);
    }

    private boolean isTransferenciaParaOMesmoContribuinte(CadastroGeral newCadastro, List<DebitoParcela> parcelas) {
        List pessoasByDebitos = parcelas.stream().map(DebitoParcela::getPessoa).collect(Collectors.toList());
        return this.allPessoasMatchByCadastro(newCadastro, pessoasByDebitos);
    }

    private boolean allPessoasMatchByCadastro(CadastroGeral newCadastro, List<Pessoa> pessoasByDebitos) {
        return pessoasByDebitos.stream().allMatch(pessoa -> Objects.equals(pessoa.getId(), newCadastro.getPessoa().getId()));
    }

    private void validateExisteParcelasDividaAtivaOuJuizo(List<DebitoParcela> parcelas) {
        List emDividaAtivaOuEmJuizo = this.filterParcelasDividaAtivaOuJuizo(parcelas);
        if (!emDividaAtivaOuEmJuizo.isEmpty()) {
            List violations = this.getDebitoParcelaViolations(emDividaAtivaOuEmJuizo);
            throw new EloValidationException(DEBITOS_PARCELAS_DIVIDA_ATIVA_OU_JUIZO, violations);
        }
    }

    private List<DebitoParcela> filterParcelasDividaAtivaOuJuizo(List<DebitoParcela> parcelas) {
        return parcelas.stream().filter(DebitoParcela::isEmDividaAtivaOrJuizo).collect(Collectors.toList());
    }

    private List<EloViolation> getDebitoViolations(List<Debito> debitos) {
        return debitos.stream().map(arg_0 -> this.getDebitoViolation(arg_0)).collect(Collectors.toList());
    }

    private EloViolation getDebitoViolation(Debito debito) {
        return new EloViolation(String.format(DEBITO_VIOLATION, debito.getTipoCadastro(), debito.getCadastroGeral().getCadastroGeral(), debito.getExercicio(), debito.getDivida().getDivida(), debito.getSubDivida()));
    }

    private List<EloViolation> getDebitoParcelaViolations(List<DebitoParcela> parcelas) {
        return parcelas.stream().map(arg_0 -> this.getDebitoParcelaViolation(arg_0)).collect(Collectors.toList());
    }

    private EloViolation getDebitoParcelaViolation(DebitoParcela parcela) {
        return new EloViolation(String.format(DEBITO_PARCELA_VIOLATION, parcela.getId().getTipoCadastro(), parcela.getId().getCadastroGeral(), parcela.getId().getExercicio(), parcela.getId().getDivida(), parcela.getId().getSubDivida(), parcela.getId().getParcela()));
    }

    private Debito geraDebito(CadastroGeral newCadastro, Long newSubDivida, Debito debito, List<DebitoParcela> parcelas) {
        List tributos = this.filterTributosByDebito(debito, parcelas);
        return this.geraDebitoService.geraDebitoTransferencia(newCadastro, newSubDivida, debito, parcelas, tributos);
    }

    private void updateCda(Debito oldDebito, Debito newDebito) {
        Documento cda = this.documentoService.findCdaEmAbertoByDebito(oldDebito.getEntidade(), oldDebito.getExercicio(), oldDebito.getTipoCadastro(), oldDebito.getCadastroGeralId(), oldDebito.getDivida().getDivida(), oldDebito.getSubDivida());
        if (Objects.nonNull(cda)) {
            cda.getDocumentoItemDividaAtivas().forEach(item -> {
                item.setDebito(newDebito);
                item.setTipoCadastro(newDebito.getTipoCadastro());
                item.setCadastroGeral(newDebito.getCadastroGeralId());
                item.setSubDivida(newDebito.getSubDivida());
            });
            cda.setTipoCadastro(newDebito.getCadastroGeral().getTipoCadastro());
            cda.setCodigoCadastroGeral(newDebito.getCadastroGeralId());
            cda.setCadastroGeral(newDebito.getCadastroGeral());
            this.documentoService.update(cda);
        }
    }

    private void updateParcelamento(Debito oldDebito, Debito newDebito, TransferenciaDebitoItem transferenciaDebitoItem) {
        if (oldDebito.isParceladoOrReparcelado()) {
            Parcelamento parcelamento = (Parcelamento)this.parcelamentoRepository.findOne((Object)oldDebito.getIdParcelamento());
            parcelamento.setCadastroGeral(newDebito.getCadastroGeral());
            parcelamento.getDebitos().removeIf(d -> d.getId().equals(oldDebito.getId()));
            parcelamento.getDebitos().add(newDebito);
            this.parcelamentoRepository.save((Object)parcelamento);
            transferenciaDebitoItem.setParcelamento(parcelamento);
            this.updateAllParcelamentoReceitaEspelho(oldDebito, newDebito, parcelamento);
            this.updateAllParcelamentoDebitoOrigem(oldDebito, newDebito, parcelamento);
        }
    }

    private void updateAllParcelamentoReceitaEspelho(Debito oldDebito, Debito newDebito, Parcelamento parcelamento) {
        List espelhos = this.parcelamentoReceitaEspelhoRepository.findByParcelamentoAndDebitoNovo(parcelamento.getId(), oldDebito.getId());
        espelhos.forEach(espelho -> espelho.setDebitoNovo(newDebito));
        this.parcelamentoReceitaEspelhoRepository.saveAll((Iterable)espelhos);
    }

    private void updateAllParcelamentoDebitoOrigem(Debito oldDebito, Debito newDebito, Parcelamento parcelamento) {
        List origens = this.parcelamentoDebitoOrigemRepository.findByParcelamentoAndDebitoNovo(parcelamento.getId(), oldDebito.getId());
        ArrayList copies = new ArrayList();
        origens.forEach(origem -> copies.add(origem.copy(parcelamento, origem.getId().getDebito(), newDebito)));
        this.parcelamentoDebitoOrigemRepository.deleteAll((Iterable)origens);
        this.parcelamentoDebitoOrigemRepository.saveAll(copies);
    }

    private void updateObservacoesDebitoOrigem(CadastroGeral cadastro, Debito debito, List<DebitoParcela> parcelas) {
        this.updateObservacaoDebitoOrigem(cadastro, debito);
        this.updateObservacoesParcelasOrigem(cadastro, parcelas);
    }

    private void updateObservacaoDebitoOrigem(CadastroGeral cadastro, Debito debito) {
        DebitoObservacao observacao = this.createDebitoObservacao(cadastro, debito);
        this.debitoObservacaoService.save(observacao);
    }

    private DebitoObservacao createDebitoObservacao(CadastroGeral cadastro, Debito debito) {
        String observacao = String.format(DEBITO_OBSERVACAO, debito.getExercicio(), debito.getDivida().getDivida(), debito.getSubDivida(), debito.getTipoCadastro(), debito.getCadastroGeralId(), cadastro.getTipoCadastro().getValue(), cadastro.getCadastroGeral());
        return DebitoObservacao.from((Debito)debito, (String)observacao);
    }

    private void updateObservacoesParcelasOrigem(CadastroGeral cadastro, List<DebitoParcela> parcelas) {
        List observacoes = this.createParcelaObservacoes(cadastro, parcelas);
        this.debitoParcelaObservacaoService.saveAll((Iterable)observacoes);
    }

    private List<DebitoParcelaObservacao> createParcelaObservacoes(CadastroGeral cadastro, List<DebitoParcela> parcelas) {
        return parcelas.stream().map(parcela -> this.createParcelaObservacao(cadastro, parcela)).collect(Collectors.toList());
    }

    private DebitoParcelaObservacao createParcelaObservacao(CadastroGeral cadastro, DebitoParcela parcela) {
        String observacao = String.format(DEBITO_PARCELA_OBSERVACAO, parcela.getId().getParcela(), parcela.getId().getExercicio(), parcela.getId().getDivida(), parcela.getId().getSubDivida(), parcela.getId().getTipoCadastro(), parcela.getId().getCadastroGeral(), cadastro.getTipoCadastro().getValue(), cadastro.getCadastroGeral());
        return DebitoParcelaObservacao.from((DebitoParcela)parcela, (String)observacao);
    }

    private void cancelamentoDebitoPorParcela(MotivoDeducao motivoDeducao, String observacao, List<DebitoParcela> parcelas) {
        this.cancelamentoDebitoService.cancelamentoDebitoPorParcelaTransferencia(motivoDeducao, observacao, parcelas);
    }

    private List<Debito> getDistinctDebitosByParcelas(List<DebitoParcela> parcelas) {
        return parcelas.stream().map(DebitoParcela::getDebito).distinct().collect(Collectors.toList());
    }

    private List<DebitoParcela> filterParcelasByDebito(Debito debito, List<DebitoParcela> parcelas) {
        return parcelas.stream().filter(parcela -> Objects.equals(parcela.getDebito().getId(), debito.getId())).collect(Collectors.toList());
    }

    private List<DebitoTributo> filterTributosByDebito(Debito debito, List<DebitoParcela> parcelas) {
        return debito.getTributos().stream().filter(pt -> this.filterDebitoTributoByParcelas(debito, parcelas)).distinct().collect(Collectors.toList());
    }

    private boolean filterDebitoTributoByParcelas(Debito debito, List<DebitoParcela> parcelas) {
        AtomicBoolean isPresent = new AtomicBoolean(false);
        parcelas.forEach(parcela -> this.setIsPresentByParcelaTributos(debito, parcela.getTributos(), isPresent));
        return isPresent.get();
    }

    private void setIsPresentByParcelaTributos(Debito debito, List<DebitoParcelaTributo> parcelaTributos, AtomicBoolean isPresent) {
        parcelaTributos.forEach(parcelaTributo -> isPresent.set(debito.getDebitoTributoByTributo(parcelaTributo.getTributo()).isPresent()));
    }

    @Generated
    public TransferenciaDebitoService(ParametroGeralService parametroGeralService, DebitoService debitoService, GeraDebitoService geraDebitoService, DocumentoService documentoService, MotivoDeducaoService motivoDeducaoService, CancelamentoDebitoService cancelamentoDebitoService, CadastroGeralService cadastroGeralService, DebitoObservacaoService debitoObservacaoService, DebitoParcelaObservacaoService debitoParcelaObservacaoService, DebitoParcelaRepository debitoParcelaRepository, ParcelamentoRepository parcelamentoRepository, ParcelamentoReceitaEspelhoRepository parcelamentoReceitaEspelhoRepository, ParcelamentoDebitoOrigemRepository parcelamentoDebitoOrigemRepository, TransferenciaDebitoRepository transferenciaDebitoRepository, TransferenciaDebitoParcelaRepository transferenciaDebitoParcelaRepository, SequenceGeneratorRepository sequenceGeneratorRepository) {
        this.parametroGeralService = parametroGeralService;
        this.debitoService = debitoService;
        this.geraDebitoService = geraDebitoService;
        this.documentoService = documentoService;
        this.motivoDeducaoService = motivoDeducaoService;
        this.cancelamentoDebitoService = cancelamentoDebitoService;
        this.cadastroGeralService = cadastroGeralService;
        this.debitoObservacaoService = debitoObservacaoService;
        this.debitoParcelaObservacaoService = debitoParcelaObservacaoService;
        this.debitoParcelaRepository = debitoParcelaRepository;
        this.parcelamentoRepository = parcelamentoRepository;
        this.parcelamentoReceitaEspelhoRepository = parcelamentoReceitaEspelhoRepository;
        this.parcelamentoDebitoOrigemRepository = parcelamentoDebitoOrigemRepository;
        this.transferenciaDebitoRepository = transferenciaDebitoRepository;
        this.transferenciaDebitoParcelaRepository = transferenciaDebitoParcelaRepository;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
    }
}

