/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sisobra;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Certificado;
import br.com.elotech.tributos.domain.sisobra.SisObraDSM;
import br.com.elotech.tributos.repository.DocumentoRepository;
import br.com.elotech.tributos.repository.sisobra.SisObraDSMRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.sisobra.SisObraServiceUtils;
import br.com.elotech.tributos.util.sisobra.SisObraDSMXmlBuilder;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SisObraDSMService {
    private final SisObraDSMRepository sisObraDSMRepository;
    private final DocumentoRepository documentoRepository;
    private final ContextService contextService;
    private final SisObraServiceUtils sisObraServiceUtils;

    public void enviarDeclaracaoSemMovimentos() {
        long ano = LocalDate.now().getYear();
        long mes = LocalDate.now().getMonthValue();
        if (Boolean.TRUE.equals(this.hasDocumentosEmitidosByPeriodo(Long.valueOf(ano), Long.valueOf(mes)))) {
            throw new EloValidationException("A Declara\u00e7\u00e3o sem movimento desse m\u00eas n\u00e3o pode ser enviada pois h\u00e1 documentos emitidos");
        }
        if (!Objects.isNull(this.sisObraDSMRepository.findByAnoAndMes(Long.valueOf(ano), Long.valueOf(mes)))) {
            throw new EloValidationException("A Declara\u00e7\u00e3o sem movimento desse m\u00eas j\u00e1 foi enviada");
        }
        this.gravarDados(Long.valueOf(ano), Long.valueOf(mes));
    }

    public void gravarDados(Long ano, Long mes) {
        Certificado certificado = this.sisObraServiceUtils.getCertificadoByEntidade(this.contextService.getEntidadePrincipal());
        SisObraDSM dsmToSave = new SisObraDSM();
        dsmToSave.setAno(ano);
        dsmToSave.setMes(mes);
        dsmToSave.setDataEnvio(LocalDate.now());
        this.sisObraDSMRepository.save((Object)dsmToSave);
        String xmlToSave = this.getDsmXml(dsmToSave);
        String xmlToSaveAssinado = this.sisObraServiceUtils.getXmlAssinado(xmlToSave, "infDsm", "dsm", certificado);
        String xmlRetorno = this.sisObraServiceUtils.enviarDsmXmlReceitaFederal(xmlToSaveAssinado, certificado);
        this.updateDsmWithXml(dsmToSave, xmlToSave, xmlRetorno);
    }

    private void updateDsmWithXml(SisObraDSM dsm, String xml, String xmlRetorno) {
        dsm.setXmlEnvio(xml.getBytes());
        dsm.setXmlRetorno(xmlRetorno.getBytes());
        this.sisObraDSMRepository.save((Object)dsm);
    }

    public String getDsmXml(SisObraDSM dsm) {
        return SisObraDSMXmlBuilder.buildXmlDsm((SisObraDSM)dsm);
    }

    public Boolean hasDocumentosEmitidosByPeriodo(Long ano, Long mes) {
        LocalDate ultimoDiaDoMes;
        LocalDate primeiroDiaDoMes = LocalDate.of(ano.intValue(), mes.intValue(), 1);
        return !this.documentoRepository.findQuantidadeDocumentosEmitidosByDataInicialAndDataFinal(primeiroDiaDoMes, ultimoDiaDoMes = primeiroDiaDoMes.with(TemporalAdjusters.lastDayOfMonth())).equals(0L);
    }

    @Generated
    public SisObraDSMService(SisObraDSMRepository sisObraDSMRepository, DocumentoRepository documentoRepository, ContextService contextService, SisObraServiceUtils sisObraServiceUtils) {
        this.sisObraDSMRepository = sisObraDSMRepository;
        this.documentoRepository = documentoRepository;
        this.contextService = contextService;
        this.sisObraServiceUtils = sisObraServiceUtils;
    }
}

