/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.rol;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.rol.Rol;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.rol.GeraRolDTO;
import br.com.elotech.tributos.dto.rol.RolDebitoParcelaTributoDTO;
import br.com.elotech.tributos.repository.rol.GeraRolRepository;
import br.com.elotech.tributos.repository.rol.RolRepository;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RolService
extends CrudService<Rol, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RolService.class);
    private final ParametroGeralService parametroGeralService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final FormaPagamentoService formaPagamentoService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final NotificacaoService notificacaoService;
    private final RolRepository rolRepository;
    private final GeraRolRepository geraRolRepository;
    private static final Map<NotificationStatus, String> messagesNotificacao = Map.of(NotificationStatus.STARTED, "Iniciado gera\u00e7\u00e3o do rol de d\u00edvidas", NotificationStatus.COMPLETED, "Conclu\u00eddo gera\u00e7\u00e3o do rol de d\u00edvidas", NotificationStatus.FAILED, "Gera\u00e7\u00e3o do rol de d\u00edvidas falhou");

    @Async
    @Transactional
    public void gerarRolAsync(GeraRolDTO dto, UserSecurityDTO user) {
        log.debug("Criando e persistindo estado inicial do rol de d\u00edvidas, no caso o rol sem os seus d\u00e9bitos. Utilizado os seguintes dados como base de cria\u00e7\u00e3o: {}", (Object)dto);
        Rol rol = this.createRolAndPrepareDTO(dto);
        TarefaAssincronaExecucao tarefaEmExecucao = this.tarefaAssincronaService.createTarefaAssincronaGerarRol(dto.getIdRol());
        UUID idNotificacao = this.notificaCliente(tarefaEmExecucao, null, user, NotificationStatus.STARTED);
        try {
            this.gerarDebitosParcelasTributosPorExercicio(dto);
            this.updateRolDataFim(rol);
            this.stopTarefaAssincrona(tarefaEmExecucao, idNotificacao, user, NotificationStatus.COMPLETED, null);
            log.debug("Finalizado a gera\u00e7\u00e3o do rol de d\u00edvidas");
        }
        catch (Exception ex) {
            log.error("Erro ao realizar rotina de gera\u00e7\u00e3o do rol de d\u00edvidas", (Throwable)ex);
            this.stopTarefaAssincrona(tarefaEmExecucao, idNotificacao, user, NotificationStatus.FAILED, ex);
        }
    }

    private void gerarDebitosParcelasTributosPorExercicio(GeraRolDTO dto) {
        long rows = 0L;
        List exercicios = this.geraRolRepository.findExercicios(dto);
        for (Long exercicio : exercicios) {
            log.debug("Iniciando gera\u00e7\u00e3o dos d\u00e9bitos do rol de d\u00edvidas para o exerc\u00edcio {}", (Object)exercicio);
            long rowsDebitos = this.gerarDebitos(dto, exercicio);
            if (rowsDebitos <= 0L) continue;
            rows += rowsDebitos;
            log.debug("Iniciando gera\u00e7\u00e3o das parcelas do rol de d\u00edvidas para o exerc\u00edcio {}", (Object)exercicio);
            rows += this.gerarParcelas(dto, exercicio);
            log.debug("Iniciando gera\u00e7\u00e3o dos tributos do rol de d\u00edvidas para o exerc\u00edcio {}", (Object)exercicio);
            rows += this.gerarTributos(dto, exercicio);
        }
        this.validateAfterGerarDebitosParcelasTributos(Long.valueOf(rows));
    }

    private void validateAfterGerarDebitosParcelasTributos(Long rows) {
        if (rows < 1L) {
            throw new EloValidationException("N\u00e3o foi gerado nenhum d\u00e9bito/parcela/tributo para o rol. Poss\u00edveis solu\u00e7\u00f5es: 1. O d\u00e9bito deve estar constitu\u00eddo; 2. Data de inclus\u00e3o ou data de contabiliza\u00e7\u00e3o devem ser menor ou igual a data de refer\u00eancia; 3. Deve ser d\u00e9bito/parcela com a situa\u00e7\u00e3o aberta ou a data de situa\u00e7\u00e3o da parcela deve ser maior que a data de refer\u00eancia; 4. Verifique se existe algum d\u00e9bito com o filtro informado.");
        }
    }

    private UUID notificaCliente(TarefaAssincronaExecucao execucao, UUID idNotificacao, UserSecurityDTO user, NotificationStatus status) {
        String titulo = "Gera\u00e7\u00e3o do Rol de D\u00edvidas";
        String message = (String)messagesNotificacao.get(status);
        TarefaAssincrona tarefa = execucao.getTarefaAssincrona();
        return this.notificacaoService.send(titulo, message, tarefa, Optional.ofNullable(idNotificacao), user, status).orElse(null);
    }

    private void stopTarefaAssincrona(TarefaAssincronaExecucao execucao, UUID idNotificacao, UserSecurityDTO user, NotificationStatus status, Exception exception) {
        if (status.equals((Object)NotificationStatus.FAILED)) {
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, exception.getMessage());
        } else {
            this.tarefaAssincronaService.finalizarExecucao(execucao);
        }
        this.notificaCliente(execucao, idNotificacao, user, status);
    }

    private Rol createRolAndPrepareDTO(GeraRolDTO dto) {
        Rol rol = (Rol)this.rolRepository.saveAndFlush((Object)dto.toEntity());
        dto.setIgnorarIntervaloDividas(this.getIgnorarIntervaloDividas());
        dto.setIdRol(rol.getId());
        return rol;
    }

    private List<Long> getIgnorarIntervaloDividas() {
        String ignorarIntervaloDividas = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.ROL_GERACAO_IGNORAR_DIVIDAS, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (StringUtils.isBlank((CharSequence)ignorarIntervaloDividas)) {
            return Collections.emptyList();
        }
        return Arrays.stream(ignorarIntervaloDividas.split(",")).map(String::trim).map(Long::valueOf).collect(Collectors.toList());
    }

    private long gerarDebitos(GeraRolDTO dto, Long exercicio) {
        return this.geraRolRepository.insertDebitos(dto, exercicio);
    }

    private long gerarParcelas(GeraRolDTO dto, Long exercicio) {
        return this.geraRolRepository.insertParcelas(dto, exercicio);
    }

    private long gerarTributos(GeraRolDTO dto, Long exercicio) {
        if (dto.calcularAcrescimos()) {
            return this.gerarTributosComAcrescimos(dto, exercicio);
        }
        return this.geraRolRepository.insertTributosSemAcrescimos(dto, exercicio);
    }

    private long gerarTributosComAcrescimos(GeraRolDTO dto, Long exercicio) {
        FormaPagamento formaPagamentoPadrao = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        ListasNecessariasCalculaAcrescimoDTO listas = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
        Boolean usaCalculoJurosPorExercicio = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.ALIQUOTAJUROSPOREXERCICIO);
        Boolean calculaAcrescimoIndiceCorrecaoValorAtual = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CALC_ACRESCIMO_INDICE_CORRECAO_VALOR_ATUAL);
        String insertValues = this.geraRolRepository.findTributos(dto, exercicio).stream().map(t -> this.calcularAcrescimos(t, listas, formaPagamentoPadrao.getId(), dto.getDataReferencia(), usaCalculoJurosPorExercicio, calculaAcrescimoIndiceCorrecaoValorAtual)).map(RolDebitoParcelaTributoDTO::buildInsertValues).map(RolDebitoParcelaTributoDTO::addComma).reduce(String::concat).map(s -> s.substring(0, s.length() - 1)).orElse("");
        return this.geraRolRepository.insertTributosComAcrescimos(insertValues, exercicio);
    }

    private RolDebitoParcelaTributoDTO calcularAcrescimos(RolDebitoParcelaTributoDTO tributo, ListasNecessariasCalculaAcrescimoDTO listas, Long formaPagamento, LocalDate dataReferencia, Boolean usaCalculoJurosPorExercicio, Boolean calculaAcrescimoIndiceCorrecaoValorAtual) {
        log.debug("Calculando acr\u00e9scimo para o d\u00e9bito/parcela/tributo: {}", (Object)tributo);
        AcrescimoDTO acrescimo = AcrescimoDTO.of((RolDebitoParcelaTributoDTO)tributo, (Long)formaPagamento);
        acrescimo.setDataReferencia(dataReferencia);
        acrescimo.setCalculaValorDesconto(Boolean.FALSE);
        this.calculoAcrescimoService.calculaAcrescimos(acrescimo, Optional.ofNullable(listas), usaCalculoJurosPorExercicio, calculaAcrescimoIndiceCorrecaoValorAtual);
        tributo.setValor(acrescimo.getValor());
        tributo.setValorJuros(acrescimo.getValorJuros());
        tributo.setValorMulta(acrescimo.getValorMulta());
        tributo.setValorCorrecao(acrescimo.getValorCorrecao());
        return tributo;
    }

    private void updateRolDataFim(Rol rol) {
        rol.setDataFim(LocalDate.now());
        this.rolRepository.save((Object)rol);
    }

    @Generated
    public RolService(ParametroGeralService parametroGeralService, CalculoAcrescimoService calculoAcrescimoService, FormaPagamentoService formaPagamentoService, TarefaAssincronaService tarefaAssincronaService, NotificacaoService notificacaoService, RolRepository rolRepository, GeraRolRepository geraRolRepository) {
        this.parametroGeralService = parametroGeralService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.formaPagamentoService = formaPagamentoService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.notificacaoService = notificacaoService;
        this.rolRepository = rolRepository;
        this.geraRolRepository = geraRolRepository;
    }
}

