/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.relatoriogerencial.lancamentoarrecadacao;

import br.com.elotech.tributos.dto.relatoriogerencial.LancamentoArrecadacaoDTO;
import br.com.elotech.tributos.repository.relatoriogerencial.ArrecadacaoAnualRepository;
import br.com.elotech.tributos.repository.relatoriogerencial.LancamentoArrecadacaoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DiaUtilService;
import br.com.elotech.tributos.service.relatoriogerencial.lancamentoarrecadacao.LancamentoArredacacaoJobStarter;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.stereotype.Service;

@Service
public class LancamentoArrecadacaoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LancamentoArrecadacaoService.class);
    private final LancamentoArrecadacaoRepository lancamentoArrecadacaoRepository;
    private final ArrecadacaoAnualRepository arrecadacaoAnualRepository;
    private final DiaUtilService diaUtilService;
    private final ContextService contextService;
    private final LancamentoArredacacaoJobStarter jobStarter;

    public LancamentoArrecadacaoDTO carregaLancamentoArrecadacao(Long entidade, Long exercicio, Long mesAnalise) {
        LocalDate dataInicial = LocalDate.of(exercicio.intValue(), mesAnalise.intValue(), 1);
        LocalDate dataFinal = dataInicial.with(TemporalAdjusters.lastDayOfMonth());
        LocalDate dataInicioAno = LocalDate.of(exercicio.intValue(), 1, 1);
        LocalDate dataLancamentoIptu = this.diaUtilService.diaUtilProximo(dataInicioAno);
        LancamentoArrecadacaoDTO dto = new LancamentoArrecadacaoDTO();
        dto.setEntidade(entidade);
        dto.setExercicio(exercicio);
        dto.setMesAnalise(mesAnalise);
        dto.setUltimoMovimento(LocalDate.now());
        dto.setLancamentoAnual(this.lancamentoArrecadacaoRepository.buscaLancamentoAnual(entidade, exercicio, dataLancamentoIptu));
        BigDecimal totalArrecadadoAno = this.lancamentoArrecadacaoRepository.calculaArrecadacaoTotal(entidade, exercicio, dataInicioAno, dataFinal);
        BigDecimal totalArrecadadoMes = this.lancamentoArrecadacaoRepository.calculaArrecadacaoTotal(entidade, exercicio, dataInicial, dataFinal);
        dto.setSaldoArrecadar(this.lancamentoArrecadacaoRepository.calculaSaldoEmAberto(entidade, exercicio, dataFinal));
        dto.setDesconto(this.lancamentoArrecadacaoRepository.calculaDesconto(entidade, exercicio, dataInicioAno, dataFinal));
        dto.setDescontoMes(this.lancamentoArrecadacaoRepository.calculaDesconto(entidade, exercicio, dataInicial, dataFinal));
        dto.setArrecadacaoAVista(this.lancamentoArrecadacaoRepository.calculaArrecadacaoAVista(entidade, exercicio, dataInicioAno, dataFinal));
        dto.setCreditoAVista(this.lancamentoArrecadacaoRepository.calculaCreditoAVista(entidade, exercicio, dataInicioAno, dataFinal));
        dto.setDescontoArrecadacaoAVista(this.lancamentoArrecadacaoRepository.calculaDescontoArrecadacaoAVista(entidade, exercicio, dataInicioAno, dataFinal));
        dto.setDevolucaoAVista(this.lancamentoArrecadacaoRepository.calculaDevolucaoAVista(entidade, exercicio, dataInicioAno, dataFinal));
        BigDecimal arrecadacaoAVista = dto.getArrecadacaoAVista().add(dto.getCreditoAVista()).subtract(dto.getDescontoArrecadacaoAVista()).subtract(dto.getDevolucaoAVista()).subtract(dto.getDesconto());
        dto.setArrecadacaoAVista(arrecadacaoAVista);
        dto.setArrecadacaoAVistaMes(this.lancamentoArrecadacaoRepository.calculaArrecadacaoAVista(entidade, exercicio, dataInicial, dataFinal));
        dto.setCreditoAVistaMes(this.lancamentoArrecadacaoRepository.calculaCreditoAVista(entidade, exercicio, dataInicial, dataFinal));
        dto.setDescontoArrecadacaoAVistaMes(this.lancamentoArrecadacaoRepository.calculaDescontoArrecadacaoAVista(entidade, exercicio, dataInicial, dataFinal));
        dto.setDevolucaoAVistaMes(this.lancamentoArrecadacaoRepository.calculaDevolucaoAVista(entidade, exercicio, dataInicial, dataFinal));
        BigDecimal arrecadacaoAVistaMes = dto.getArrecadacaoAVistaMes().add(dto.getCreditoAVistaMes()).subtract(dto.getDescontoArrecadacaoAVistaMes()).subtract(dto.getDevolucaoAVistaMes()).subtract(dto.getDescontoMes());
        dto.setArrecadacaoAVistaMes(arrecadacaoAVistaMes);
        totalArrecadadoAno = totalArrecadadoAno.subtract(dto.getDesconto());
        totalArrecadadoMes = totalArrecadadoMes.subtract(dto.getDescontoMes());
        dto.setTotalArrecadado(totalArrecadadoAno);
        dto.setTotalArrecadadoMes(totalArrecadadoMes);
        BigDecimal arrecadacaoParcelado = totalArrecadadoAno;
        BigDecimal arrecadacaoParceladoMes = totalArrecadadoMes;
        dto.setArrecadacaoParcelado(arrecadacaoParcelado);
        dto.setArrecadacaoParceladoMes(arrecadacaoParceladoMes);
        BigDecimal valorArrecadar = arrecadacaoAVista.add(arrecadacaoParcelado).subtract(dto.getSaldoArrecadar());
        dto.setValorArrecadar(valorArrecadar);
        BigDecimal arrecadadoComDesconto = valorArrecadar.add(dto.getDesconto());
        BigDecimal revisao = dto.getLancamentoAnual().subtract(arrecadadoComDesconto);
        BigDecimal revisaoAnterior = this.lancamentoArrecadacaoRepository.buscaValorRevisadoAnterior(entidade, exercicio, mesAnalise);
        dto.setRevisoes(revisao);
        dto.setRevisoesLiquido(revisao.subtract(revisaoAnterior));
        dto.setValorRevisado(arrecadadoComDesconto);
        BigDecimal arrecadadoTotal = arrecadacaoAVista.add(arrecadacaoParcelado);
        dto.setSaldoArrecadar(valorArrecadar.subtract(arrecadadoTotal));
        dto.setQtdeCadastroVista(this.lancamentoArrecadacaoRepository.calculaArrecadadoAVistaCadastro(entidade, exercicio, dataInicial, dataFinal));
        dto.setQtdeCadastroParc(this.lancamentoArrecadacaoRepository.calculaArrecadadoParceladoCadastro(entidade, exercicio, dataInicial, dataFinal));
        dto.setQtdeCadastroParcAno(this.lancamentoArrecadacaoRepository.calculaArrecadadoParceladoCadastro(entidade, exercicio, dataInicioAno, dataFinal));
        dto.setQtdeCadastroLancamento(this.lancamentoArrecadacaoRepository.calculaLancamentoAnualCadastro(entidade, exercicio, dataLancamentoIptu));
        dto.setQtdeCadastroRestanteArrecadar(this.lancamentoArrecadacaoRepository.calculaSaldoEmAbertoCadastro(entidade, exercicio, dataFinal));
        dto.setQtdeCadastroDesconto(this.lancamentoArrecadacaoRepository.calculaArrecadadoAVistaCadastro(entidade, exercicio, dataInicioAno, dataFinal));
        dto.setQtdeCadastroRenuncia(this.lancamentoArrecadacaoRepository.calculaRenunciaCadastro(entidade, exercicio, dataFinal));
        dto.setQtdeCadastroRenunciaZerado(this.lancamentoArrecadacaoRepository.calculaRenunciaCadastroValorZerado(entidade, exercicio, dataFinal));
        dto.setQtdeCadastroCancelado(this.lancamentoArrecadacaoRepository.calculaCancelamentoCadastro(entidade, exercicio, dataFinal));
        return dto;
    }

    public void startJobLancamentoArrecadacao(Long exercicio, Long mesAnalise) {
        Long entidade = this.contextService.getEntidadePrincipal();
        this.jobStarter.startJob(entidade, exercicio, mesAnalise);
    }

    public LancamentoArrecadacaoDTO findResumoLancamentoArrecadacao(Long exercicio) {
        List results = this.arrecadacaoAnualRepository.findResumoLancamentoArrecadacao(this.contextService.getEntidadePrincipal(), exercicio);
        return results.stream().map(result -> {
            LancamentoArrecadacaoDTO dto = new LancamentoArrecadacaoDTO();
            dto.setEntidade(Long.valueOf(((Number)result[0]).longValue()));
            dto.setExercicio(Long.valueOf(((Number)result[1]).longValue()));
            dto.setLancamentoAnual((BigDecimal)result[2]);
            dto.setPrevisaoLancamentoAnual((BigDecimal)result[3]);
            dto.setQtdeCadastroLancamento(Long.valueOf(((Number)result[4]).longValue()));
            dto.setQtdeCadastroRenuncia(Long.valueOf(((Number)result[5]).longValue()));
            dto.setQtdeCadastroRenunciaZerado(Long.valueOf(((Number)result[6]).longValue()));
            dto.setQtdeCadastroCancelado(Long.valueOf(((Number)result[7]).longValue()));
            dto.setQtdeCadastroRestanteArrecadar(Long.valueOf(((Number)result[8]).longValue()));
            dto.setQtdeCadastroDesconto(Long.valueOf(((Number)result[9]).longValue()));
            dto.setLancamentoAnterior((BigDecimal)result[10]);
            dto.setQtdeCadastroParcelado(Long.valueOf(((Number)result[11]).longValue()));
            dto.setUltimoMovimento(((Date)result[12]).toLocalDate());
            dto.setIdJob(Long.valueOf(((Number)result[13]).longValue()));
            BatchStatus status = Objects.nonNull(result[14]) ? BatchStatus.valueOf((String)result[14].toString()) : BatchStatus.UNKNOWN;
            dto.setJobStatus(status);
            dto.setRevisoesAnteriores((BigDecimal)result[15]);
            dto.setDescontoAnterior((BigDecimal)result[16]);
            dto.setArrecadacaoVistaAnterior((BigDecimal)result[17]);
            dto.setArrecadacaoParcelaAnterior((BigDecimal)result[18]);
            dto.setPrevisaoArrecadacaoTotal((BigDecimal)result[19]);
            dto.setQtdeCadastroVista(Long.valueOf(((Number)result[20]).longValue()));
            dto.setRevisoes((BigDecimal)result[21]);
            dto.setDesconto((BigDecimal)result[22]);
            dto.setArrecadacaoAVista((BigDecimal)result[23]);
            dto.setArrecadacaoParcelado((BigDecimal)result[24]);
            dto.setPrevisaoValorRevisado((BigDecimal)result[25]);
            dto.setPrevisaoSaldoArrecadar((BigDecimal)result[26]);
            dto.setPrevisaoRevisoes((BigDecimal)result[27]);
            dto.setPrevisaoDesconto((BigDecimal)result[28]);
            dto.setPrevisaoArrecadacaoVista((BigDecimal)result[29]);
            dto.setPrevisaoArrecadacaoParcelado((BigDecimal)result[30]);
            return dto;
        }).findFirst().orElse(null);
    }

    @Generated
    public LancamentoArrecadacaoService(LancamentoArrecadacaoRepository lancamentoArrecadacaoRepository, ArrecadacaoAnualRepository arrecadacaoAnualRepository, DiaUtilService diaUtilService, ContextService contextService, LancamentoArredacacaoJobStarter jobStarter) {
        this.lancamentoArrecadacaoRepository = lancamentoArrecadacaoRepository;
        this.arrecadacaoAnualRepository = arrecadacaoAnualRepository;
        this.diaUtilService = diaUtilService;
        this.contextService = contextService;
        this.jobStarter = jobStarter;
    }
}

