/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.projeto;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.jpa.support.EloSequenceCache;
import br.com.elotech.core.jpa.support.EloSequenceGenerator;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.projeto.Projeto;
import br.com.elotech.tributos.domain.projeto.ProjetoPK;
import br.com.elotech.tributos.domain.projeto.ProjetoResponsavelPK;
import br.com.elotech.tributos.dto.DebitoCarneDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoProjetoManualDTO;
import br.com.elotech.tributos.dto.EnderecoResumidoResponse;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.IntegracaoProjetoIssResponse;
import br.com.elotech.tributos.dto.PessoaDTO;
import br.com.elotech.tributos.dto.projeto.ProjetoDTO;
import br.com.elotech.tributos.dto.projeto.ProjetoItemGeraDebitoDTO;
import br.com.elotech.tributos.dto.projeto.ProjetoRowDTO;
import br.com.elotech.tributos.repository.projeto.ProjetoDebitoRepository;
import br.com.elotech.tributos.repository.projeto.ProjetoRepository;
import br.com.elotech.tributos.rsql.RsqlCustomVisitor;
import br.com.elotech.tributos.rsql.RsqlSpecification;
import br.com.elotech.tributos.service.CarneService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoCarneService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.exception.projeto.ProjetoNotFoundException;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.util.AgrupaDebitos;
import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ProjetoService
extends CrudService<Projeto, ProjetoPK> {
    private final ContextService contextService;
    private final EloSequenceCache eloSequenceCache;
    private final ProjetoRepository projetoRepository;
    private final ProjetoDebitoRepository projetoDebitoRepository;
    private final DebitoService debitoService;
    private final DebitoCarneService debitoCarneService;
    private final AisePdfService aisePdfService;
    private final CarneService carneService;
    private final ParametroGeralService parametroGeralService;
    private final String FILTRO_DEBITO_CADASTRO_GERAL = "debitos.cadastroGeral";

    protected void beforeSave(Projeto projeto, Authentication authentication) {
        super.beforeSave((EloEntity)projeto, authentication);
        if (Objects.isNull(projeto.getId())) {
            ProjetoPK projetoPK = new ProjetoPK();
            projetoPK.setEntidade(this.contextService.getEntidadePrincipal());
            if (projeto.getNumeroProjeto() != null && projeto.getExercicioProjeto() != null) {
                projetoPK.setExercicio(projeto.getExercicioProjeto());
                projetoPK.setProjeto(projeto.getNumeroProjeto());
                projeto.setId(projetoPK);
            } else {
                projetoPK.setExercicio(this.contextService.getExercicioAtual());
                projeto.setId(projetoPK);
                EloSequenceGenerator.attrNextValues((Object)projeto, (SessionFactory)((SessionFactory)this.getEm().getEntityManagerFactory().unwrap(SessionFactoryImplementor.class)), (EloSequenceCache)this.eloSequenceCache);
            }
            this.validarProjetoExistente(projetoPK, projeto);
        }
        projeto.getItens().forEach(item -> {
            if (Objects.isNull(item.getProjeto())) {
                item.setProjeto(projeto);
            }
        });
        AtomicLong sequencia = new AtomicLong(projeto.getNextSequenciaResponsavel());
        projeto.getResponsaveis().forEach(responsavel -> {
            if (Objects.isNull(responsavel.getId())) {
                ProjetoResponsavelPK projetoResponsavelPK = new ProjetoResponsavelPK();
                projetoResponsavelPK.setEntidade(projeto.getId().getEntidade());
                projetoResponsavelPK.setExercicio(projeto.getId().getExercicio());
                projetoResponsavelPK.setProjeto(projeto.getId().getProjeto());
                projetoResponsavelPK.setSequencia(Long.valueOf(sequencia.getAndIncrement()));
                responsavel.setId(projetoResponsavelPK);
                responsavel.setProjeto(projeto);
            }
        });
        projeto.getObservacoes().forEach(observacao -> {
            if (Objects.isNull(observacao.getProjeto())) {
                observacao.setProjeto(projeto);
            }
        });
    }

    public Page<ProjetoRowDTO> findByRsqlProjetoRowDTOS(String search, Pageable pageable) {
        Page projetos = Objects.nonNull(search) && search.contains("debitos.cadastroGeral") ? this.findDistinctProjetosByRsql(search, pageable) : this.findByRsql(search, pageable);
        return projetos.map(ProjetoRowDTO::from);
    }

    public ProjetoDTO findOneProjetoDTO(ProjetoPK id) {
        return this.findById((Serializable)id).map(ProjetoDTO::from).orElseThrow(() -> new ProjetoNotFoundException(id));
    }

    public List<IntegracaoProjetoIssResponse> findProjetoIntegracao(Long idProcesso, Long exercicio) {
        List projetos = this.projetoRepository.findAllProjetosIntegradosByProcessoAndExercicio(idProcesso, exercicio);
        return projetos.stream().map(arg_0 -> this.mapIntegracaoProjetoIssResponse(arg_0)).collect(Collectors.toList());
    }

    public IntegracaoProjetoIssResponse mapIntegracaoProjetoIssResponse(Projeto projeto) {
        IntegracaoProjetoIssResponse response = new IntegracaoProjetoIssResponse();
        response.setResponsavel(this.setResponsavel(projeto));
        response.setEndereco(this.setEndereco(projeto));
        response.setArt(projeto.getArt());
        response.setExercicio(projeto.getId().getExercicio());
        response.setEntidade(projeto.getId().getEntidade());
        response.setProjeto(projeto.getId().getProjeto());
        response.setOpcaoPagamento(projeto.getOpcaoPagamento().getCodigo());
        return response;
    }

    private PessoaDTO setResponsavel(Projeto projeto) {
        PessoaDTO responsavel = new PessoaDTO();
        responsavel.setNome(projeto.getResponsavel().getNome());
        responsavel.setCnpjCpf(projeto.getResponsavel().getCnpjCpf());
        return responsavel;
    }

    private EnderecoResumidoResponse setEndereco(Projeto projeto) {
        EnderecoResumidoResponse endereco = new EnderecoResumidoResponse();
        CadastroGeral cadastroGeral = projeto.getCadastroGeral();
        endereco.setCep(cadastroGeral.getCep());
        endereco.setNumero(cadastroGeral.getNumero());
        endereco.setComplemento(cadastroGeral.getComplemento());
        Optional.of(cadastroGeral.getBairro()).ifPresent(bairro -> endereco.setBairro(bairro.getDescricao()));
        Optional.of(cadastroGeral.getCidade()).ifPresent(cidade -> {
            endereco.setCidade(cidade.getDescricao());
            endereco.setUnidadeFederacao(cidade.getUnidadeFederacao());
        });
        Optional.of(cadastroGeral.getLogradouro()).ifPresent(logradouro -> {
            endereco.setLogradouro(logradouro.getDescricao());
            Optional.of(logradouro.getTipoLogradouro()).ifPresent(tipo -> endereco.setTipoLogradouro(tipo.getDescricao()));
        });
        return endereco;
    }

    public void validateTipoObra(Projeto projeto) {
        if (projeto.getTipoObra() == null) {
            throw new EloValidationException(String.format("N\u00e3o existe um tipo de obra para o projeto %d do exerc\u00edcio %d. Fa\u00e7a o cadastro para continuar.", projeto.getId().getProjeto(), projeto.getId().getExercicio()));
        }
    }

    public void validateArea(Projeto projeto) {
        if (projeto.getArea() == null || projeto.getArea().compareTo(BigDecimal.ZERO) <= 0) {
            throw new EloValidationException(String.format("A \u00e1rea do projeto %d do exerc\u00edcio %d \u00e9 inv\u00e1lida. Verifique o cadastro.", projeto.getId().getProjeto(), projeto.getId().getExercicio()));
        }
    }

    public ImpressaoDTO geraCarneDebitoProjeto(DebitoIdDTO debitoIdDTO) {
        DebitoCarneDTO debitoCarneDTO = this.getDebitoCarneComFormasPagamento(debitoIdDTO);
        return ImpressaoDTO.from((String)this.aisePdfService.fetchCarne(this.carneService.geraCarne(debitoCarneDTO).getNumeroCarne()));
    }

    public DebitoCarneDTO getDebitoCarneComFormasPagamento(DebitoIdDTO debitoIdDTO) {
        Debito debito = (Debito)this.debitoService.findOne((Serializable)debitoIdDTO.getIdDebito());
        DebitoCarneDTO debitoCarneDTO = DebitoCarneDTO.from((Debito)debito);
        List formasPagamento = this.debitoCarneService.findAllDebitoAgrupadoPorFormaPagamentoDisponivelWeb(debitoCarneDTO.getIdDebito());
        debitoCarneDTO.setFormasPagamento(AgrupaDebitos.agrupaDebitosPorDebitoEFormaPagamento((List)formasPagamento));
        return debitoCarneDTO;
    }

    public Page<Projeto> findDistinctProjetosByRsql(String search, Pageable pageable) {
        RSQLParser parser = new RSQLParser();
        Specification specification = Optional.ofNullable(search).filter(s -> !s.trim().isEmpty()).map(arg_0 -> ((RSQLParser)parser).parse(arg_0)).map(node -> (Specification)node.accept((RSQLVisitor)new RsqlCustomVisitor())).map(RsqlSpecification::new).orElse(null);
        PageRequest pageableSemSort = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize());
        return this.projetoRepository.findAll(specification, (Pageable)pageableSemSort);
    }

    public void validarProjetoExistente(ProjetoPK projetoPK, Projeto projeto) {
        Optional<Projeto> projetoExistente = Optional.ofNullable((Projeto)this.projetoRepository.findOne((Object)projetoPK));
        String mensagemAlerta = this.builderMensagemValidacao(projetoPK, projeto);
        projetoExistente.ifPresent(projetoAtual -> {
            throw new EloValidationException(mensagemAlerta);
        });
    }

    private String builderMensagemValidacao(ProjetoPK projetoPK, Projeto projeto) {
        StringBuilder mensagem = new StringBuilder(String.format("J\u00e1 existe um projeto de n\u00famero %d para o ano %d .", projetoPK.getProjeto(), projetoPK.getExercicio()));
        if (projeto.getNumeroProjeto() != null && projeto.getExercicioProjeto() != null) {
            mensagem.append("\nVerifique o n\u00famero e o exerc\u00edcio informado para o projeto.");
        } else {
            mensagem.append("\nTente novamente.");
        }
        return mensagem.toString();
    }

    public void updateDadosProjeto(DebitoProjetoManualDTO request) {
        ProjetoPK projetoId = request.getProjetoId();
        Projeto projeto = (Projeto)this.findById((Serializable)projetoId).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado o projeto %s/%s", projetoId.getProjeto(), projetoId.getExercicio())));
        this.validateProjeto(projeto);
        this.setDadosDoProjetoNaGeracaoDeDebito(request, projeto);
    }

    private void validateProjeto(Projeto projeto) {
        this.validateTipoObra(projeto);
        this.validateArea(projeto);
    }

    private void setDadosDoProjetoNaGeracaoDeDebito(DebitoProjetoManualDTO dto, Projeto projeto) {
        dto.setProjetoEntity(projeto);
        if (this.usaDadosProjetoParaGeracaoDeDebito()) {
            dto.setCadastroGeral(projeto.getCadastroGeral().getCadastroGeral());
            dto.setTipoCadastro(projeto.getCadastroGeral().getTipoCadastro());
        }
    }

    private boolean usaDadosProjetoParaGeracaoDeDebito() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.USA_CADASTRO_PROJETO_GERACAO_DEBITO);
    }

    public List<ProjetoItemGeraDebitoDTO> getProjetoItensByProjetoPK(ProjetoPK projetoPK) {
        Projeto projeto = (Projeto)this.findById((Serializable)projetoPK).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado o projeto %s/%s", projetoPK.getProjeto(), projetoPK.getExercicio())));
        return projeto.getItens().stream().map(ProjetoItemGeraDebitoDTO::from).collect(Collectors.toList());
    }

    @Generated
    public ProjetoService(ContextService contextService, EloSequenceCache eloSequenceCache, ProjetoRepository projetoRepository, ProjetoDebitoRepository projetoDebitoRepository, DebitoService debitoService, DebitoCarneService debitoCarneService, AisePdfService aisePdfService, CarneService carneService, ParametroGeralService parametroGeralService) {
        this.contextService = contextService;
        this.eloSequenceCache = eloSequenceCache;
        this.projetoRepository = projetoRepository;
        this.projetoDebitoRepository = projetoDebitoRepository;
        this.debitoService = debitoService;
        this.debitoCarneService = debitoCarneService;
        this.aisePdfService = aisePdfService;
        this.carneService = carneService;
        this.parametroGeralService = parametroGeralService;
    }
}

