/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaogatewayprocessos;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.keycloakmultirealm.resolver.KeycloakResolver;
import br.com.elotech.multitenant.context.HeaderContextHolder;
import br.com.elotech.tributos.service.ContextService;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class IntegracaoProcessoSeiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoProcessoSeiService.class);
    private final RestTemplate restTemplate;
    private final ConfigurableEnvironment environment;
    private final ContextService contextService;
    private final KeycloakResolver keycloakResolver;

    private String buildUrl(String processoSei) {
        String baseUrl = this.environment.getProperty("eureka-host");
        return UriComponentsBuilder.fromHttpUrl((String)baseUrl).path("/gateway-processos-api/api/processos-sei").queryParam("idEntidade", new Object[]{this.contextService.getEntidadePrincipal()}).queryParam("identificadorProcesso", new Object[]{processoSei}).build(true).toUri().toString();
    }

    public JsonNode findProcessoSei(String processoSei) {
        JsonNode response;
        log.debug("Iniciando comunica\u00e7\u00e3o com a API do Gateway de Processos para o ProcessoSEI: {}", (Object)processoSei);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", String.format("Bearer %s", this.keycloakResolver.getKeycloak().tokenManager().grantToken().getToken()));
        headers.set("X-FORWARDED-HOST", (String)HeaderContextHolder.getHeaders().get("X-FORWARDED-HOST"));
        String urlRequest = this.buildUrl(processoSei);
        try {
            log.debug("Realizando comunica\u00e7\u00e3o com a API do Gateway de Processos request: {}", (Object)urlRequest);
            response = (JsonNode)this.restTemplate.exchange(urlRequest, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), JsonNode.class, new Object[0]).getBody();
        }
        catch (RestException e) {
            if (e.getStatus().equals((Object)HttpStatus.BAD_REQUEST)) {
                throw new RestException(HttpStatus.NOT_FOUND, String.format("ProcessoSEI %s n\u00e3o localizado.", processoSei), (Throwable)e);
            }
            log.error("Ocorreu um erro ao se comunicar com a API do Gateway de Processos: ", (Throwable)e);
            throw new RestException(e.getStatus(), String.format("Erro ao localizar o ProcessoSEI %s: %s", processoSei, e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            log.error("Ocorreu uma exception ao verificar o ProcessoSEI: ", (Throwable)e);
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Ocorreu uma exception ao verificar o ProcessoSEI %s: %s", processoSei, e.getMessage()), (Throwable)e);
        }
        log.debug("Finalizando comunica\u00e7\u00e3o com a API do Gateway de Processos para o ProcessoSEI: {}", (Object)processoSei);
        return response;
    }

    @Generated
    public IntegracaoProcessoSeiService(RestTemplate restTemplate, ConfigurableEnvironment environment, ContextService contextService, KeycloakResolver keycloakResolver) {
        this.restTemplate = restTemplate;
        this.environment = environment;
        this.contextService = contextService;
        this.keycloakResolver = keycloakResolver;
    }
}

