/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.sicredi;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.BoletoDebitoID;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.MovimentacaoDiariaId;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.TipoArquivoRetornoPagamento;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import br.com.elotech.tributos.domain.TipoOperacaoDebito;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoDetalhe;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoLog;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.pagamento.TipoPagamentoLote;
import br.com.elotech.tributos.domain.tipomensagem.ClassificacaoTipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.enums.TipoConvenioWebHook;
import br.com.elotech.tributos.dto.pagamento.ImportacaoPixPagoResultadoDTO;
import br.com.elotech.tributos.dto.pagamento.solicitacaopagamento.SolicitacaoPagamentoDTO;
import br.com.elotech.tributos.dto.sicredi.SicrediPixCertificado;
import br.com.elotech.tributos.dto.sicredi.dto.ContratoWebHookRequestDTO;
import br.com.elotech.tributos.dto.sicredi.dto.ContratoWebHookResponseDTO;
import br.com.elotech.tributos.dto.sicredi.dto.ContratoWebHookResponseErrorDTO;
import br.com.elotech.tributos.dto.sicredi.dto.SicrediDadosWebHookDTO;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoPixPagoLogRepository;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.TipoMensagemService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPixPagoService;
import br.com.elotech.tributos.service.integracaoboleto.sicredi.AutenticacaoSicrediService;
import br.com.elotech.tributos.service.integracaoboleto.sicredi.SicrediPixPagoService;
import br.com.elotech.tributos.util.AmbienteUtils;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class SicrediPixPagoService
implements IntegracaoPixPagoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SicrediPixPagoService.class);
    private static final DateTimeFormatter FORMATO_NOME_ARQUIVO = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    private static final DateTimeFormatter DATE_FORMATTER_BR = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DATE_TIME_FORMATTER_BR = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    private static final String HEADER_API_KEY = "x-api-key";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_AUTHORIZATION_BEARER = "Bearer %s";
    private static final String URL_GET_WEB_HOOK = "/cobranca/boleto/v1/webhook/contratos/";
    private static final String URL_CONTRATOS_WEB_HOOK = "/cobranca/boleto/v1/webhook/contrato/";
    private static final String QUERY_PARAM_COOPERATIVA = "cooperativa";
    private static final String QUERY_PARAM_POSTO = "posto";
    private static final String QUERY_PARAM_BENEFICIARIO = "beneficiario";
    private static final String URL_WEBHOOK_ELOTECH = "%s/api/integracao-boleto/%d/webhook/pix";
    private static final String WEBHOOK_STATUS_ATIVO = "ATIVO";
    private static final String WEBHOOK_STATUS_INATIVO = "INATIVO";
    private static final String WEBHOOK_BODY = "webhookUrl";
    private final PagamentoLoteService pagamentoLoteService;
    private final ContextService contextService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;
    private final BloquetoService boletoService;
    private final BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;
    private final ParametroGeralService parametroGeralService;
    private final ParametroPixRepository parametroPixRepository;
    private final TipoMensagemService tipoMensagemService;
    private final IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final DebitoParcelaService debitoParcelaService;
    private final ConfigurableEnvironment environment;
    private final AutenticacaoSicrediService autenticacaoSicrediService;
    private final RestTemplate restTemplate;

    public Boolean accept(Convenio convenio) {
        return Banco.CODIGO_SICREDI.equals(convenio.getBanco().getId());
    }

    public ImportacaoPixPagoResultadoDTO importarPixPago(Convenio convenio, LocalDate dataReferencia) {
        throw new EloValidationException("Integra\u00e7\u00e3o para receber pix pagos para o banco Sciredi n\u00e3o implementada.");
    }

    public SolicitacaoPagamentoDTO solicitarArquivoPagamento(Convenio convenio, LocalDate dataReferencia) {
        throw new EloValidationException("Integra\u00e7\u00e3o para solicitar arquivo de pagamento para o banco Sicredi n\u00e3o implementada.");
    }

    public List<ImportacaoPixPagoResultadoDTO> importarSolicitacaoPagamento(Convenio convenio, LocalDate dataReferencia, Long codigoSolicitacao) {
        return List.of();
    }

    private void salvarItensGerados(List<BaixaAutomaticaDetalhe> itensGerados, PagamentoLote lote, AtomicLong sequencia) {
        itensGerados.forEach(baixaAutomaticaDetalhe -> {
            BaixaAutomaticaDetalheId id = new BaixaAutomaticaDetalheId();
            id.setSequenciaArquivo(Long.valueOf(sequencia.incrementAndGet()));
            id.setLote(lote.getId().getLote());
            id.setEntidade(lote.getId().getEntidade());
            id.setExercicio(lote.getId().getExercicio());
            baixaAutomaticaDetalhe.setId(id);
            baixaAutomaticaDetalhe.setPagamentoLote(lote);
            baixaAutomaticaDetalhe.setDataCredito(lote.getDataCredito());
            baixaAutomaticaDetalhe.setDataPagamento(lote.getDataMovimento());
            baixaAutomaticaDetalhe.setContaBancaria(lote.getContaBancaria());
            baixaAutomaticaDetalhe.setConvenio(lote.getConvenio());
            baixaAutomaticaDetalhe.setBanco(lote.getBanco());
            this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        });
        Long numeroBaixasAtual = Optional.ofNullable(lote.getNumeroBaixas()).orElse(0L);
        lote.setNumeroBaixas(Long.valueOf(numeroBaixasAtual + (long)itensGerados.size()));
    }

    private void saveLog(IntegracaoPixPagoLog integracaoPixPagoLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoPixPagoLog)this.integracaoPixPagoLogRepository.save((Object)integracaoPixPagoLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    private List<BaixaAutomaticaDetalhe> processarPixPagos(List<SicrediDadosWebHookDTO> pixPagos, IntegracaoPixPagoLog integracaoPixPagoLog) {
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.IMPORTADO);
        log.debug("processarPixPagos " + pixPagos.size());
        return pixPagos.stream().map(pix -> {
            IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
            integracaoPixPagoLog.getDetalhes().add(detalhe);
            try {
                log.debug("Vai Recuperar o bloqueto " + pix.getNossoNumero());
                Bloqueto boleto = this.getBloqueto(pix, detalhe);
                if (Objects.isNull(boleto)) {
                    detalhe.setObservacao("Boleto n\u00e3o encontrado.");
                    return null;
                }
                detalhe.setBoleto(boleto.getBloqueto());
                detalhe.setExercicioboleto(boleto.getExercicioBloqueto());
                detalhe.setEntidade(boleto.getEntidade());
                if (this.baixaAutomaticaDetalheService.existsByBoleto(boleto)) {
                    detalhe.setObservacao("Boleto j\u00e1 importado.");
                    return null;
                }
                if (pix.getValor() == null) {
                    detalhe.setObservacao("Valor Pago recebido pela integra\u00e7\u00e3o esta nullo.");
                    return null;
                }
                detalhe.setObservacao("Boleto importado com sucesso.");
                BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = new BaixaAutomaticaDetalhe();
                baixaAutomaticaDetalhe.setBoleto(boleto);
                baixaAutomaticaDetalhe.setNossoNumero(boleto.getNossoNumero());
                baixaAutomaticaDetalhe.setSituacao(ClassificacaoTipoMensagem.IMPORTADO);
                baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.IMPORTADO.getDescricao());
                baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
                baixaAutomaticaDetalhe.setDataVencimento(boleto.getDataVencimento());
                baixaAutomaticaDetalhe.setDataCreditoArquivo(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setDataPagamentoArquivo(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setDiferencaEmValor(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setDiferencaMaxima(BigDecimal.ZERO);
                baixaAutomaticaDetalhe.setAlterado(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setDescontoConcedido(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setCreditoConcedido(Boolean.valueOf(false));
                baixaAutomaticaDetalhe.setValor(BigDecimal.ZERO);
                baixaAutomaticaDetalhe.setValorPago(pix.getValor());
                baixaAutomaticaDetalhe.setValorPagoPrincipal(pix.getValor());
                baixaAutomaticaDetalhe.setValorPagoJuros(BigDecimal.ZERO);
                baixaAutomaticaDetalhe.setValorPagoMulta(BigDecimal.ZERO);
                baixaAutomaticaDetalhe.setTipoOperacao(TipoOperacaoDebito.NENHUMA_OPERACAO);
                return baixaAutomaticaDetalhe;
            }
            catch (Exception ex) {
                detalhe.setMensagemErro(ex.toString());
                log.error("Ocorreu um erro ao processar pix pagos ", (Object)ex.getMessage(), (Object)ex);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private PagamentoLote getPagamentoLote(Convenio convenio, LocalDate dataReferencia, Long entidade, ImportacaoPixPagoResultadoDTO resultado, String nomeArquivo) {
        this.validaMovimentacao(entidade, dataReferencia);
        Optional loteJaExistente = this.pagamentoLoteService.findAbertoByConvenioAndData(convenio, dataReferencia);
        resultado.setLoteNovo(Boolean.valueOf(loteJaExistente.isEmpty()));
        return loteJaExistente.orElseGet(() -> this.createPagamentoLote(convenio, entidade, dataReferencia, nomeArquivo));
    }

    private void validaMovimentacao(Long entidade, LocalDate dataReferencia) {
        MovimentacaoDiariaId movimentacaoDiariaId = new MovimentacaoDiariaId();
        movimentacaoDiariaId.setEntidade(entidade);
        movimentacaoDiariaId.setData(dataReferencia);
        this.validaDataMovimentacaoService.verificaMovimentacaoDiaria(movimentacaoDiariaId);
    }

    private PagamentoLote createPagamentoLote(Convenio convenio, Long entidade, LocalDate dataReferencia, String nomeArquivo) {
        Long exercicio = this.contextService.getExercicioAtual();
        PagamentoLoteId id = new PagamentoLoteId();
        id.setEntidade(entidade);
        id.setExercicio(exercicio);
        PagamentoLote pagamentoLote = new PagamentoLote();
        pagamentoLote.setId(id);
        pagamentoLote.setDataLote(LocalDate.now());
        pagamentoLote.setDataMovimento(dataReferencia);
        pagamentoLote.setDataCredito(dataReferencia);
        pagamentoLote.setSituacao(SituacaoPagamentoLote.ABERTO);
        pagamentoLote.setTipo(TipoPagamentoLote.PIX);
        pagamentoLote.setConvenio(convenio);
        pagamentoLote.setContaBancaria(convenio.getContaBancaria());
        pagamentoLote.setBanco(convenio.getBanco());
        pagamentoLote.setArquivoRetorno(Boolean.FALSE);
        pagamentoLote.setLoteManual(Boolean.FALSE);
        pagamentoLote.setNumeroBaixas(Long.valueOf(0L));
        pagamentoLote.setTipoArquivo(TipoArquivoRetornoPagamento.RETORNO_PIX);
        pagamentoLote.setObservacao("Lote gerado pela importa\u00e7\u00e3o de pix");
        pagamentoLote.setNomeArquivo(nomeArquivo);
        return (PagamentoLote)this.pagamentoLoteService.save((EloEntity)pagamentoLote, null);
    }

    private String getNomeArquivoPixPago(Long convenio, LocalDate dataReferencia) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime dataReferenciaComHoraAtual = dataReferencia.atTime(now.getHour(), now.getMinute(), now.getSecond());
        return String.format("importacao_pix_%d_%s", convenio, FORMATO_NOME_ARQUIVO.format(dataReferenciaComHoraAtual));
    }

    private String getParametro(ParametroGeralEnum parametroGeralEnum) {
        try {
            String parametroInformado = this.parametroGeralService.getParamValueAsString(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (Objects.isNull(parametroInformado) || StringUtils.isEmpty((String)parametroInformado)) {
                throw new ParametroNaoEncontradoException(parametroGeralEnum.getDescricao());
            }
            return parametroInformado;
        }
        catch (ParametroNaoEncontradoException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    public IntegracaoPixPagoLog processarPixPagosWebHook(JsonNode pixPagos, Convenio convenio, IntegracaoPixPagoLog integracaoPixPagoLog) {
        if (!Boolean.TRUE.equals(convenio.getUtilizaPix()) || !Banco.CODIGO_SICREDI.equals(convenio.getBanco().getId())) {
            throw new EloValidationException(String.format("Banco %s com conv\u00eanio %d n\u00e3o possui PIX", convenio.getBanco().getDescricao(), convenio.getId()));
        }
        log.debug("Chegou para processar os pixPagos do Sicredi. JSON " + pixPagos.asText());
        Long entidade = this.contextService.getEntidadePrincipal();
        List listDadosWebHookDTO = SicrediDadosWebHookDTO.from((JsonNode)pixPagos);
        LocalDate dataReferencia = this.getDataReferencia((SicrediDadosWebHookDTO)listDadosWebHookDTO.get(0));
        log.debug("Data de Refer\u00eancia " + dataReferencia);
        integracaoPixPagoLog.setDataReferencia(dataReferencia);
        integracaoPixPagoLog.setQuantidadeRegistros(Integer.valueOf(listDadosWebHookDTO.size()));
        ArrayList baixaAutomaticaDetalhes = new ArrayList();
        log.debug("Cria Lote PIX " + convenio.getCriarLotePgtPix());
        if (Boolean.TRUE.equals(convenio.getCriarLotePgtPix())) {
            this.processarLotePagamentoPix(convenio, integracaoPixPagoLog, baixaAutomaticaDetalhes, listDadosWebHookDTO, dataReferencia, entidade);
        } else {
            this.processarPixPago(listDadosWebHookDTO, integracaoPixPagoLog);
        }
        return integracaoPixPagoLog;
    }

    private Bloqueto getBloqueto(SicrediDadosWebHookDTO pix, IntegracaoPixPagoDetalhe detalhe) {
        if (pix.getSicrediTipoConvenioWebHook() == null) {
            detalhe.setObservacao("Recebimento do webHook n\u00e3o possui a tag para os conv\u00eanios esperados.");
            return null;
        }
        Optional bloqueto = Optional.empty();
        Object dadosBusca = "";
        log.debug("Vai recuperar o bloqueto.Tipo de conv\u00eanio " + pix.getSicrediTipoConvenioWebHook());
        switch (1.$SwitchMap$br$com$elotech$tributos$dto$enums$TipoConvenioWebHook[pix.getSicrediTipoConvenioWebHook().ordinal()]) {
            case 1: {
                this.detalheCobranca(pix, detalhe);
                if (StringUtils.isBlank((String)pix.getNossoNumero())) {
                    detalhe.setObservacao("N\u00e3o foi poss\u00edvel encontrar o Nosso N\u00famero do pagamento Pix.");
                    return null;
                }
                log.debug("NOSSO NUMERO da cobran\u00e7a " + pix.getNossoNumero());
                bloqueto = this.boletoService.findByNossoNumero(pix.getNossoNumero().trim());
                if (!bloqueto.isEmpty()) break;
                log.debug("Bloqueto n\u00e3o econtrado para o NOSSONUMERO " + pix.getNossoNumero());
                dadosBusca = "NOSSONUMERO: " + pix.getNossoNumero();
                break;
            }
            case 2: {
                this.detalheArrecadacao(pix, detalhe);
                if (StringUtils.isBlank((String)detalhe.getTxid())) {
                    detalhe.setObservacao("N\u00e3o foi poss\u00edvel encontrar o Txid do pagamento Pix.");
                    return null;
                }
                log.debug("TXID da arrecada\u00e7\u00e3o " + pix.getTxid());
                bloqueto = this.boletoService.findByTxid(detalhe.getTxid());
                if (!bloqueto.isEmpty()) break;
                log.debug("Bloqueto n\u00e3o econtrado para o TXID " + pix.getTxid());
                dadosBusca = "TXID: " + detalhe.getTxid();
                break;
            }
            default: {
                detalhe.setObservacao("Tipo de conv\u00eanio n\u00e3o reconhecido.");
                return null;
            }
        }
        if (bloqueto.isEmpty()) {
            detalhe.setObservacao("N\u00e3o foi poss\u00edvel encontrar o boleto com os dados fornecidos." + (String)dadosBusca);
            return null;
        }
        Bloqueto encontrado = (Bloqueto)bloqueto.get();
        detalhe.setBoleto(encontrado.getBloqueto());
        detalhe.setExercicioboleto(encontrado.getExercicioBloqueto());
        detalhe.setEntidade(encontrado.getEntidade());
        log.debug("Bloqueto encontrado  " + encontrado.getBloqueto());
        return encontrado;
    }

    private void detalheCobranca(SicrediDadosWebHookDTO pix, IntegracaoPixPagoDetalhe detalhe) {
        detalhe.setTxid(pix.getNossoNumero());
        detalhe.setBuscaPorE2E(Boolean.FALSE);
    }

    private void detalheArrecadacao(SicrediDadosWebHookDTO pix, IntegracaoPixPagoDetalhe detalhe) {
        detalhe.setE2eid(pix.getEndToEndId());
        detalhe.setTxid(pix.getTxid());
        detalhe.setBuscaPorE2E(Boolean.FALSE);
    }

    private void processarLotePagamentoPix(Convenio convenio, IntegracaoPixPagoLog integracaoPixPagoLog, List<BaixaAutomaticaDetalhe> baixaAutomaticaDetalhes, List<SicrediDadosWebHookDTO> sicrediPixPagos, LocalDate dataReferencia, Long entidade) {
        try {
            baixaAutomaticaDetalhes.addAll(this.processarPixPagos(sicrediPixPagos, integracaoPixPagoLog));
            if (!baixaAutomaticaDetalhes.isEmpty()) {
                PagamentoLote lote = this.getPagamentoLote(convenio, dataReferencia, entidade, new ImportacaoPixPagoResultadoDTO(), this.getNomeArquivoPixPago(convenio.getConvenio(), dataReferencia));
                AtomicLong sequencia = new AtomicLong(this.baixaAutomaticaDetalheService.getUltimaSequenciaLote(lote.getId()));
                this.salvarItensGerados(baixaAutomaticaDetalhes, lote, sequencia);
                integracaoPixPagoLog.setQuantidadeBaixasGeradas(Integer.valueOf(baixaAutomaticaDetalhes.size()));
            }
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            integracaoPixPagoLog.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.saveLog(integracaoPixPagoLog);
        }
    }

    private String getUrlWebHookElotech(Convenio convenio) {
        String urlWebHook = String.format(URL_WEBHOOK_ELOTECH, AmbienteUtils.getCurrentURL((ConfigurableEnvironment)this.environment), convenio.getId());
        return urlWebHook;
    }

    public void togglePixBoletoPagoWebhook(Convenio convenio) {
        this.getWebHook(convenio);
    }

    private void processarPixPago(List<SicrediDadosWebHookDTO> sicrediPixPagos, IntegracaoPixPagoLog log) {
        try {
            sicrediPixPagos.forEach(pix -> {
                IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
                Bloqueto bloqueto = this.getBloqueto(pix, detalhe);
                if (Objects.isNull(bloqueto)) {
                    log.getDetalhes().add(detalhe);
                    return;
                }
                bloqueto.getDebitos().stream().map(BoletoDebito::getId).map(BoletoDebitoID::getDebitoParcelaTributo).map(DebitoParcelaTributo::getDebitoParcela).distinct().forEach(arg_0 -> ((DebitoParcelaService)this.debitoParcelaService).pagarParcelaWebHookPix(arg_0));
                log.getDetalhes().add(detalhe);
            });
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            log.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.saveLog(log);
        }
    }

    public LocalDate getDataReferencia(SicrediDadosWebHookDTO dadosWebHookDTO) {
        String dataReferencia = Optional.ofNullable(dadosWebHookDTO.getDataReferencia()).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel obter a data de refer\u00eancia dos pix pagos."));
        try {
            if (dataReferencia.contains(".")) {
                dataReferencia = dataReferencia.substring(0, dataReferencia.indexOf(46));
            }
            if (dadosWebHookDTO.getSicrediTipoConvenioWebHook().equals((Object)TipoConvenioWebHook.COBRANCA_SICREDI)) {
                return LocalDate.parse(dataReferencia, DATE_FORMATTER_BR);
            }
            LocalDateTime localDateTime = LocalDateTime.parse(dataReferencia, DATE_TIME_FORMATTER_BR);
            return localDateTime.toLocalDate();
        }
        catch (DateTimeParseException e) {
            throw new EloValidationException("Erro ao converter a data de refer\u00eancia: " + e.getMessage());
        }
    }

    public void getWebHook(Convenio convenio) {
        if (convenio.getTipoCodigoBarras().equals((Object)TipoCodigoBarras.BOLETO_BANCARIO_SICRED_CNAB240_COM_REGISTRO)) {
            this.webHookCobranca(convenio);
        } else {
            this.webHookArrecadacaoPix(convenio);
        }
    }

    public void webHookCobranca(Convenio convenio) {
        String apiUrl = this.getParametro(ParametroGeralEnum.BOLETO_SICREDI_API_PIX_URL);
        String sicrediToken = this.getParametro(ParametroGeralEnum.BOLETO_SICREDI_TOKEN);
        String accessToken = this.autenticacaoSicrediService.getAccessToken(apiUrl, convenio.getNumeroConvenio(), convenio.getContaBancaria().getAgencia().getAgencia());
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        httpHeaders.set(HEADER_AUTHORIZATION, String.format(HEADER_AUTHORIZATION_BEARER, accessToken));
        httpHeaders.set(HEADER_API_KEY, sicrediToken);
        String getUrlContratoWebHook = this.buildUrlWebHook(apiUrl, convenio);
        try {
            ContratoWebHookResponseDTO contratoWebHookResponseDTO = (ContratoWebHookResponseDTO)this.restTemplate.exchange(getUrlContratoWebHook, HttpMethod.GET, new HttpEntity(null, (MultiValueMap)httpHeaders), ContratoWebHookResponseDTO.class, new Object[0]).getBody();
            if (contratoWebHookResponseDTO.getIdContrato() == null) {
                throw new EloValidationException(String.format("Id do contrato de WEBHOOK n\u00e3o presente no retorno do webHook", new Object[0]));
            }
            String status = this.setWebhookStatus(contratoWebHookResponseDTO.getContratoStatus());
            this.atualizarWebHookArrecadacao(convenio, httpHeaders, apiUrl, status, contratoWebHookResponseDTO);
        }
        catch (RestException ex) {
            this.handleWebhookArrecadacao(convenio, httpHeaders, ex);
        }
    }

    private URI buildWebhookURI(Convenio convenio) {
        Object baseUrl = this.getParametro(ParametroGeralEnum.PIX_SICREDI_URL);
        if (baseUrl != null) {
            baseUrl = ((String)baseUrl).trim().replaceAll("\\s+", "");
            baseUrl = (String)baseUrl + "api/v2/webhook/";
        }
        return UriComponentsBuilder.fromHttpUrl((String)baseUrl).path("/" + convenio.getChavePix()).build().toUri();
    }

    private SicrediPixCertificado builderCertificado(Convenio convenio) {
        ParametroPix parametroPix = this.parametroPixRepository.getByEntidade(convenio.getEntidade());
        return SicrediPixCertificado.builder().certificado((byte[])Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoSicredi).orElse(null)).senhaCertificado((String)Optional.ofNullable(parametroPix).map(ParametroPix::getSenhaCertificadoSicredi).orElse(null)).nomeArquivoCertificado((String)Optional.ofNullable(parametroPix).map(ParametroPix::getNomeArquivoCertificadoSicredi).orElse(null)).build();
    }

    public HttpHeaders buildHeaderWebHokCertificado(Convenio convenio) {
        SicrediPixCertificado sicrediPixCertificado = this.builderCertificado(convenio);
        String accessToken = this.autenticacaoSicrediService.getAccessTokenWithCertificate(sicrediPixCertificado.getCertificado(), sicrediPixCertificado.getSenhaCertificado(), sicrediPixCertificado.getNomeArquivoCertificado());
        HttpHeaders headersRequest = new HttpHeaders();
        headersRequest.setContentType(MediaType.APPLICATION_JSON);
        headersRequest.set(HEADER_AUTHORIZATION, String.format(HEADER_AUTHORIZATION_BEARER, accessToken));
        return headersRequest;
    }

    public void webHookArrecadacaoPix(Convenio convenio) {
        boolean status;
        HttpHeaders headersRequest = this.buildHeaderWebHokCertificado(convenio);
        SicrediPixCertificado sicrediPixCertificado = this.builderCertificado(convenio);
        boolean bl = status = convenio.getWebhookPixAtivo() == false;
        if (status) {
            this.activePixWebhook(convenio, sicrediPixCertificado, headersRequest);
        } else {
            this.deactivatePixWebhook(convenio, sicrediPixCertificado, headersRequest);
        }
    }

    private void activePixWebhook(Convenio convenio, SicrediPixCertificado sicrediPixCertificado, HttpHeaders headersRequest) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put(WEBHOOK_BODY, this.getUrlWebHookElotech(convenio));
        this.getRestTemplate(sicrediPixCertificado).exchange(this.buildWebhookURI(convenio), HttpMethod.PUT, new HttpEntity(body, (MultiValueMap)headersRequest), JsonNode.class);
    }

    private void deactivatePixWebhook(Convenio convenio, SicrediPixCertificado sicrediPixCertificado, HttpHeaders headersRequest) {
        this.getRestTemplate(sicrediPixCertificado).exchange(this.buildWebhookURI(convenio), HttpMethod.DELETE, new HttpEntity(null, (MultiValueMap)headersRequest), JsonNode.class);
    }

    private String buildUrlWebHook(String apiUrl, Convenio convenio) {
        return UriComponentsBuilder.fromHttpUrl((String)apiUrl).path(URL_GET_WEB_HOOK).queryParam(QUERY_PARAM_COOPERATIVA, new Object[]{convenio.getContaBancaria().getAgencia().getAgencia()}).queryParam(QUERY_PARAM_POSTO, new Object[]{convenio.getCodigoPosto()}).queryParam(QUERY_PARAM_BENEFICIARIO, new Object[]{convenio.getNumeroConvenio()}).build().toString();
    }

    private String setWebhookStatus(String statusContrato) {
        return WEBHOOK_STATUS_INATIVO.equals(statusContrato) ? WEBHOOK_STATUS_ATIVO : WEBHOOK_STATUS_INATIVO;
    }

    private void handleWebhookArrecadacao(Convenio convenio, HttpHeaders httpHeaders, RestException ex) {
        if (ex.getStatus() != HttpStatus.NOT_FOUND) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, "Erro ao buscar as informa\u00e7\u00f5es do WebHook.", (Throwable)ex);
        }
        this.cadastrarWebHookArrecadacao(convenio, httpHeaders, WEBHOOK_STATUS_ATIVO);
    }

    private void cadastrarWebHookArrecadacao(Convenio convenio, HttpHeaders httpHeaders, String status) {
        String apiUrl = this.getParametro(ParametroGeralEnum.BOLETO_SICREDI_API_PIX_URL);
        String urlWebHook = this.getUrlWebHookElotech(convenio);
        ContratoWebHookRequestDTO request = ContratoWebHookRequestDTO.from((Convenio)convenio, (String)urlWebHook, (String)status);
        String urlCadastroContratoWebHook = String.format("%s%s", apiUrl, URL_CONTRATOS_WEB_HOOK);
        try {
            ContratoWebHookResponseDTO contratoWebHookResponseDTO = (ContratoWebHookResponseDTO)this.restTemplate.exchange(urlCadastroContratoWebHook, HttpMethod.POST, new HttpEntity((Object)request, (MultiValueMap)httpHeaders), ContratoWebHookResponseDTO.class, new Object[0]).getBody();
        }
        catch (HttpClientErrorException e) {
            this.convertClientError(e);
        }
        catch (Exception e) {
            throw new EloValidationException(String.format("Erro ao tentar cadastrar as informa\u00e7\u00f5es do WebHook. %s", e.getMessage()));
        }
    }

    private void atualizarWebHookArrecadacao(Convenio convenio, HttpHeaders httpHeaders, String apiUrl, String status, ContratoWebHookResponseDTO contratoWebHookResponseDTO) {
        String urlWebHook = this.getUrlWebHookElotech(convenio);
        ContratoWebHookRequestDTO request = ContratoWebHookRequestDTO.from((Convenio)convenio, (String)urlWebHook, (String)status);
        String urlAtualizarContratoWebHook = String.format("%s%s%s", apiUrl, URL_CONTRATOS_WEB_HOOK, contratoWebHookResponseDTO.getIdContrato());
        try {
            RestTemplate restTemplate = new RestTemplate();
            restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler());
            restTemplate.exchange(urlAtualizarContratoWebHook, HttpMethod.PUT, new HttpEntity((Object)request, (MultiValueMap)httpHeaders), ContratoWebHookResponseDTO.class, new Object[0]);
        }
        catch (Exception e) {
            throw new EloValidationException(String.format("Erro ao tentar atualizar as informa\u00e7\u00f5es do WebHook. %s", e.getMessage()));
        }
    }

    private RestTemplate getRestTemplate(SicrediPixCertificado sicrediPixCertificado) {
        try {
            return RestTemplateUtils.getRestTemplateComCertificado((byte[])sicrediPixCertificado.getCertificado(), (String)sicrediPixCertificado.getSenhaCertificado(), (String)sicrediPixCertificado.getNomeArquivoCertificado());
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    private void convertClientError(HttpClientErrorException e) {
        try {
            String responseBody = e.getResponseBodyAsString();
            ContratoWebHookResponseErrorDTO error = (ContratoWebHookResponseErrorDTO)new ObjectMapper().readValue(responseBody, ContratoWebHookResponseErrorDTO.class);
            throw new RestException(e.getStatusCode(), error.toString(), (Throwable)e);
        }
        catch (JsonProcessingException jsonEx) {
            throw new RestException(HttpStatus.BAD_REQUEST, "Erro ao processar resposta", (Throwable)jsonEx);
        }
    }

    @Generated
    public SicrediPixPagoService(PagamentoLoteService pagamentoLoteService, ContextService contextService, ValidaDataMovimentacaoService validaDataMovimentacaoService, BloquetoService boletoService, BaixaAutomaticaDetalheService baixaAutomaticaDetalheService, ParametroGeralService parametroGeralService, ParametroPixRepository parametroPixRepository, TipoMensagemService tipoMensagemService, IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository, PlatformTransactionManager transactionManager, DebitoParcelaService debitoParcelaService, ConfigurableEnvironment environment, AutenticacaoSicrediService autenticacaoSicrediService, RestTemplate restTemplate) {
        this.pagamentoLoteService = pagamentoLoteService;
        this.contextService = contextService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
        this.boletoService = boletoService;
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
        this.parametroGeralService = parametroGeralService;
        this.parametroPixRepository = parametroPixRepository;
        this.tipoMensagemService = tipoMensagemService;
        this.integracaoPixPagoLogRepository = integracaoPixPagoLogRepository;
        this.transactionManager = transactionManager;
        this.debitoParcelaService = debitoParcelaService;
        this.environment = environment;
        this.autenticacaoSicrediService = autenticacaoSicrediService;
        this.restTemplate = restTemplate;
    }
}

