/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.sicoob;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.CertificadoSicoobDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.DadosHeaderSicoob;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.DadosTokenSicoob;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.exception.integracao.boleto.sicoob.AutenticacaoSicoobException;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoTokenService;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AutenticacaoSicoobService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutenticacaoSicoobService.class);
    private final ParametroGeralService parametroGeralService;
    private final ObjectMapper mapper;
    private final List<IntegracaoTokenService> integracaoTokenServices;
    private static final String SCOPE_API_V2 = "cobranca_boletos_incluir cobranca_boletos_consultar cobranca_boletos_pagador cobranca_boletos_solicitacao_movimentacao_consultar cobranca_boletos_solicitacao_movimentacao_incluir cobranca_boletos_solicitacao_movimentacao_download";
    private static final String SCOPE_API_V3 = "boletos_inclusao boletos_consulta boletos_alteracao webhooks_alteracao webhooks_consulta webhooks_inclusao";
    private static final String API_V2 = "v2";
    private static final String AUTHORIZATION = "Authorization";
    private static final String TOKEN_BEARER = "Bearer %s";
    private static final String BODY_GRANT_TYPE = "grant_type";
    private static final String BODY_VALUE_CLIENT_CREDENTIALS = "client_credentials";
    private static final String BODY_CLIENT_ID = "client_id";
    private static final String BODY_SCOPE = "scope";
    private static final String TAG_ACCESS_TOKEN = "access_token";
    private static final String TAG_MESSAGE = "message";
    private static final String TIPO_TOKEN_JWT = "JWT";

    public String getAccessToken(byte[] certificado, String senhaCertificado, String nomeArquivo, String scope, String clientId, IntegracaoTokenOperation tokenOperation) {
        IntegracaoTokenService tokenService = this.getTokenService();
        Optional accessToken = tokenService.getAccessToken(Banco.CODIGO_SICOOB, tokenOperation);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)clientId)) {
            throw new AutenticacaoSicoobException(HttpStatus.BAD_REQUEST, "N\u00e3o foi informado o clientId parea recuperar o token.");
        }
        if (tokenOperation == null) {
            throw new AutenticacaoSicoobException(HttpStatus.BAD_REQUEST, "N\u00e3o foi informada o tipo de opera\u00e7\u00e3o para recuperar de token.");
        }
        if (accessToken.isPresent()) {
            return (String)accessToken.get();
        }
        JsonNode response = this.generateNewAccessToken(certificado, senhaCertificado, nomeArquivo, scope, clientId);
        return tokenService.saveIntegracaoToken(Banco.CODIGO_SICOOB, tokenOperation, response);
    }

    private JsonNode generateNewAccessToken(byte[] certificado, String senhaCertificado, String nomeArquivo, String scope, String clientId) {
        String oauthUrl = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_OAUTH_URL);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)BODY_GRANT_TYPE, (Object)BODY_VALUE_CLIENT_CREDENTIALS);
        body.add((Object)BODY_CLIENT_ID, (Object)clientId);
        body.add((Object)BODY_SCOPE, (Object)scope);
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            JsonNode response = (JsonNode)RestTemplateUtils.getRestTemplateComCertificado((byte[])certificado, (String)senhaCertificado, (String)nomeArquivo).exchange(oauthUrl, HttpMethod.POST, httpEntity, JsonNode.class, new Object[0]).getBody();
            if (Objects.isNull(response) || !response.has(TAG_ACCESS_TOKEN)) {
                throw new AutenticacaoSicoobException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel buscar o token.");
            }
            return response;
        }
        catch (RestException e) {
            JsonNode jsonNode = this.converteErroResposta(e.getMessage());
            if (jsonNode.has(TAG_MESSAGE)) {
                throw new AutenticacaoSicoobException(e.getStatus(), jsonNode.get(TAG_MESSAGE).asText(), (Exception)((Object)e));
            }
            throw e;
        }
        catch (Exception ex) {
            throw new AutenticacaoSicoobException(HttpStatus.INTERNAL_SERVER_ERROR, ex.getMessage(), ex);
        }
    }

    private String getParametro(ParametroGeralEnum parametroGeralEnum) {
        try {
            String valor = this.parametroGeralService.getParamValueAsString(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (Objects.isNull(valor) || StringUtils.isEmpty((String)valor)) {
                throw new ParametroNaoEncontradoException(parametroGeralEnum.getDescricao());
            }
            return valor;
        }
        catch (ParametroNaoEncontradoException e) {
            throw new AutenticacaoSicoobException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    private JsonNode converteErroResposta(String json) {
        try {
            return (JsonNode)this.mapper.readValue(json, JsonNode.class);
        }
        catch (JsonProcessingException e) {
            log.error("Erro ao ler o json do retorno com erro. " + json, (Throwable)e);
            throw new AutenticacaoSicoobException(HttpStatus.INTERNAL_SERVER_ERROR, "Erro ao ler o json do retorno com erro do endpoint de Autentica\u00e7\u00e3o do Banco Sicoob." + json);
        }
    }

    private IntegracaoTokenService getTokenService() {
        return this.integracaoTokenServices.stream().filter(s -> s.accept(TIPO_TOKEN_JWT)).findFirst().orElseThrow(() -> new AutenticacaoSicoobException(HttpStatus.BAD_REQUEST, "N\u00e3o encontrado service para lidar com o tipo de token JWT"));
    }

    public boolean isApiV2(String urlApiBoleto) {
        return urlApiBoleto.toUpperCase().contains(API_V2.toUpperCase());
    }

    public String getApiScope(String urlApiBoleto) {
        return this.isApiV2(urlApiBoleto) ? SCOPE_API_V2 : SCOPE_API_V3;
    }

    public DadosHeaderSicoob builderDadosHeaders(ParametroPix parametroPix, DadosTokenSicoob dadosTokenSicoob) {
        this.validarDadosTokenSicoob(dadosTokenSicoob);
        return DadosHeaderSicoob.builder().certificadoSicoobDTO(this.builderCertificado(parametroPix)).dadosTokenSicoob(dadosTokenSicoob).build();
    }

    private CertificadoSicoobDTO builderCertificado(ParametroPix parametroPix) {
        if (parametroPix == null || parametroPix.getSenhaCertificadoSicoob() == null) {
            throw new AutenticacaoSicoobException(HttpStatus.BAD_REQUEST, "ParametroPix com os dados do certificado n\u00e3o pode ser nulo ao construir certificado.");
        }
        this.validarCamposCertificado(parametroPix);
        return CertificadoSicoobDTO.builder().certificadoSicoob(parametroPix.getCertificadoSicoob()).nomeArquivoCertificadoSicoob(parametroPix.getNomeArquivoCertificadoSicoob()).senhaCertificadoSicoob(parametroPix.getSenhaCertificadoSicoob()).build();
    }

    private void validarCamposCertificado(ParametroPix p) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)p.getSenhaCertificadoSicoob())) {
            throw new AutenticacaoSicoobException(HttpStatus.BAD_REQUEST, "O campo senhaCertificadoSicoob \u00e9 obrigat\u00f3rio.");
        }
    }

    private void validarDadosTokenSicoob(DadosTokenSicoob dadosTokenSicoob) {
        if (dadosTokenSicoob == null) {
            throw new AutenticacaoSicoobException(HttpStatus.BAD_REQUEST, "DADOSTOKENSICOOB n\u00e3o pode ser nulo.");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dadosTokenSicoob.getScope())) {
            throw new AutenticacaoSicoobException(HttpStatus.BAD_REQUEST, "O campo SCOPE de DadosTokenSicoob n\u00e3o pode ser nulo ou vazio.");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dadosTokenSicoob.getClientId())) {
            throw new AutenticacaoSicoobException(HttpStatus.BAD_REQUEST, "O campo CLIENTID de DadosTokenSicoob n\u00e3o pode ser nulo ou vazio.");
        }
        if (dadosTokenSicoob.getIntegracaoTokenOperation() == null) {
            throw new AutenticacaoSicoobException(HttpStatus.BAD_REQUEST, "IntegracaoTokenOperation de DadosTokenSicoob n\u00e3o pode ser nulo.");
        }
    }

    public HttpHeaders builderHeaders(DadosHeaderSicoob dadosHeaderSicoob) {
        try {
            String token = this.getAccessToken(dadosHeaderSicoob.getCertificadoSicoobDTO().getCertificadoSicoob(), dadosHeaderSicoob.getCertificadoSicoobDTO().getSenhaCertificadoSicoob(), dadosHeaderSicoob.getCertificadoSicoobDTO().getNomeArquivoCertificadoSicoob(), dadosHeaderSicoob.getDadosTokenSicoob().getScope(), dadosHeaderSicoob.getDadosTokenSicoob().getClientId(), dadosHeaderSicoob.getDadosTokenSicoob().getIntegracaoTokenOperation());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set(AUTHORIZATION, String.format(TOKEN_BEARER, token));
            headers.set(BODY_CLIENT_ID, dadosHeaderSicoob.getDadosTokenSicoob().getClientId());
            return headers;
        }
        catch (Exception e) {
            throw new AutenticacaoSicoobException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Erro ao montar o header: %s", e.getMessage()));
        }
    }

    public RestTemplate getRestTemplate(CertificadoSicoobDTO certificadoSicoobDTO) {
        try {
            return RestTemplateUtils.getRestTemplateComCertificado((byte[])certificadoSicoobDTO.getCertificadoSicoob(), (String)certificadoSicoobDTO.getSenhaCertificadoSicoob(), (String)certificadoSicoobDTO.getNomeArquivoCertificadoSicoob());
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new AutenticacaoSicoobException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), e);
        }
    }

    @Generated
    public AutenticacaoSicoobService(ParametroGeralService parametroGeralService, ObjectMapper mapper, List<IntegracaoTokenService> integracaoTokenServices) {
        this.parametroGeralService = parametroGeralService;
        this.mapper = mapper;
        this.integracaoTokenServices = integracaoTokenServices;
    }
}

