/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.delbank;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.BoletoDebitoID;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.MovimentacaoDiariaId;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoArquivoRetornoPagamento;
import br.com.elotech.tributos.domain.TipoOperacaoDebito;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoDetalhe;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoLog;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.pagamento.TipoPagamentoLote;
import br.com.elotech.tributos.domain.tipomensagem.ClassificacaoTipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.CertificadoDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.WebHookDadosDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.WebHookRequestDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.WebHookResponseDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.enums.StatusPixDelbank;
import br.com.elotech.tributos.dto.pagamento.ImportacaoPixPagoResultadoDTO;
import br.com.elotech.tributos.dto.pagamento.solicitacaopagamento.SolicitacaoPagamentoDTO;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoPixPagoLogRepository;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ConvenioService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.TipoMensagemService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPixPagoService;
import br.com.elotech.tributos.service.integracaoboleto.delbank.DelBankService;
import br.com.elotech.tributos.util.AmbienteUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.MultiValueMap;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DelbankPixPagoService
implements IntegracaoPixPagoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DelbankPixPagoService.class);
    private static final DateTimeFormatter FORMATO_NOME_ARQUIVO = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    private static final String END_WEBHOOK = "/baas/api/v1/webhooks/";
    private final ConfigurableEnvironment environment;
    private final ContextService contextService;
    private final BloquetoService boletoService;
    private final DebitoParcelaService debitoParcelaService;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository;
    private final TipoMensagemService tipoMensagemService;
    private final BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;
    private final PagamentoLoteService pagamentoLoteService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;
    private final DelBankService delBankService;
    private final ConvenioService convenioService;

    public ImportacaoPixPagoResultadoDTO importarPixPago(Convenio convenio, LocalDate dataReferencia) {
        throw new EloValidationException("Integra\u00e7\u00e3o para receber pix pagos para o banco delbank n\u00e3o implementada.");
    }

    public Boolean accept(Convenio convenio) {
        return Banco.CODIGO_DELBANK.equals(convenio.getBanco().getId());
    }

    public IntegracaoPixPagoLog processarPixPagosWebHook(JsonNode pixPagos, Convenio convenio, IntegracaoPixPagoLog log) {
        if (!Boolean.TRUE.equals(convenio.getUtilizaPix()) || !Banco.CODIGO_DELBANK.equals(convenio.getBanco().getId())) {
            throw new EloValidationException(String.format("Banco %s com conv\u00eanio %d n\u00e3o possui PIX", convenio.getBanco().getDescricao(), convenio.getId()));
        }
        Long entidade = this.contextService.getEntidadePrincipal();
        List delbankPixPagos = WebHookDadosDelBankDTO.from((JsonNode)pixPagos);
        LocalDate dataReferencia = this.getDataReferencia((WebHookDadosDelBankDTO)delbankPixPagos.get(0));
        log.setDataReferencia(dataReferencia);
        log.setQuantidadeRegistros(Integer.valueOf(delbankPixPagos.size()));
        if (Boolean.TRUE.equals(convenio.getCriarLotePgtPix())) {
            this.processaLotePagamentoPix(convenio, log, delbankPixPagos, dataReferencia, entidade);
        } else {
            this.processarPixPago(delbankPixPagos, log, convenio);
        }
        return log;
    }

    public void togglePixBoletoPagoWebhook(Convenio convenio) {
        boolean status;
        CertificadoDelBankDTO certificadoDelBankDTO = this.delBankService.getCertificado();
        boolean bl = status = convenio.getWebhookPixAtivo() == false;
        if (status) {
            this.activatePixWebhook(convenio, certificadoDelBankDTO);
        } else {
            this.deactivatePixWebhook(convenio, certificadoDelBankDTO);
        }
    }

    private void processaLotePagamentoPix(Convenio convenio, IntegracaoPixPagoLog log, List<WebHookDadosDelBankDTO> listPixPagos, LocalDate dataReferencia, Long entidade) {
        try {
            List baixaAutomaticaDetalhes = this.processarPixPagoLote(listPixPagos, log, convenio);
            if (!baixaAutomaticaDetalhes.isEmpty()) {
                PagamentoLote lote = this.getPagamentoLote(convenio, dataReferencia, entidade, new ImportacaoPixPagoResultadoDTO());
                AtomicLong sequence = new AtomicLong(this.baixaAutomaticaDetalheService.getUltimaSequenciaLote(lote.getId()));
                this.salvarItensGerados(baixaAutomaticaDetalhes, lote, sequence);
                log.setQuantidadeBaixasGeradas(Integer.valueOf(baixaAutomaticaDetalhes.size()));
            }
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            log.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.salvarIntegracaoBoletoPixPagoLog(log);
        }
    }

    private PagamentoLote getPagamentoLote(Convenio convenio, LocalDate dataReferencia, Long entidade, ImportacaoPixPagoResultadoDTO resultado) {
        this.validaMovimentacao(entidade, dataReferencia);
        Optional loteJaExistente = this.pagamentoLoteService.findAbertoByConvenioAndData(convenio, dataReferencia);
        resultado.setLoteNovo(Boolean.valueOf(loteJaExistente.isEmpty()));
        return loteJaExistente.orElseGet(() -> this.createPagamentoLote(convenio, entidade, dataReferencia));
    }

    private PagamentoLote createPagamentoLote(Convenio convenio, Long entidade, LocalDate dataReferencia) {
        Long exercicio = this.contextService.getExercicioAtual();
        PagamentoLoteId id = new PagamentoLoteId();
        id.setEntidade(entidade);
        id.setExercicio(exercicio);
        PagamentoLote pagamentoLote = new PagamentoLote();
        pagamentoLote.setId(id);
        pagamentoLote.setDataLote(LocalDate.now());
        pagamentoLote.setDataMovimento(dataReferencia);
        pagamentoLote.setDataCredito(dataReferencia);
        pagamentoLote.setSituacao(SituacaoPagamentoLote.ABERTO);
        pagamentoLote.setTipo(TipoPagamentoLote.PIX);
        pagamentoLote.setConvenio(convenio);
        pagamentoLote.setContaBancaria(convenio.getContaBancaria());
        pagamentoLote.setBanco(convenio.getBanco());
        pagamentoLote.setArquivoRetorno(Boolean.FALSE);
        pagamentoLote.setLoteManual(Boolean.FALSE);
        pagamentoLote.setNumeroBaixas(Long.valueOf(0L));
        pagamentoLote.setTipoArquivo(TipoArquivoRetornoPagamento.RETORNO_PIX);
        pagamentoLote.setObservacao("Lote gerado pela importa\u00e7\u00e3o de pix");
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime dataReferenciaComHoraAtual = dataReferencia.atTime(now.getHour(), now.getMinute(), now.getSecond());
        pagamentoLote.setNomeArquivo(String.format("importacao_pix_%d_%s", convenio.getConvenio(), FORMATO_NOME_ARQUIVO.format(dataReferenciaComHoraAtual)));
        return (PagamentoLote)this.pagamentoLoteService.save((EloEntity)pagamentoLote, null);
    }

    private void validaMovimentacao(Long entidade, LocalDate dataReferencia) {
        MovimentacaoDiariaId movimentacaoDiariaId = new MovimentacaoDiariaId();
        movimentacaoDiariaId.setEntidade(entidade);
        movimentacaoDiariaId.setData(dataReferencia);
        this.validaDataMovimentacaoService.verificaMovimentacaoDiaria(movimentacaoDiariaId);
    }

    private void salvarItensGerados(List<BaixaAutomaticaDetalhe> itensGerados, PagamentoLote lote, AtomicLong sequencia) {
        itensGerados.forEach(baixaAutomaticaDetalhe -> {
            BaixaAutomaticaDetalheId id = new BaixaAutomaticaDetalheId();
            id.setSequenciaArquivo(Long.valueOf(sequencia.incrementAndGet()));
            id.setLote(lote.getId().getLote());
            id.setEntidade(lote.getId().getEntidade());
            id.setExercicio(lote.getId().getExercicio());
            baixaAutomaticaDetalhe.setId(id);
            baixaAutomaticaDetalhe.setPagamentoLote(lote);
            baixaAutomaticaDetalhe.setDataCredito(lote.getDataCredito());
            baixaAutomaticaDetalhe.setDataPagamento(lote.getDataMovimento());
            baixaAutomaticaDetalhe.setContaBancaria(lote.getContaBancaria());
            baixaAutomaticaDetalhe.setConvenio(lote.getConvenio());
            baixaAutomaticaDetalhe.setBanco(lote.getBanco());
            this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        });
        Long numeroBaixasAtual = Optional.ofNullable(lote.getNumeroBaixas()).orElse(0L);
        lote.setNumeroBaixas(Long.valueOf(numeroBaixasAtual + (long)itensGerados.size()));
    }

    private List<BaixaAutomaticaDetalhe> processarPixPagoLote(List<WebHookDadosDelBankDTO> listPixPago, IntegracaoPixPagoLog log, Convenio convenio) {
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.IMPORTADO);
        return listPixPago.stream().map(pix -> {
            IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
            log.getDetalhes().add(detalhe);
            try {
                Bloqueto bloqueto = this.getBloqueto(pix, detalhe, convenio);
                if (Objects.isNull(bloqueto)) {
                    return null;
                }
                if (this.baixaAutomaticaDetalheService.existsByBoleto(bloqueto)) {
                    detalhe.setObservacao("Boleto j\u00e1 importado");
                    return null;
                }
                detalhe.setObservacao("Boleto importado com sucesso");
                return DelbankPixPagoService.getBaixaAutomaticaDetalhe((WebHookDadosDelBankDTO)pix, (Bloqueto)bloqueto, (TipoMensagem)tipoMensagem);
            }
            catch (Exception ex) {
                detalhe.setMensagemErro(ex.toString());
                DelbankPixPagoService.log.error("Ocorreu um erro ao processar pix pagos {}", (Object)ex.getMessage(), (Object)ex);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static BaixaAutomaticaDetalhe getBaixaAutomaticaDetalhe(WebHookDadosDelBankDTO pix, Bloqueto bloqueto, TipoMensagem tipoMensagem) {
        BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = new BaixaAutomaticaDetalhe();
        baixaAutomaticaDetalhe.setBoleto(bloqueto);
        baixaAutomaticaDetalhe.setNossoNumero(bloqueto.getNossoNumero());
        baixaAutomaticaDetalhe.setSituacao(ClassificacaoTipoMensagem.IMPORTADO);
        baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.IMPORTADO.getDescricao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setDataVencimento(bloqueto.getDataVencimento());
        baixaAutomaticaDetalhe.setDataCreditoArquivo(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setDataPagamentoArquivo(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setDiferencaEmValor(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setDiferencaMaxima(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setAlterado(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setDescontoConcedido(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setCreditoConcedido(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setValor(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setValorPago(pix.getValor());
        baixaAutomaticaDetalhe.setValorPagoPrincipal(pix.getValor());
        baixaAutomaticaDetalhe.setValorPagoJuros(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setValorPagoMulta(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setTipoOperacao(TipoOperacaoDebito.NENHUMA_OPERACAO);
        return baixaAutomaticaDetalhe;
    }

    private void processarPixPago(List<WebHookDadosDelBankDTO> listPixPago, IntegracaoPixPagoLog log, Convenio convenio) {
        try {
            listPixPago.forEach(pix -> {
                IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
                if (!pix.getStatusRecebimento().equals((Object)StatusPixDelbank.PIX_EFETIVADO)) {
                    detalhe.setObservacao(String.format("STATUS DO PIX NAO EFETIVADO %s", pix.getStatusRecebimento()));
                    log.getDetalhes().add(detalhe);
                    return;
                }
                Bloqueto bloqueto = this.getBloqueto(pix, detalhe, convenio);
                if (Objects.isNull(bloqueto)) {
                    return;
                }
                bloqueto.getDebitos().stream().map(BoletoDebito::getId).map(BoletoDebitoID::getDebitoParcelaTributo).map(DebitoParcelaTributo::getDebitoParcela).distinct().forEach(arg_0 -> ((DebitoParcelaService)this.debitoParcelaService).pagarParcelaWebHookPix(arg_0));
                log.getDetalhes().add(detalhe);
            });
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            log.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.salvarIntegracaoBoletoPixPagoLog(log);
        }
    }

    private Bloqueto getBloqueto(WebHookDadosDelBankDTO pix, IntegracaoPixPagoDetalhe detalhe, Convenio convenio) {
        detalhe.setTxid(pix.getCorrelationId());
        if (StringUtils.isNotBlank((String)pix.getCorrelationId())) {
            detalhe.setTxid(pix.getCorrelationId());
            detalhe.setBuscaPorE2E(Boolean.FALSE);
        }
        if (StringUtils.isBlank((String)detalhe.getTxid())) {
            detalhe.setObservacao("N\u00e3o foi possivel encontrar o Txid do pagamento Pix");
            return null;
        }
        Optional bloqueto = this.boletoService.findByTxid(detalhe.getTxid());
        if (bloqueto.isEmpty()) {
            detalhe.setObservacao("N\u00e3o foi possivel encontrar o boleto com o Txid informado");
            return null;
        }
        detalhe.setBoleto(((Bloqueto)bloqueto.get()).getBloqueto());
        detalhe.setExercicioboleto(((Bloqueto)bloqueto.get()).getExercicioBloqueto());
        detalhe.setEntidade(((Bloqueto)bloqueto.get()).getEntidade());
        return (Bloqueto)bloqueto.get();
    }

    @NotNull
    public String getUrlWebHook(Convenio convenio) {
        return String.format("%s/api/integracao-boleto/%d/webhook/pix", AmbienteUtils.getCurrentURL((ConfigurableEnvironment)this.environment), convenio.getId());
    }

    private void salvarIntegracaoBoletoPixPagoLog(IntegracaoPixPagoLog integracaoPixPagoLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoPixPagoLog)this.integracaoPixPagoLogRepository.save((Object)integracaoPixPagoLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public LocalDate getDataReferencia(WebHookDadosDelBankDTO dadosWebHookDTO) {
        String timestamp = Optional.ofNullable(dadosWebHookDTO.getDataReferencia()).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel obter a data de refer\u00eancia dos pix pagos."));
        if (timestamp.contains(".")) {
            timestamp = timestamp.substring(0, timestamp.indexOf(46));
        }
        DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE;
        try {
            return LocalDate.parse(timestamp, formatter);
        }
        catch (DateTimeParseException e) {
            throw new EloValidationException("Erro ao converter a data de refer\u00eancia: " + e.getMessage());
        }
    }

    public void activatePixWebhook(Convenio convenio, CertificadoDelBankDTO certificadoDelBankDTO) {
        try {
            HttpHeaders headers = this.delBankService.criarHeaders();
            WebHookRequestDelBankDTO dto = WebHookRequestDelBankDTO.from((String)this.getUrlWebHook(convenio));
            HttpEntity request = new HttpEntity((Object)dto, (MultiValueMap)headers);
            String url = String.format("%s%s", this.delBankService.getParametro(ParametroGeralEnum.BOLETO_DELBANK_URL), "/baas/api/v1/webhooks/");
            WebHookResponseDelBankDTO webHookResponseDelBankDTO = (WebHookResponseDelBankDTO)this.delBankService.getRestTemplate(certificadoDelBankDTO.getArquivoCertificado(), certificadoDelBankDTO.getSenhaCertificado(), certificadoDelBankDTO.getNomeArquivo()).exchange(url, HttpMethod.POST, request, WebHookResponseDelBankDTO.class, new Object[0]).getBody();
            convenio.setIdCadastroWebHook(webHookResponseDelBankDTO.getId());
        }
        catch (Exception e) {
            throw new EloValidationException(String.format("Erro ao ativar webhook do pix, %s", e.getMessage()));
        }
    }

    private void deactivatePixWebhook(Convenio convenio, CertificadoDelBankDTO certificadoDelBankDTO) {
        try {
            HttpHeaders headers = this.delBankService.criarHeaders();
            HttpEntity request = new HttpEntity(null, (MultiValueMap)headers);
            String url = String.format("%s%s%s", this.delBankService.getParametro(ParametroGeralEnum.BOLETO_DELBANK_URL), "/baas/api/v1/webhooks/", convenio.getIdCadastroWebHook());
            this.delBankService.getRestTemplate(certificadoDelBankDTO.getArquivoCertificado(), certificadoDelBankDTO.getSenhaCertificado(), certificadoDelBankDTO.getNomeArquivo()).exchange(url, HttpMethod.DELETE, request, JsonNode.class, new Object[0]).getBody();
            convenio.setIdCadastroWebHook(null);
        }
        catch (Exception e) {
            throw new EloValidationException(String.format("Erro ao desativar webhook do pix, %s", e.getMessage()));
        }
    }

    public SolicitacaoPagamentoDTO solicitarArquivoPagamento(Convenio convenio, LocalDate dataReferencia) {
        throw new EloValidationException("Integra\u00e7\u00e3o para solicitar arquivo de pagamento para o banco Delbank n\u00e3o implementada.");
    }

    public List<ImportacaoPixPagoResultadoDTO> importarSolicitacaoPagamento(Convenio convenio, LocalDate dataReferencia, Long codigoSolicitacao) {
        throw new EloValidationException("Integra\u00e7\u00e3o para importar arquivo de pagamento para o banco Delbank n\u00e3o implementada.");
    }

    @Generated
    public DelbankPixPagoService(ConfigurableEnvironment environment, ContextService contextService, BloquetoService boletoService, DebitoParcelaService debitoParcelaService, PlatformTransactionManager transactionManager, IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository, TipoMensagemService tipoMensagemService, BaixaAutomaticaDetalheService baixaAutomaticaDetalheService, PagamentoLoteService pagamentoLoteService, ValidaDataMovimentacaoService validaDataMovimentacaoService, DelBankService delBankService, ConvenioService convenioService) {
        this.environment = environment;
        this.contextService = contextService;
        this.boletoService = boletoService;
        this.debitoParcelaService = debitoParcelaService;
        this.transactionManager = transactionManager;
        this.integracaoPixPagoLogRepository = integracaoPixPagoLogRepository;
        this.tipoMensagemService = tipoMensagemService;
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
        this.pagamentoLoteService = pagamentoLoteService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
        this.delBankService = delBankService;
        this.convenioService = convenioService;
    }
}

