/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.bancodobrasil;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.gateway.enums.TipoPessoa;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.CertificadoBBDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.PagamentoBBPayErrorResponseDTO;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.repository.BancoRepository;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.cnab240.ParametroCNAB240Repository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ConvenioService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoTokenService;
import br.com.elotech.tributos.service.integracaoboleto.bancodobrasil.BbOauth;
import br.com.elotech.tributos.util.AmbienteUtils;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class BbUtilsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BbUtilsService.class);
    private final ObjectMapper mapper;
    private final List<IntegracaoTokenService> integracaoTokenServices;
    private final ParametroGeralService parametroGeralService;
    private final RestTemplate restTemplate;
    private final ParametroPixRepository parametroPixRepository;
    private final ContextService contextService;
    private final ParametroCNAB240Repository parametroCNAB240Repository;
    private final BancoRepository bancoRepository;
    private final ConvenioService convenioService;
    private final ConfigurableEnvironment configurableEnvironment;
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_TYPE_JSON = "application/json;charset=UTF-8";
    public static final String BB_OAUTH_GRANT_TYPE = "client_credentials";
    public static final String BBPAY_SCOPE = "checkout.solicitacoes-info checkout.solicitacoes-requisicao checkout.pagamentos-info checkout.pagamentos-requisicao checkout.devolucoes-info checkout.devolucoes-requisicao checkout.participantes-info checkout.participantes-requisicao";
    private static final String GW_APP_KEY_BBPAY = "gw-dev-app-key";
    private static final String GRANT_TYPE = "grant_type";
    private static final String SCOPE = "scope";
    private static final String AUTHORIZATION_BEARER_TOKEN = "Bearer";
    private static final String AUTHORIZATION_BASIC_TOKEN = "Basic";
    public static final String PARAMETRO_NUMERO_CONVENIO = "numeroConvenio";
    public static final String ACCCES_TOKEN = "access_token";
    private static final String ACCEPT_DEFAULT = "DEFAULT";

    public <T> T converteErroResposta(String json, Class<T> valueType) {
        try {
            return (T)this.mapper.readValue(json, valueType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public HttpHeaders criarHeaders(BbOauth bbOauth) {
        HttpHeaders headers = new HttpHeaders();
        headers.set(HEADER_AUTHORIZATION, String.format("%s %s", AUTHORIZATION_BEARER_TOKEN, this.getAccessToken(bbOauth)));
        headers.set(HEADER_CONTENT_TYPE, HEADER_CONTENT_TYPE_JSON);
        return headers;
    }

    public String getAccessToken(BbOauth bbOauth) {
        IntegracaoTokenService tokenService = this.getTokenService();
        Optional accessToken = tokenService.getAccessToken(Long.valueOf(bbOauth.getCodBanco()), bbOauth.getOperacaoBanco());
        if (accessToken.isPresent()) {
            return (String)accessToken.get();
        }
        JsonNode response = this.generateNewAccessToken(bbOauth);
        return tokenService.saveIntegracaoToken(Long.valueOf(bbOauth.getCodBanco()), bbOauth.getOperacaoBanco(), response);
    }

    private IntegracaoTokenService getTokenService() {
        return this.integracaoTokenServices.stream().filter(s -> s.accept(ACCEPT_DEFAULT)).findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o encontrado service para lidar com o tipo de token DEFAULT"));
    }

    public JsonNode generateNewAccessToken(BbOauth bbOauth) {
        HttpEntity httpEntity;
        JsonNode response;
        String oauthUrl = bbOauth.getUrl();
        String clientId = bbOauth.getClientId();
        String clientSecret = bbOauth.getClientSecret();
        String authorizationBase64 = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.set(HEADER_AUTHORIZATION, String.format("%s %s", AUTHORIZATION_BASIC_TOKEN, authorizationBase64));
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)GRANT_TYPE, (Object)BB_OAUTH_GRANT_TYPE);
        if (bbOauth.getOperacaoBanco().equals((Object)IntegracaoTokenOperation.BOLETO_HIBRIDO)) {
            body.add((Object)SCOPE, (Object)bbOauth.getScope());
        }
        if (Objects.isNull(response = (JsonNode)this.restTemplate.exchange(oauthUrl, HttpMethod.POST, httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers), JsonNode.class, new Object[0]).getBody()) || !response.has(ACCCES_TOKEN)) {
            throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel buscar o token.");
        }
        return response;
    }

    public String getParametro(ParametroGeralEnum parametroGeralEnum) {
        try {
            String valor = this.parametroGeralService.getParamValueAsString(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (StringUtils.isEmpty((String)valor)) {
                throw new RestException(HttpStatus.BAD_REQUEST, String.format("O par\u00e2metro %s n\u00e3o foi configurado.", parametroGeralEnum.name()));
            }
            return valor;
        }
        catch (ParametroNaoEncontradoException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public CertificadoBBDTO buscarCertificadoBB() {
        ParametroPix parametroPix = this.parametroPixRepository.getByEntidade(this.contextService.getEntidadePrincipal());
        byte[] certificado = Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoBancoBrasil).orElse(null);
        String senhaCertificado = Optional.ofNullable(parametroPix).map(ParametroPix::getSenhaCertificadoBancoBrasil).orElse(null);
        return CertificadoBBDTO.builder().arquivoCertificado(certificado).senhaCertificado(senhaCertificado).build();
    }

    public ParametroCNAB240 getParametroCnab240ByBanco() {
        return (ParametroCNAB240)this.parametroCNAB240Repository.findFirstByBanco((Banco)this.bancoRepository.findOne((Object)Banco.CODIGO_BANCO_BRASIL)).orElseThrow(() -> new EloValidationException("Par\u00e2metro CNAB 240 n\u00e3o encontrado para o Banco do Brasil!"));
    }

    public BbOauth montarOauthBBPay() {
        return this.criarBBOauth(ParametroGeralEnum.BOLETO_BB_PAY_CLIENTID, ParametroGeralEnum.BOLETO_BB_PAY_CLIENTSECRET, BBPAY_SCOPE, IntegracaoTokenOperation.BOLETO_HIBRIDO);
    }

    public BbOauth montarOauthBB() {
        return this.criarBBOauth(ParametroGeralEnum.BOLETO_BB_OAUTH_CLIENTID, ParametroGeralEnum.BOLETO_BB_OAUTH_CLIENTSECRET, null, IntegracaoTokenOperation.BOLETO);
    }

    public BbOauth criarBBOauth(ParametroGeralEnum clientId, ParametroGeralEnum clientSecret, String scope, IntegracaoTokenOperation operacao) {
        return BbOauth.builder().url(this.getParametro(ParametroGeralEnum.BOLETO_BB_OAUTH_URL)).clientId(this.getParametro(clientId)).clientSecret(this.getParametro(clientSecret)).scope(scope).codBanco(Banco.CODIGO_BANCO_BRASIL.longValue()).operacaoBanco(operacao).build();
    }

    public Convenio getConvenio(Long idConvenio) {
        return (Convenio)this.convenioService.findById((Serializable)idConvenio).orElseThrow(() -> new EloValidationException(String.format("Conv\u00eanio %d n\u00e3o encontrado.", idConvenio)));
    }

    public String montarUrlBbPay(String recurso, Map<String, Object> queryParam) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.getParametro(ParametroGeralEnum.BOLETO_BB_PAY_URL)).path(recurso).queryParam(GW_APP_KEY_BBPAY, new Object[]{this.getParametro(ParametroGeralEnum.BOLETO_BB_PAY_DEV_APP_KEY)});
        if (queryParam != null && !queryParam.isEmpty()) {
            queryParam.forEach((x$0, xva$1) -> builder.queryParam(x$0, new Object[]{xva$1}));
        }
        return builder.toUriString();
    }

    public String tratarErrosBBPay(RestException e) {
        PagamentoBBPayErrorResponseDTO dtoErros = (PagamentoBBPayErrorResponseDTO)this.converteErroResposta(e.getMessage(), PagamentoBBPayErrorResponseDTO.class);
        return Optional.ofNullable(dtoErros).filter(PagamentoBBPayErrorResponseDTO::hasErro).map(PagamentoBBPayErrorResponseDTO::getErrosConcatenado).orElse(e.getMessage());
    }

    public static Long retornarCodigoDocumento(String documento) {
        if (documento == null || documento.trim().isEmpty()) {
            throw new EloValidationException("Documento n\u00e3o pode ser nulo ou vazio.");
        }
        TipoPessoa tipoPessoa = TipoPessoa.getFromCpfCnpj((String)documento.toString());
        if (tipoPessoa == null) {
            throw new EloValidationException("Documento inv\u00e1lido. Deve ser CPF (11 d\u00edgitos) ou CNPJ (14 d\u00edgitos).");
        }
        return tipoPessoa.getCodigo();
    }

    public <T> JsonNode executarRequisicaoBB(HttpMethod metodo, String url, T requestBody, CertificadoBBDTO certificadoBBDTO, IntegracaoTokenOperation integracao) throws Exception {
        BbOauth oAauth = this.montarOauthBBPay();
        HttpHeaders headers = this.criarHeaders(oAauth);
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        if (integracao.equals((Object)IntegracaoTokenOperation.BOLETO_HIBRIDO) && !AmbienteUtils.getAmbiente((ConfigurableEnvironment)this.configurableEnvironment).equalsIgnoreCase("oxy")) {
            return (JsonNode)RestTemplateUtils.getRestTemplateNaoValidaCertificado((byte[])certificadoBBDTO.getArquivoCertificado(), (String)certificadoBBDTO.getSenhaCertificado()).exchange(url, metodo, requestEntity, JsonNode.class, new Object[0]).getBody();
        }
        return (JsonNode)RestTemplateUtils.getRestTemplateComCertificado((byte[])certificadoBBDTO.getArquivoCertificado(), (String)certificadoBBDTO.getSenhaCertificado(), null).exchange(url, metodo, requestEntity, JsonNode.class, new Object[0]).getBody();
    }

    @Generated
    public BbUtilsService(ObjectMapper mapper, List<IntegracaoTokenService> integracaoTokenServices, ParametroGeralService parametroGeralService, RestTemplate restTemplate, ParametroPixRepository parametroPixRepository, ContextService contextService, ParametroCNAB240Repository parametroCNAB240Repository, BancoRepository bancoRepository, ConvenioService convenioService, ConfigurableEnvironment configurableEnvironment) {
        this.mapper = mapper;
        this.integracaoTokenServices = integracaoTokenServices;
        this.parametroGeralService = parametroGeralService;
        this.restTemplate = restTemplate;
        this.parametroPixRepository = parametroPixRepository;
        this.contextService = contextService;
        this.parametroCNAB240Repository = parametroCNAB240Repository;
        this.bancoRepository = bancoRepository;
        this.convenioService = convenioService;
        this.configurableEnvironment = configurableEnvironment;
    }
}

